/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.security;

import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.internal.ui.UpdateUI;

public class UserValidationDialog
extends Dialog {
    protected Text usernameField;
    protected Text passwordField;
    protected String domain;
    protected String realm;
    protected String defaultUsername;
    protected String password = null;
    protected String userid = null;
    protected boolean isUsernameMutable = true;

    public UserValidationDialog(Shell parentShell, URL location, String realm, String defaultName) {
        super(parentShell);
        this.defaultUsername = defaultName;
        this.domain = location.getHost();
        this.realm = realm;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UpdateUI.getString("UserVerificationDialog.PasswordRequired"));
    }

    public void create() {
        super.create();
        this.usernameField.setText(this.defaultUsername);
        if (this.isUsernameMutable) {
            this.usernameField.selectAll();
            this.usernameField.setFocus();
        } else {
            this.usernameField.setEditable(false);
            this.passwordField.setFocus();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        Label label = new Label(main, 64);
        String text = String.valueOf(UpdateUI.getString("UserVerificationDialog.EnterNameAndPassword")) + this.realm;
        text = String.valueOf(text) + "\n" + UpdateUI.getString("UserVerificationDialog.Domain") + this.domain;
        label.setText(text);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        this.createUsernameFields(main);
        this.createPasswordFields(main);
        WorkbenchHelp.setHelp((Control)main, (String)"org.eclipse.update.ui.UserValidationDialog");
        return main;
    }

    protected void createPasswordFields(Composite parent) {
        new Label(parent, 0).setText(UpdateUI.getString("UserVerificationDialog.Password"));
        this.passwordField = new Text(parent, 0x400800);
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.passwordField.setLayoutData((Object)data);
        new Label(parent, 0);
    }

    protected void createUsernameFields(Composite parent) {
        new Label(parent, 0).setText(UpdateUI.getString("UserVerificationDialog.UserName"));
        this.usernameField = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.usernameField.setLayoutData((Object)data);
        new Label(parent, 0);
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserid() {
        return this.userid;
    }

    protected void okPressed() {
        this.password = this.passwordField.getText();
        this.userid = this.usernameField.getText();
        super.okPressed();
    }

    public void setUsernameMutable(boolean value) {
        this.isUsernameMutable = value;
    }
}

