/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.security;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.security.UserValidationDialog;

public class UpdateManagerAuthenticator
extends Authenticator {
    public static final String INFO_PASSWORD = "password";
    public static final String INFO_USERNAME = "username";
    public static final String AUTH_SCHEME = "";
    private InetAddress requestingSite;
    private int requestingPort;
    private String requestingProtocol;
    private String requestingPrompt;
    private String requestingScheme;
    private Map savedPasswordAuthentication;
    private Map result = new HashMap();

    public void addAuthenticationInfo(URL serverUrl, String realm, String scheme, Map info) {
        try {
            Platform.addAuthorizationInfo((URL)serverUrl, (String)realm, (String)scheme, (Map)info);
        }
        catch (CoreException e) {
            UpdateUI.logException(e);
        }
    }

    public Map getAuthenticationInfo(URL serverUrl, String realm, String scheme) {
        return Platform.getAuthorizationInfo((URL)serverUrl, (String)realm, (String)scheme);
    }

    public Map requestAuthenticationInfo(URL resourceUrl, String realm, String scheme) {
        InetAddress ip = null;
        try {
            ip = InetAddress.getByName(resourceUrl.getHost());
        }
        catch (UnknownHostException e) {
            UpdateUI.logException(e, false);
        }
        this.requestingPort = resourceUrl.getPort();
        this.requestingPrompt = realm;
        this.requestingProtocol = resourceUrl.getProtocol();
        this.requestingScheme = scheme;
        this.requestingSite = ip;
        Map map = Platform.getAuthorizationInfo((URL)resourceUrl, (String)this.requestingPrompt, (String)this.requestingScheme);
        if (map == null) {
            map = this.retrievePasswordAuthentication(resourceUrl, this.requestingPrompt, this.requestingScheme);
        }
        this.savedPasswordAuthentication = map;
        return this.savedPasswordAuthentication;
    }

    public void addProtectionSpace(URL resourceUrl, String realm) {
        try {
            Platform.addProtectionSpace((URL)resourceUrl, (String)realm);
        }
        catch (CoreException e) {
            UpdateUI.logException(e, false);
        }
    }

    public String getProtectionSpace(URL resourceUrl) {
        return Platform.getProtectionSpace((URL)resourceUrl);
    }

    public void reset() {
        this.requestingPort = 0;
        this.requestingPrompt = null;
        this.requestingProtocol = null;
        this.requestingScheme = null;
        this.requestingSite = null;
    }

    private Map retrievePasswordAuthentication(final URL resourceUrl, final String realm, String scheme) {
        this.result = new HashMap();
        if ("Basic".equalsIgnoreCase(scheme)) {
            Display disp = Display.getCurrent();
            if (disp != null) {
                this.result = this.promptForPassword(resourceUrl, realm);
            } else {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        UpdateManagerAuthenticator.this.result = UpdateManagerAuthenticator.this.promptForPassword(resourceUrl, realm);
                    }
                });
            }
        }
        return this.result;
    }

    private boolean equalsPreviousRequest(URL url, String realm, String scheme) {
        if (this.requestingPort != url.getPort()) {
            return false;
        }
        if (this.requestingPrompt != null && !this.requestingPrompt.equals(realm)) {
            return false;
        }
        if (this.requestingPrompt == null && realm != null) {
            return false;
        }
        if (this.requestingProtocol != null && !this.requestingProtocol.equals(url.getProtocol())) {
            return false;
        }
        if (this.requestingProtocol == null && url.getProtocol() != null) {
            return false;
        }
        if (this.requestingScheme != null && !this.requestingScheme.equals(scheme)) {
            return false;
        }
        if (this.requestingScheme == null && scheme != null) {
            return false;
        }
        InetAddress ip = null;
        try {
            ip = InetAddress.getByName(url.getHost());
        }
        catch (UnknownHostException e) {
            UpdateUI.logException(e, false);
        }
        if (this.requestingSite != null && !this.requestingSite.equals(ip)) {
            return false;
        }
        return this.requestingSite != null || ip == null;
    }

    private Map promptForPassword(URL resourceUrl, String realm) {
        boolean isCancelled;
        HashMap<String, String> result = null;
        Shell shell = new Shell();
        UserValidationDialog ui = new UserValidationDialog(shell, resourceUrl, realm, AUTH_SCHEME);
        ui.setUsernameMutable(true);
        ui.setBlockOnOpen(true);
        ui.open();
        boolean bl = isCancelled = ui.getReturnCode() == 1;
        if (!isCancelled) {
            result = new HashMap<String, String>();
            result.put(INFO_USERNAME, ui.getUserid());
            result.put(INFO_PASSWORD, ui.getPassword());
        }
        shell.dispose();
        return result;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        try {
            URL url = new URL(this.getRequestingProtocol(), this.getRequestingSite().getHostName(), this.getRequestingPort(), AUTH_SCHEME);
            Map map = this.retrievePasswordAuthentication(url);
            String username = null;
            String password = null;
            if (map != null) {
                username = (String)map.get(INFO_USERNAME);
                password = (String)map.get(INFO_PASSWORD);
            }
            if (username != null && password != null) {
                return new PasswordAuthentication(username, password.toCharArray());
            }
            return null;
        }
        catch (MalformedURLException e) {
            IStatus status = Utilities.newCoreException((String)AUTH_SCHEME, (Throwable)e).getStatus();
            UpdateUI.log(status, false);
            return new PasswordAuthentication(AUTH_SCHEME, new char[]{' '});
        }
    }

    private Map retrievePasswordAuthentication(URL url) {
        if (this.equalsPreviousRequest(url, this.getRequestingPrompt(), this.getRequestingScheme())) {
            if (this.savedPasswordAuthentication != null) {
                this.savedPasswordAuthentication = this.requestAuthenticationInfo(url, this.requestingPrompt, this.requestingScheme);
            }
        } else {
            this.requestingPort = this.getRequestingPort();
            this.requestingPrompt = this.getRequestingPrompt();
            this.requestingProtocol = this.getRequestingProtocol();
            this.requestingScheme = this.getRequestingScheme();
            this.requestingSite = this.getRequestingSite();
            this.savedPasswordAuthentication = Platform.getAuthorizationInfo((URL)url, (String)this.requestingPrompt, (String)this.requestingScheme);
            if (this.savedPasswordAuthentication == null) {
                this.savedPasswordAuthentication = this.requestAuthenticationInfo(url, this.requestingPrompt, this.requestingScheme);
            }
        }
        return this.savedPasswordAuthentication;
    }
}

