/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;

public class MainPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text historySizeText;
    private Button checkSignatureCheckbox;
    private Button equivalentButton;
    private Button compatibleButton;
    private Text updatePolicyText;
    private Label httpProxyHostLabel;
    private Label httpProxyPortLabel;
    private Text httpProxyHostText;
    private Text httpProxyPortText;
    private Button enableHttpProxy;
    public static final String EQUIVALENT_VALUE = "equivalent";
    public static final String COMPATIBLE_VALUE = "compatible";

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.update.ui.MainPreferencePage");
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        mainComposite.setLayout((Layout)layout);
        Label historySizeLabel = new Label(mainComposite, 0);
        historySizeLabel.setText(UpdateUI.getString("MainPreferencePage.historySize"));
        this.historySizeText = new Text(mainComposite, 2052);
        this.historySizeText.setLayoutData((Object)new GridData(768));
        this.checkSignatureCheckbox = new Button(mainComposite, 16416);
        this.checkSignatureCheckbox.setText(UpdateUI.getString("MainPreferencePage.checkSignature"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.checkSignatureCheckbox.setLayoutData((Object)gd);
        this.checkSignatureCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!MainPreferencePage.this.checkSignatureCheckbox.getSelection()) {
                    MainPreferencePage.this.warnSignatureCheck(MainPreferencePage.this.getShell());
                }
            }
        });
        this.createSpacer(mainComposite, 2);
        Group group = new Group(mainComposite, 0);
        group.setText(UpdateUI.getString("MainPreferencePage.updateVersions"));
        group.setLayout((Layout)new GridLayout());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        this.equivalentButton = new Button((Composite)group, 16);
        this.equivalentButton.setText(UpdateUI.getString("MainPreferencePage.updateVersions.equivalent"));
        this.compatibleButton = new Button((Composite)group, 16);
        this.compatibleButton.setText(UpdateUI.getString("MainPreferencePage.updateVersions.compatible"));
        this.createSpacer(mainComposite, 2);
        group = new Group(mainComposite, 0);
        group.setText(UpdateUI.getString("MainPreferencePage.updatePolicy"));
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        Label label = new Label((Composite)group, 0);
        label.setText(UpdateUI.getString("MainPreferencePage.updatePolicyURL"));
        this.updatePolicyText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.updatePolicyText.setLayoutData((Object)gd);
        this.createSpacer(mainComposite, 2);
        this.createHttpProxy(mainComposite, 2);
        this.initialize();
        this.updatePolicyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainPreferencePage.this.textChanged();
            }
        });
        return mainComposite;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Dialog.applyDialogFont((Control)this.getControl());
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    protected void createHttpProxy(Composite composite, int columnSpan) {
        Group group = new Group(composite, 0);
        group.setText(UpdateUI.getString("MainPreferencePage.proxyGroup"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = columnSpan;
        group.setLayoutData((Object)gd);
        this.enableHttpProxy = new Button((Composite)group, 32);
        this.enableHttpProxy.setText(UpdateUI.getString("MainPreferencePage.enableHttpProxy"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.enableHttpProxy.setLayoutData((Object)gd);
        this.httpProxyHostLabel = new Label((Composite)group, 0);
        this.httpProxyHostLabel.setText(UpdateUI.getString("MainPreferencePage.httpProxyHost"));
        this.httpProxyHostText = new Text((Composite)group, 2052);
        this.httpProxyHostText.setLayoutData((Object)new GridData(768));
        this.httpProxyPortLabel = new Label((Composite)group, 0);
        this.httpProxyPortLabel.setText(UpdateUI.getString("MainPreferencePage.httpProxyPort"));
        this.httpProxyPortText = new Text((Composite)group, 2052);
        this.httpProxyPortText.setLayoutData((Object)new GridData(768));
        this.enableHttpProxy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enable = MainPreferencePage.this.enableHttpProxy.getSelection();
                MainPreferencePage.this.httpProxyPortLabel.setEnabled(enable);
                MainPreferencePage.this.httpProxyHostLabel.setEnabled(enable);
                MainPreferencePage.this.httpProxyPortText.setEnabled(enable);
                MainPreferencePage.this.httpProxyHostText.setEnabled(enable);
            }
        });
    }

    private int getHistoryCount() {
        try {
            Integer count = new Integer(this.historySizeText.getText());
            return count;
        }
        catch (NumberFormatException numberFormatException) {
            return UpdateCore.getPlugin().getPluginPreferences().getDefaultInt("org.eclipse.update.core.historySize");
        }
    }

    public boolean performOk() {
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    SiteManager.getLocalSite().setMaximumHistoryCount(MainPreferencePage.this.getHistoryCount());
                    SiteManager.setHttpProxyInfo((boolean)MainPreferencePage.this.enableHttpProxy.getSelection(), (String)MainPreferencePage.this.httpProxyHostText.getText(), (String)MainPreferencePage.this.httpProxyPortText.getText());
                }
                catch (CoreException e) {
                    UpdateUI.logException(e);
                }
            }
        });
        Preferences prefs = UpdateCore.getPlugin().getPluginPreferences();
        prefs.setValue("org.eclipse.update.core.checkSignature", this.checkSignatureCheckbox.getSelection());
        prefs.setValue("org.eclipse.update.core.historySize", this.historySizeText.getText());
        prefs.setValue("org.eclipse.update.core.updateVersions", this.equivalentButton.getSelection() ? EQUIVALENT_VALUE : COMPATIBLE_VALUE);
        prefs.setValue(UpdateUtils.P_UPDATE_POLICY_URL, this.updatePolicyText.getText());
        UpdateCore.getPlugin().savePluginPreferences();
        return super.performOk();
    }

    public void performApply() {
        super.performApply();
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                SiteManager.setHttpProxyInfo((boolean)MainPreferencePage.this.enableHttpProxy.getSelection(), (String)MainPreferencePage.this.httpProxyHostText.getText(), (String)MainPreferencePage.this.httpProxyPortText.getText());
            }
        });
        Preferences prefs = UpdateCore.getPlugin().getPluginPreferences();
        prefs.setValue("org.eclipse.update.core.checkSignature", this.checkSignatureCheckbox.getSelection());
        prefs.setValue("org.eclipse.update.core.historySize", this.historySizeText.getText());
        prefs.setValue("org.eclipse.update.core.updateVersions", this.equivalentButton.getSelection() ? EQUIVALENT_VALUE : COMPATIBLE_VALUE);
        prefs.setValue(UpdateUtils.P_UPDATE_POLICY_URL, this.updatePolicyText.getText());
        UpdateCore.getPlugin().savePluginPreferences();
    }

    private void initialize() {
        String portValue;
        this.enableHttpProxy.setSelection(SiteManager.isHttpProxyEnable());
        String serverValue = SiteManager.getHttpProxyServer();
        if (serverValue != null) {
            this.httpProxyHostText.setText(serverValue);
        }
        if ((portValue = SiteManager.getHttpProxyPort()) != null) {
            this.httpProxyPortText.setText(portValue);
        }
        this.httpProxyPortLabel.setEnabled(this.enableHttpProxy.getSelection());
        this.httpProxyHostLabel.setEnabled(this.enableHttpProxy.getSelection());
        this.httpProxyPortText.setEnabled(this.enableHttpProxy.getSelection());
        this.httpProxyHostText.setEnabled(this.enableHttpProxy.getSelection());
        Preferences prefs = UpdateCore.getPlugin().getPluginPreferences();
        this.checkSignatureCheckbox.setSelection(prefs.getBoolean("org.eclipse.update.core.checkSignature"));
        this.historySizeText.setText(prefs.getString("org.eclipse.update.core.historySize"));
        boolean isCompatible = COMPATIBLE_VALUE.equals(prefs.getString("org.eclipse.update.core.updateVersions"));
        this.equivalentButton.setSelection(!isCompatible);
        this.compatibleButton.setSelection(isCompatible);
        String text = prefs.getString(UpdateUtils.P_UPDATE_POLICY_URL);
        this.updatePolicyText.setText(text);
    }

    private void textChanged() {
        String text = this.updatePolicyText.getText();
        if (text.length() > 0) {
            try {
                new URL(text);
            }
            catch (MalformedURLException malformedURLException) {
                this.setValid(false);
                this.setErrorMessage(UpdateUI.getString("UpdateSettingsPreferencePage.invalid"));
                return;
            }
        }
        this.setValid(true);
        this.setErrorMessage(null);
    }

    public void performDefaults() {
        super.performDefaults();
        Preferences prefs = UpdateCore.getPlugin().getPluginPreferences();
        this.enableHttpProxy.setSelection(false);
        this.httpProxyHostText.setText("");
        this.httpProxyPortText.setText("");
        this.httpProxyPortLabel.setEnabled(false);
        this.httpProxyHostLabel.setEnabled(false);
        this.httpProxyPortText.setEnabled(false);
        this.httpProxyHostText.setEnabled(false);
        this.updatePolicyText.setText("");
        this.checkSignatureCheckbox.setSelection(true);
        this.historySizeText.setText(prefs.getDefaultString("org.eclipse.update.core.historySize"));
        this.equivalentButton.setSelection(true);
        this.compatibleButton.setSelection(false);
    }

    private void warnSignatureCheck(Shell shell) {
        MessageDialog.openWarning((Shell)shell, (String)UpdateUI.getString("MainPreferencePage.digitalSignature.title"), (String)UpdateUI.getString("MainPreferencePage.digitalSignature.message"));
    }
}

