/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.parts;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.WorkbenchPlugin;

public abstract class ConfigurationInfo {
    private IPluginDescriptor desc;
    private URL baseURL;
    private String iniFilename;
    private String propertiesFilename;
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";

    protected ConfigurationInfo(String ini, String properties) {
        this.iniFilename = ini;
        this.propertiesFilename = properties;
    }

    public void readINIFile() throws CoreException {
        IPlatformConfiguration conf = BootLoader.getCurrentPlatformConfiguration();
        String configName = conf.getPrimaryFeatureIdentifier();
        if (configName == null) {
            this.reportINIFailure(null, "Unknown configuration identifier");
            return;
        }
        IPluginRegistry reg = Platform.getPluginRegistry();
        if (reg == null) {
            this.reportINIFailure(null, "Plugin registry is null");
            return;
        }
        int index = configName.lastIndexOf("_");
        if (index == -1) {
            this.desc = reg.getPluginDescriptor(configName);
        } else {
            String mainPluginName = configName.substring(0, index);
            PluginVersionIdentifier mainPluginVersion = null;
            try {
                mainPluginVersion = new PluginVersionIdentifier(configName.substring(index + 1));
            }
            catch (Exception e) {
                this.reportINIFailure(e, "Unknown plugin version " + configName);
                return;
            }
            this.desc = reg.getPluginDescriptor(mainPluginName, mainPluginVersion);
        }
        if (this.desc == null) {
            this.reportINIFailure(null, "Missing plugin descriptor for " + configName);
            return;
        }
        this.baseURL = this.desc.getInstallURL();
        URL iniURL = this.desc.find((IPath)new Path(this.iniFilename));
        if (iniURL == null) {
            this.reportINIFailure(null, "Unable to load plugin file: " + this.iniFilename);
            return;
        }
        URL propertiesURL = this.desc.find((IPath)new Path(this.propertiesFilename));
        this.readINIFile(iniURL, propertiesURL);
    }

    protected IPluginDescriptor getDescriptor() {
        return this.desc;
    }

    protected URL getBaseURL() {
        return this.baseURL;
    }

    protected String getResourceString(String value, ResourceBundle b) {
        String dflt;
        if (value == null) {
            return null;
        }
        String s = value.trim();
        if (!s.startsWith(KEY_PREFIX)) {
            return s;
        }
        if (s.startsWith(KEY_DOUBLE_PREFIX)) {
            return s.substring(1);
        }
        int ix = s.indexOf(" ");
        String key = ix == -1 ? s : s.substring(0, ix);
        String string = dflt = ix == -1 ? s : s.substring(ix + 1);
        if (b == null) {
            return dflt;
        }
        try {
            return b.getString(key.substring(1));
        }
        catch (MissingResourceException e) {
            this.reportINIFailure(e, "Property \"" + key + "\" not found");
            return dflt;
        }
    }

    protected abstract void readINIFile(URL var1, URL var2) throws CoreException;

    protected void reportINIFailure(Exception e, String message) {
        if (!WorkbenchPlugin.DEBUG) {
            return;
        }
        Status iniStatus = new Status(4, WorkbenchPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, message, (Throwable)e);
        WorkbenchPlugin.log((String)"Problem reading configuration info.", (IStatus)iniStatus);
    }
}

