/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.model;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.model.BookmarkFolder;
import org.eclipse.update.internal.ui.model.BookmarkUtil;
import org.eclipse.update.internal.ui.model.IUpdateModelChangedListener;
import org.eclipse.update.internal.ui.model.NamedModelObject;
import org.eclipse.update.internal.ui.model.SiteBookmark;

public class UpdateModel
implements IAdaptable {
    private Vector bookmarks = new Vector();
    private Vector listeners = new Vector();
    private static final String BOOKMARK_FILE = "bookmarks.xml";

    public UpdateModel() {
        this.reset();
    }

    public void reset() {
        this.bookmarks.clear();
        BookmarkUtil.parse(this.getBookmarksFileName(), this.bookmarks);
    }

    private String getBookmarksFileName() {
        IPath path = UpdateUI.getDefault().getStateLocation();
        path = path.append(BOOKMARK_FILE);
        return path.toOSString();
    }

    public void shutdown() {
        this.saveBookmarks();
    }

    public void saveBookmarks() {
        BookmarkUtil.store(this.getBookmarksFileName(), this.bookmarks);
    }

    public void addBookmark(NamedModelObject bookmark) {
        this.bookmarks.add(bookmark);
        bookmark.setModel(this);
        this.fireObjectsAdded(null, new Object[]{bookmark});
    }

    public void removeBookmark(NamedModelObject bookmark) {
        this.bookmarks.remove(bookmark);
        bookmark.setModel(null);
        this.fireObjectsRemoved(null, new Object[]{bookmark});
    }

    public NamedModelObject[] getBookmarks() {
        return this.bookmarks.toArray(new NamedModelObject[this.bookmarks.size()]);
    }

    public SiteBookmark[] getBookmarkLeafs() {
        return BookmarkUtil.getBookmarks(this.bookmarks);
    }

    public BookmarkFolder getFolder(IPath path) {
        return BookmarkUtil.getFolder(this.bookmarks, path);
    }

    public void addUpdateModelChangedListener(IUpdateModelChangedListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeUpdateModelChangedListener(IUpdateModelChangedListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void fireObjectsAdded(Object parent, Object[] children) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            IUpdateModelChangedListener listener = (IUpdateModelChangedListener)iter.next();
            listener.objectsAdded(parent, children);
        }
    }

    public void fireObjectsRemoved(Object parent, Object[] children) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            IUpdateModelChangedListener listener = (IUpdateModelChangedListener)iter.next();
            listener.objectsRemoved(parent, children);
        }
    }

    public void fireObjectChanged(Object object, String property) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            IUpdateModelChangedListener listener = (IUpdateModelChangedListener)iter.next();
            listener.objectChanged(object, property);
        }
    }

    public Object getAdapter(Class key) {
        return null;
    }
}

