/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.model.BookmarkFolder;
import org.eclipse.update.internal.ui.model.DiscoveryFolder;
import org.eclipse.update.internal.ui.model.IUpdateModelChangedListener;
import org.eclipse.update.internal.ui.model.SiteBookmark;
import org.eclipse.update.internal.ui.model.UpdateModel;
import org.eclipse.update.internal.ui.wizards.EditSiteDialog;
import org.eclipse.update.internal.ui.wizards.NewWebSiteDialog;

public class WebBookmarksDialog
extends Dialog {
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private ModelListener modelListener;
    private TableViewer viewer;
    private DiscoveryFolder discoveryFolder = new DiscoveryFolder();

    public WebBookmarksDialog(Shell parentShell) {
        super(parentShell);
        UpdateUI.getDefault().getLabelProvider().connect((Object)this);
        this.modelListener = new ModelListener();
        UpdateUI.getDefault().getUpdateModel().addUpdateModelChangedListener(this.modelListener);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(UpdateUI.getString("WebBookmarksDialog.label"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Table table = new Table(container, 2560);
        table.setLayoutData((Object)new GridData(1808));
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WebSiteLabelProvider());
        this.viewer.setInput((Object)UpdateUI.getDefault().getUpdateModel());
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof SiteBookmark) {
                    return ((SiteBookmark)element).isWebBookmark();
                }
                return true;
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection ssel = (IStructuredSelection)e.getSelection();
                if (ssel.size() == 0) {
                    return;
                }
                SiteBookmark bookmark = (SiteBookmark)ssel.getFirstElement();
                Object parent = bookmark.getParent(bookmark);
                WebBookmarksDialog.this.editButton.setEnabled(parent == null || !parent.equals(WebBookmarksDialog.this.discoveryFolder));
                WebBookmarksDialog.this.removeButton.setEnabled(parent == null || !parent.equals(WebBookmarksDialog.this.discoveryFolder));
            }
        });
        this.createButtons(container);
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void createButtons(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(2));
        this.addButton = new Button(container, 8);
        this.addButton.setText(UpdateUI.getString("WebBookmarksDialog.add"));
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewWebSiteDialog dialog = new NewWebSiteDialog(WebBookmarksDialog.this.getShell());
                dialog.create();
                dialog.getShell().setText(UpdateUI.getString("WebBookmarksDialog.new"));
                dialog.open();
            }
        });
        this.editButton = new Button(container, 8);
        this.editButton.setText(UpdateUI.getString("WebBookmarksDialog.edit"));
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ssel = (IStructuredSelection)WebBookmarksDialog.this.viewer.getSelection();
                SiteBookmark bookmark = (SiteBookmark)ssel.getFirstElement();
                EditSiteDialog dialog = new EditSiteDialog(WebBookmarksDialog.this.getShell(), bookmark);
                dialog.create();
                dialog.getShell().setText(UpdateUI.getString("WebBookmarksDialog.editTitle"));
                dialog.open();
            }
        });
        this.editButton.setEnabled(false);
        this.removeButton = new Button(container, 8);
        this.removeButton.setText(UpdateUI.getString("WebBookmarksDialog.remove"));
        this.removeButton.setLayoutData((Object)new GridData(768));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ssel = (IStructuredSelection)WebBookmarksDialog.this.viewer.getSelection();
                SiteBookmark bookmark = (SiteBookmark)ssel.getFirstElement();
                UpdateUI.getDefault().getUpdateModel().removeBookmark(bookmark);
            }
        });
        this.removeButton.setEnabled(false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        super.okPressed();
        UpdateUI.getDefault().getLabelProvider().disconnect((Object)this);
        UpdateUI.getDefault().getUpdateModel().removeUpdateModelChangedListener(this.modelListener);
    }

    protected void cancelPressed() {
        UpdateUI.getDefault().getUpdateModel().reset();
        UpdateUI.getDefault().getLabelProvider().disconnect((Object)this);
        UpdateUI.getDefault().getUpdateModel().removeUpdateModelChangedListener(this.modelListener);
        super.cancelPressed();
    }

    class ModelListener
    implements IUpdateModelChangedListener {
        ModelListener() {
        }

        public void objectChanged(Object object, String property) {
            WebBookmarksDialog.this.viewer.refresh();
        }

        public void objectsAdded(Object parent, Object[] children) {
            WebBookmarksDialog.this.viewer.refresh();
        }

        public void objectsRemoved(Object parent, Object[] children) {
            WebBookmarksDialog.this.viewer.refresh();
        }
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            UpdateModel model = UpdateUI.getDefault().getUpdateModel();
            SiteBookmark[] bookmarks = model.getBookmarkLeafs();
            Object[] sitesToVisit = WebBookmarksDialog.this.discoveryFolder.getChildren(WebBookmarksDialog.this.discoveryFolder);
            Object[] all = new Object[bookmarks.length + sitesToVisit.length];
            System.arraycopy(bookmarks, 0, all, 0, bookmarks.length);
            System.arraycopy(sitesToVisit, 0, all, bookmarks.length, sitesToVisit.length);
            return all;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    class WebSiteLabelProvider
    extends LabelProvider {
        WebSiteLabelProvider() {
        }

        public Image getImage(Object element) {
            UpdateLabelProvider provider = UpdateUI.getDefault().getLabelProvider();
            if (element instanceof BookmarkFolder) {
                return provider.get(UpdateUIImages.DESC_BFOLDER_OBJ, 0);
            }
            if (element instanceof SiteBookmark) {
                return provider.get(UpdateUIImages.DESC_WEB_SITE_OBJ, 0);
            }
            return null;
        }

        public String getText(Object element) {
            return super.getText(element);
        }
    }
}

