/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.update.internal.ui.UpdateUI;

public class UpdateUIImages {
    private static final String NAME_PREFIX = String.valueOf(UpdateUI.getPluginId()) + ".";
    private static final URL BASE_URL = UpdateUI.getDefault().getDescriptor().getInstallURL();
    private static ImageRegistry PLUGIN_REGISTRY;
    public static final String ICONS_PATH = "icons/full/";
    private static final String PATH_OBJ = "icons/full/obj16/";
    private static final String PATH_VIEW = "icons/full/cview16/";
    private static final String PATH_LCL = "icons/full/elcl16/";
    private static final String PATH_LCL_HOVER = "icons/full/clcl16/";
    private static final String PATH_LCL_DISABLED = "icons/full/dlcl16/";
    private static final String PATH_OVR = "icons/full/ovr16/";
    private static final String PATH_WIZBAN = "icons/full/wizban/";
    public static final String PATH_FORMS = "icons/full/forms/";
    public static final String IMG_FORM_BANNER;
    public static final String IMG_FORM_BANNER_SHORT;
    public static final String IMG_FORM_UNDERLINE;
    public static final ImageDescriptor DESC_APP_OBJ;
    public static final ImageDescriptor DESC_BFOLDER_OBJ;
    public static final ImageDescriptor DESC_CATEGORY_OBJ;
    public static final ImageDescriptor DESC_CD_OBJ;
    public static final ImageDescriptor DESC_COMPUTER_OBJ;
    public static final ImageDescriptor DESC_CONFIG_OBJ;
    public static final ImageDescriptor DESC_FEATURE_OBJ;
    public static final ImageDescriptor DESC_EFIX_OBJ;
    public static final ImageDescriptor DESC_FLOPPY_OBJ;
    public static final ImageDescriptor DESC_HISTORY_OBJ;
    public static final ImageDescriptor DESC_LSITE_OBJ;
    public static final ImageDescriptor DESC_PSITE_OBJ;
    public static final ImageDescriptor DESC_ESITE_OBJ;
    public static final ImageDescriptor DESC_SITE_OBJ;
    public static final ImageDescriptor DESC_WEB_SITE_OBJ;
    public static final ImageDescriptor DESC_PLACES_OBJ;
    public static final ImageDescriptor DESC_SAVED_OBJ;
    public static final ImageDescriptor DESC_UNCONF_FEATURE_OBJ;
    public static final ImageDescriptor DESC_UPDATES_OBJ;
    public static final ImageDescriptor DESC_VFIXED_OBJ;
    public static final ImageDescriptor DESC_VREMOTE_OBJ;
    public static final ImageDescriptor DESC_VREMOVABLE_OBJ;
    public static final ImageDescriptor DESC_NOTINST_FEATURE_OBJ;
    public static final ImageDescriptor DESC_SHOW_SEARCH;
    public static final ImageDescriptor DESC_ERR_ST_OBJ;
    public static final ImageDescriptor DESC_OK_ST_OBJ;
    public static final ImageDescriptor DESC_LINKED_CO;
    public static final ImageDescriptor DESC_UPDATED_CO;
    public static final ImageDescriptor DESC_INSTALLABLE_CO;
    public static final ImageDescriptor DESC_CURRENT_CO;
    public static final ImageDescriptor DESC_ERROR_CO;
    public static final ImageDescriptor DESC_WARNING_CO;
    public static final ImageDescriptor DESC_MOD_CO;
    public static final ImageDescriptor DESC_ADD_CO;
    public static final ImageDescriptor DESC_DEL_CO;
    public static final ImageDescriptor DESC_UNCONF_CO;
    public static final ImageDescriptor DESC_CONFIGS_VIEW;
    public static final ImageDescriptor DESC_SITES_VIEW;
    public static final ImageDescriptor DESC_SELECTED_UPDATES_VIEW;
    public static final ImageDescriptor DESC_BACKWARD_NAV;
    public static final ImageDescriptor DESC_BACKWARD_NAV_H;
    public static final ImageDescriptor DESC_BACKWARD_NAV_D;
    public static final ImageDescriptor DESC_FORWARD_NAV;
    public static final ImageDescriptor DESC_FORWARD_NAV_H;
    public static final ImageDescriptor DESC_FORWARD_NAV_D;
    public static final ImageDescriptor DESC_HOME_NAV;
    public static final ImageDescriptor DESC_HOME_NAV_H;
    public static final ImageDescriptor DESC_HOME_NAV_D;
    public static final ImageDescriptor DESC_REFRESH_NAV;
    public static final ImageDescriptor DESC_REFRESH_NAV_H;
    public static final ImageDescriptor DESC_REFRESH_NAV_D;
    public static final ImageDescriptor DESC_STOP_NAV;
    public static final ImageDescriptor DESC_STOP_NAV_H;
    public static final ImageDescriptor DESC_STOP_NAV_D;
    public static final ImageDescriptor DESC_GO_NAV;
    public static final ImageDescriptor DESC_GO_NAV_H;
    public static final ImageDescriptor DESC_GO_NAV_D;
    public static final ImageDescriptor DESC_SHOW_UNCONF;
    public static final ImageDescriptor DESC_SHOW_UNCONF_H;
    public static final ImageDescriptor DESC_SHOW_UNCONF_D;
    public static final ImageDescriptor DESC_COLLAPSE_ALL;
    public static final ImageDescriptor DESC_SHOW_HIERARCHY;
    public static final ImageDescriptor DESC_SHOW_HIERARCHY_H;
    public static final ImageDescriptor DESC_SHOW_HIERARCHY_D;
    public static final ImageDescriptor DESC_INSTALL_WIZ;
    public static final ImageDescriptor DESC_UPDATE_WIZ;
    public static final ImageDescriptor DESC_CONFIG_WIZ;
    public static final ImageDescriptor DESC_UNINSTALL_WIZ;
    public static final ImageDescriptor DESC_INSTALL_BANNER;
    public static final ImageDescriptor DESC_FORM_BANNER;
    public static final ImageDescriptor DESC_FORM_BANNER_SHORT;
    public static final ImageDescriptor DESC_FORM_UNDERLINE;
    public static final ImageDescriptor DESC_PROVIDER;
    public static final ImageDescriptor DESC_ITEM;
    public static final ImageDescriptor DESC_NEW_BOOKMARK;
    public static final ImageDescriptor DESC_NEW_FOLDER;
    public static final ImageDescriptor DESC_NEW_SEARCH;

    static {
        IMG_FORM_BANNER = String.valueOf(NAME_PREFIX) + "FORM_BANNER";
        IMG_FORM_BANNER_SHORT = String.valueOf(NAME_PREFIX) + "FORM_BANNER_SHORT";
        IMG_FORM_UNDERLINE = String.valueOf(NAME_PREFIX) + "FORM_UNDERLINE";
        DESC_APP_OBJ = UpdateUIImages.create(PATH_OBJ, "app_obj.gif");
        DESC_BFOLDER_OBJ = UpdateUIImages.create(PATH_OBJ, "bfolder_obj.gif");
        DESC_CATEGORY_OBJ = UpdateUIImages.create(PATH_OBJ, "category_obj.gif");
        DESC_CD_OBJ = UpdateUIImages.create(PATH_OBJ, "cd_obj.gif");
        DESC_COMPUTER_OBJ = UpdateUIImages.create(PATH_OBJ, "computer_obj.gif");
        DESC_CONFIG_OBJ = UpdateUIImages.create(PATH_OBJ, "config_obj.gif");
        DESC_FEATURE_OBJ = UpdateUIImages.create(PATH_OBJ, "feature_obj.gif");
        DESC_EFIX_OBJ = UpdateUIImages.create(PATH_OBJ, "efix2_obj.gif");
        DESC_FLOPPY_OBJ = UpdateUIImages.create(PATH_OBJ, "floppy_obj.gif");
        DESC_HISTORY_OBJ = UpdateUIImages.create(PATH_OBJ, "history_obj.gif");
        DESC_LSITE_OBJ = UpdateUIImages.create(PATH_OBJ, "lsite_obj.gif");
        DESC_PSITE_OBJ = UpdateUIImages.create(PATH_OBJ, "psite_obj.gif");
        DESC_ESITE_OBJ = UpdateUIImages.create(PATH_OBJ, "esite_obj.gif");
        DESC_SITE_OBJ = UpdateUIImages.create(PATH_OBJ, "site_obj.gif");
        DESC_WEB_SITE_OBJ = UpdateUIImages.create(PATH_OBJ, "web_bkmrk_obj.gif");
        DESC_PLACES_OBJ = UpdateUIImages.create(PATH_OBJ, "places_obj.gif");
        DESC_SAVED_OBJ = UpdateUIImages.create(PATH_OBJ, "saved_obj.gif");
        DESC_UNCONF_FEATURE_OBJ = UpdateUIImages.create(PATH_OBJ, "unconf_feature_obj.gif");
        DESC_UPDATES_OBJ = UpdateUIImages.create(PATH_OBJ, "updates_obj.gif");
        DESC_VFIXED_OBJ = UpdateUIImages.create(PATH_OBJ, "vfixed_obj.gif");
        DESC_VREMOTE_OBJ = UpdateUIImages.create(PATH_OBJ, "vremote_obj.gif");
        DESC_VREMOVABLE_OBJ = UpdateUIImages.create(PATH_OBJ, "vremovable_obj.gif");
        DESC_NOTINST_FEATURE_OBJ = UpdateUIImages.create(PATH_OBJ, "notinstalled_feature_obj.gif");
        DESC_SHOW_SEARCH = UpdateUIImages.create(PATH_OBJ, "tsearch_obj.gif");
        DESC_ERR_ST_OBJ = UpdateUIImages.create(PATH_OBJ, "error_st_obj.gif");
        DESC_OK_ST_OBJ = UpdateUIImages.create(PATH_OBJ, "ok_st_obj.gif");
        DESC_LINKED_CO = UpdateUIImages.create(PATH_OVR, "linked_co.gif");
        DESC_UPDATED_CO = UpdateUIImages.create(PATH_OVR, "updated_co.gif");
        DESC_INSTALLABLE_CO = UpdateUIImages.create(PATH_OVR, "installable_co.gif");
        DESC_CURRENT_CO = UpdateUIImages.create(PATH_OVR, "current_co.gif");
        DESC_ERROR_CO = UpdateUIImages.create(PATH_OVR, "error_co.gif");
        DESC_WARNING_CO = UpdateUIImages.create(PATH_OVR, "warning_co.gif");
        DESC_MOD_CO = UpdateUIImages.create(PATH_OVR, "mod_co.gif");
        DESC_ADD_CO = UpdateUIImages.create(PATH_OVR, "add_stat.gif");
        DESC_DEL_CO = UpdateUIImages.create(PATH_OVR, "del_stat.gif");
        DESC_UNCONF_CO = UpdateUIImages.create(PATH_OVR, "unconfigured_co.gif");
        DESC_CONFIGS_VIEW = UpdateUIImages.create(PATH_VIEW, "configs.gif");
        DESC_SITES_VIEW = UpdateUIImages.create(PATH_VIEW, "updates.gif");
        DESC_SELECTED_UPDATES_VIEW = UpdateUIImages.create(PATH_VIEW, "selected_updates.gif");
        DESC_BACKWARD_NAV = UpdateUIImages.create(PATH_LCL, "backward_nav.gif");
        DESC_BACKWARD_NAV_H = UpdateUIImages.create(PATH_LCL_HOVER, "backward_nav.gif");
        DESC_BACKWARD_NAV_D = UpdateUIImages.create(PATH_LCL_DISABLED, "backward_nav.gif");
        DESC_FORWARD_NAV = UpdateUIImages.create(PATH_LCL, "forward_nav.gif");
        DESC_FORWARD_NAV_H = UpdateUIImages.create(PATH_LCL_HOVER, "forward_nav.gif");
        DESC_FORWARD_NAV_D = UpdateUIImages.create(PATH_LCL_DISABLED, "forward_nav.gif");
        DESC_HOME_NAV = UpdateUIImages.create(PATH_LCL, "home_nav.gif");
        DESC_HOME_NAV_H = UpdateUIImages.create(PATH_LCL_HOVER, "home_nav.gif");
        DESC_HOME_NAV_D = UpdateUIImages.create(PATH_LCL_DISABLED, "home_nav.gif");
        DESC_REFRESH_NAV = UpdateUIImages.create(PATH_LCL, "refresh_nav.gif");
        DESC_REFRESH_NAV_H = UpdateUIImages.create(PATH_LCL_HOVER, "refresh_nav.gif");
        DESC_REFRESH_NAV_D = UpdateUIImages.create(PATH_LCL_DISABLED, "refresh_nav.gif");
        DESC_STOP_NAV = UpdateUIImages.create(PATH_LCL, "stop_nav.gif");
        DESC_STOP_NAV_H = UpdateUIImages.create(PATH_LCL_HOVER, "stop_nav.gif");
        DESC_STOP_NAV_D = UpdateUIImages.create(PATH_LCL_DISABLED, "stop_nav.gif");
        DESC_GO_NAV = UpdateUIImages.create(PATH_LCL, "go_nav.gif");
        DESC_GO_NAV_H = UpdateUIImages.create(PATH_LCL_HOVER, "go_nav.gif");
        DESC_GO_NAV_D = UpdateUIImages.create(PATH_LCL_DISABLED, "go_nav.gif");
        DESC_SHOW_UNCONF = UpdateUIImages.create(PATH_LCL, "show_unconf.gif");
        DESC_SHOW_UNCONF_H = UpdateUIImages.create(PATH_LCL_HOVER, "show_unconf.gif");
        DESC_SHOW_UNCONF_D = UpdateUIImages.create(PATH_LCL_DISABLED, "show_unconf.gif");
        DESC_COLLAPSE_ALL = UpdateUIImages.create(PATH_LCL, "collapseall.gif");
        DESC_SHOW_HIERARCHY = UpdateUIImages.create(PATH_LCL, "hierarchicalLayout.gif");
        DESC_SHOW_HIERARCHY_H = UpdateUIImages.create(PATH_LCL_HOVER, "hierarchicalLayout.gif");
        DESC_SHOW_HIERARCHY_D = UpdateUIImages.create(PATH_LCL_DISABLED, "hierarchicalLayout.gif");
        DESC_INSTALL_WIZ = UpdateUIImages.create(PATH_WIZBAN, "install_wiz.gif");
        DESC_UPDATE_WIZ = UpdateUIImages.create(PATH_WIZBAN, "update_wiz.gif");
        DESC_CONFIG_WIZ = UpdateUIImages.create(PATH_WIZBAN, "config_wiz.gif");
        DESC_UNINSTALL_WIZ = UpdateUIImages.create(PATH_WIZBAN, "uninstall_wiz.gif");
        DESC_INSTALL_BANNER = UpdateUIImages.create(PATH_WIZBAN, "def_wizban.jpg");
        DESC_FORM_BANNER = UpdateUIImages.create(PATH_FORMS, "form_banner.jpg");
        DESC_FORM_BANNER_SHORT = UpdateUIImages.create(PATH_FORMS, "form_banner.gif");
        DESC_FORM_UNDERLINE = UpdateUIImages.create(PATH_FORMS, "form_underline.jpg");
        DESC_PROVIDER = UpdateUIImages.create(PATH_FORMS, "def_provider.jpg");
        DESC_ITEM = UpdateUIImages.create(PATH_FORMS, "topic.gif");
        DESC_NEW_BOOKMARK = UpdateUIImages.create(PATH_WIZBAN, "new_bookmark_wiz.gif");
        DESC_NEW_FOLDER = UpdateUIImages.create(PATH_WIZBAN, "new_folder_wiz.gif");
        DESC_NEW_SEARCH = UpdateUIImages.create(PATH_WIZBAN, "new_search_wiz.gif");
    }

    private static ImageDescriptor create(String prefix, String name) {
        return ImageDescriptor.createFromURL((URL)UpdateUIImages.makeImageURL(prefix, name));
    }

    public static Image get(String key) {
        if (PLUGIN_REGISTRY == null) {
            UpdateUIImages.initialize();
        }
        return PLUGIN_REGISTRY.get(key);
    }

    public static ImageDescriptor getImageDescriptorFromPlugin(IPluginDescriptor pluginDescriptor, String subdirectoryAndFilename) {
        URL installURL = pluginDescriptor.getInstallURL();
        try {
            URL newURL = new URL(installURL, subdirectoryAndFilename);
            return ImageDescriptor.createFromURL((URL)newURL);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static Image getImageFromPlugin(IPluginDescriptor pluginDescriptor, String subdirectoryAndFilename) {
        URL installURL = pluginDescriptor.getInstallURL();
        Image image = null;
        try {
            URL newURL = new URL(installURL, subdirectoryAndFilename);
            String key = newURL.toString();
            if (PLUGIN_REGISTRY == null) {
                UpdateUIImages.initialize();
            }
            if ((image = PLUGIN_REGISTRY.get(key)) == null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)newURL);
                image = desc.createImage();
                PLUGIN_REGISTRY.put(key, image);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return image;
    }

    private static final void initialize() {
        PLUGIN_REGISTRY = new ImageRegistry();
        UpdateUIImages.manage(IMG_FORM_BANNER_SHORT, DESC_FORM_BANNER_SHORT);
        UpdateUIImages.manage(IMG_FORM_BANNER, DESC_FORM_BANNER);
        UpdateUIImages.manage(IMG_FORM_UNDERLINE, DESC_FORM_UNDERLINE);
    }

    private static URL makeImageURL(String prefix, String name) {
        String path = String.valueOf(prefix) + name;
        URL url = null;
        try {
            url = new URL(BASE_URL, path);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return url;
    }

    public static Image manage(String key, ImageDescriptor desc) {
        Image image = desc.createImage();
        PLUGIN_REGISTRY.put(key, image);
        return image;
    }
}

