/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.browser.BrowserManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.model.SiteLocalModel;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.model.UpdateModel;
import org.eclipse.update.internal.ui.parts.AboutInfo;
import org.eclipse.update.internal.ui.security.UpdateManagerAuthenticator;

public class UpdateUI
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.update.ui";
    public static final String WEB_APP_ID = "org.eclipse.update";
    private static UpdateUI plugin;
    private ResourceBundle resourceBundle;
    private UpdateModel model;
    private UpdateManagerAuthenticator authenticator;
    private AboutInfo aboutInfo;
    private String appServerHost;
    private int appServerPort;
    private UpdateLabelProvider labelProvider;
    private static boolean remindOnCancel;

    static {
        remindOnCancel = true;
    }

    public UpdateUI(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.update.internal.ui.UpdateUIPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static UpdateUI getDefault() {
        return plugin;
    }

    public static IWorkbenchPage getActivePage() {
        return UpdateUI.getDefault().internalGetActivePage();
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = UpdateUI.getActiveWorkbenchWindow();
        return window != null ? window.getShell() : null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return UpdateUI.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static String getPluginId() {
        return UpdateUI.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public AboutInfo getAboutInfo() {
        return this.aboutInfo;
    }

    public UpdateLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new UpdateLabelProvider();
        }
        return this.labelProvider;
    }

    public static String getString(String key) {
        ResourceBundle bundle = UpdateUI.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getFormattedMessage(String key, String[] args) {
        String text = UpdateUI.getString(key);
        return MessageFormat.format(text, args);
    }

    public static String getFormattedMessage(String key, String arg) {
        String text = UpdateUI.getString(key);
        return MessageFormat.format(text, arg);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void startup() throws CoreException {
        super.startup();
        this.readInfo();
        this.model = new UpdateModel();
        this.authenticator = new UpdateManagerAuthenticator();
        Authenticator.setDefault(this.authenticator);
        int historyPref = this.getPluginPreferences().getInt("org.eclipse.update.core.historySize");
        if (historyPref > 0) {
            SiteLocalModel.DEFAULT_HISTORY = historyPref;
        }
    }

    public boolean isWebAppStarted() {
        return this.appServerHost != null;
    }

    public String getAppServerHost() {
        return this.appServerHost;
    }

    public int getAppServerPort() {
        return this.appServerPort;
    }

    public void shutdown() throws CoreException {
        this.model.shutdown();
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        super.shutdown();
    }

    public UpdateModel getUpdateModel() {
        return this.model;
    }

    public static void logException(Throwable e) {
        UpdateUI.logException(e, true);
    }

    public static void logException(Throwable e, boolean showErrorDialog) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, UpdateUI.getPluginId(), 0, message, e);
        }
        UpdateUI.log(status, showErrorDialog);
    }

    public static void log(IStatus status, boolean showErrorDialog) {
        if (status.getSeverity() != 1) {
            if (showErrorDialog) {
                ErrorDialog.openError((Shell)UpdateUI.getActiveWorkbenchShell(), null, null, (IStatus)status);
            }
            Platform.getPlugin((String)"org.eclipse.core.runtime").getLog().log(status);
        } else {
            MessageDialog.openInformation((Shell)UpdateUI.getActiveWorkbenchShell(), null, (String)status.getMessage());
        }
    }

    public static IFeature[] searchSite(String featureId, IConfiguredSite site, boolean onlyConfigured) throws CoreException {
        Object[] references = null;
        references = onlyConfigured ? site.getConfiguredFeatures() : site.getSite().getFeatureReferences();
        Vector<IFeature> result = new Vector<IFeature>();
        int i = 0;
        while (i < references.length) {
            IFeature feature = references[i].getFeature(null);
            String id = feature.getVersionedIdentifier().getIdentifier();
            if (featureId.equals(id)) {
                result.add(feature);
            }
            ++i;
        }
        return result.toArray(new IFeature[result.size()]);
    }

    public static IFeature[] getInstalledFeatures(IFeature feature) {
        return UpdateUI.getInstalledFeatures(feature, true);
    }

    public static IFeature[] getInstalledFeatures(IFeature feature, boolean onlyConfigured) {
        Vector<IFeature> features = new Vector<IFeature>();
        try {
            ILocalSite localSite = SiteManager.getLocalSite();
            IInstallConfiguration config = localSite.getCurrentConfiguration();
            IConfiguredSite[] isites = config.getConfiguredSites();
            VersionedIdentifier vid = feature.getVersionedIdentifier();
            String id = vid.getIdentifier();
            int i = 0;
            while (i < isites.length) {
                IConfiguredSite isite = isites[i];
                IFeature[] result = UpdateUI.searchSite(id, isite, onlyConfigured);
                int j = 0;
                while (j < result.length) {
                    IFeature installedFeature = result[j];
                    features.add(installedFeature);
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            UpdateUI.logException(e);
        }
        return features.toArray(new IFeature[features.size()]);
    }

    public UpdateManagerAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public static URL getOriginatingURL(String id) {
        IDialogSettings section = UpdateUI.getOriginatingURLSection();
        String value = section.get(id);
        if (value != null) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public static void setOriginatingURL(String id, URL url) {
        IDialogSettings section = UpdateUI.getOriginatingURLSection();
        section.put(id, url.toString());
    }

    private static IDialogSettings getOriginatingURLSection() {
        IDialogSettings settings = UpdateUI.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection("originatingURLs");
        if (section == null) {
            section = settings.addNewSection("originatingURLs");
        }
        return section;
    }

    private void readInfo() {
        IPlatformConfiguration conf = BootLoader.getCurrentPlatformConfiguration();
        String versionedFeatureId = conf.getPrimaryFeatureIdentifier();
        if (versionedFeatureId == null) {
            this.aboutInfo = new AboutInfo(null, null);
        } else {
            int index = versionedFeatureId.lastIndexOf("_");
            if (index == -1) {
                this.aboutInfo = new AboutInfo(versionedFeatureId, null);
            } else {
                String mainPluginName = versionedFeatureId.substring(0, index);
                PluginVersionIdentifier mainPluginVersion = null;
                try {
                    mainPluginVersion = new PluginVersionIdentifier(versionedFeatureId.substring(index + 1));
                }
                catch (Exception e) {
                    Status iniStatus = new Status(4, WorkbenchPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "Unknown plugin version " + versionedFeatureId, (Throwable)e);
                    UpdateUI.log((IStatus)iniStatus, true);
                }
                this.aboutInfo = new AboutInfo(mainPluginName, mainPluginVersion);
            }
        }
        try {
            this.aboutInfo.readINIFile();
        }
        catch (CoreException e) {
            UpdateUI.log(e.getStatus(), true);
        }
    }

    public static void requestRestart() {
        String title = UpdateUI.getString("RestartTitle");
        String message = UpdateUI.getString("RestartMessage");
        boolean restart = MessageDialog.openQuestion((Shell)UpdateUI.getActiveWorkbenchShell(), (String)title, (String)message);
        if (restart) {
            PlatformUI.getWorkbench().restart();
        }
    }

    public static void showURL(String url) {
        UpdateUI.showURL(url, false);
    }

    public static void showURL(String url, boolean encodeHostAndPort) {
        if (encodeHostAndPort) {
            url = UpdateUI.encodeHostAndPort(url);
        }
        if (SWT.getPlatform().equals("win32")) {
            Program.launch((String)url);
        } else {
            IBrowser browser = BrowserManager.getInstance().createBrowser();
            try {
                browser.displayURL(url);
            }
            catch (Exception e) {
                UpdateUI.logException(e);
            }
        }
    }

    private static String encodeHostAndPort(String urlName) {
        String callbackURL = UpdateUI.getCallbackURLAsString();
        if (callbackURL == null) {
            return urlName;
        }
        String callbackParameter = "updateURL=" + callbackURL;
        if (urlName.indexOf(63) != -1) {
            return String.valueOf(urlName) + "&" + callbackParameter;
        }
        return String.valueOf(urlName) + "?" + callbackParameter;
    }

    private static String getCallbackURLAsString() {
        String host = UpdateUI.getDefault().getAppServerHost();
        int port = UpdateUI.getDefault().getAppServerPort();
        if (host == null || port == 0) {
            return null;
        }
        String value = "http://" + host + ":" + port + "/" + WEB_APP_ID + "/install";
        try {
            value = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return value;
    }

    public static boolean getRemindOnCancel() {
        return remindOnCancel;
    }

    public static void setRemindOnCancel(boolean remind) {
        remindOnCancel = remind;
    }
}

