/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.SiteContentProvider;

public class BuildTimeSiteContentProvider
extends SiteContentProvider
implements ISiteContentProvider,
IPDEBuildConstants {
    private URL installedBaseURL;
    private URL[] urls;

    public BuildTimeSiteContentProvider(URL[] urls, URL installedBaseURL) {
        super(urls[0]);
        this.installedBaseURL = installedBaseURL;
        this.urls = urls;
    }

    public URL getInstalledBaseURL() {
        return this.installedBaseURL;
    }

    public URL[] getPluginPaths() {
        URL[] pluginsToCompile = this.findPluginXML(this.urls);
        if (this.installedBaseURL != null) {
            URL[] installedPlugins = this.findPluginXML(new URL[]{this.installedBaseURL});
            URL[] pluginsAndBase = new URL[pluginsToCompile.length + installedPlugins.length];
            System.arraycopy(pluginsToCompile, 0, pluginsAndBase, 0, pluginsToCompile.length);
            System.arraycopy(installedPlugins, 0, pluginsAndBase, pluginsToCompile.length, installedPlugins.length);
            return pluginsAndBase;
        }
        return pluginsToCompile;
    }

    public URL getURL() {
        throw new RuntimeException();
    }

    private URL[] findPluginXML(URL[] location) {
        ArrayList collectedElements = new ArrayList(10);
        int i = 0;
        while (i < location.length) {
            Collection foundPlugins = Utils.findFiles(location[i].getFile(), "plugins", "plugin.xml");
            if (foundPlugins != null) {
                collectedElements.addAll(foundPlugins);
            }
            ++i;
        }
        i = 0;
        while (i < location.length) {
            Collection foundFragments = Utils.findFiles(location[i].getFile(), "plugins", "fragment.xml");
            if (foundFragments != null) {
                collectedElements.addAll(foundFragments);
            }
            ++i;
        }
        URL[] pluginURLs = new URL[collectedElements.size()];
        int i2 = 0;
        Iterator iter = collectedElements.iterator();
        while (iter.hasNext()) {
            File element = (File)iter.next();
            try {
                pluginURLs[i2] = new URL("file:" + element.getAbsolutePath());
            }
            catch (MalformedURLException e) {
                Platform.getPlugin((String)"org.eclipse.pde.build").getLog().log((IStatus)new Status(2, "org.eclipse.pde.build", 20, Policy.bind("warning.cannotLocateSource", element.getAbsolutePath()), (Throwable)e));
            }
            ++i2;
        }
        return pluginURLs;
    }
}

