/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.Factory;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.core.runtime.model.PluginPrerequisiteModel;
import org.eclipse.core.runtime.model.PluginRegistryModel;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.IXMLConstants;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.site.BuildTimeSiteContentProvider;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.Site;

public class BuildTimeSite
extends Site
implements ISite,
IPDEBuildConstants,
IXMLConstants {
    private PluginRegistryModel pluginRegistry;

    public PluginRegistryModel getPluginRegistry() throws CoreException {
        if (this.pluginRegistry == null) {
            MultiStatus status;
            BuildTimeSiteContentProvider contentProvider = (BuildTimeSiteContentProvider)this.getSiteContentProvider();
            MultiStatus problems = new MultiStatus("org.eclipse.pde.build", 4, Policy.bind("exception.pluginParse"), null);
            Factory factory = new Factory(problems);
            this.pluginRegistry = PluginRegistryModel.parsePlugins((URL[])contentProvider.getPluginPaths(), (Factory)factory);
            this.setFragments();
            if (AbstractScriptGenerator.isBuildingOSGi()) {
                this.setExtraPrerequisites();
            }
            if (!(status = factory.getStatus()).isOK()) {
                throw new CoreException((IStatus)status);
            }
        }
        return this.pluginRegistry;
    }

    private void setExtraPrerequisites() {
        PluginDescriptorModel[] plugins = this.pluginRegistry.getPlugins();
        int i = 0;
        while (i < plugins.length) {
            this.addPrerequisites((PluginModel)plugins[i]);
            ++i;
        }
        PluginFragmentModel[] fragments = this.pluginRegistry.getFragments();
        int i2 = 0;
        while (i2 < fragments.length) {
            this.addPrerequisites((PluginModel)fragments[i2]);
            ++i2;
        }
    }

    private void addPrerequisites(PluginModel model) {
        String id = model.getId();
        if ("org.eclipse.osgi".equals(id) || "org.eclipse.osgi.services".equals(id) || "org.eclipse.osgi.util".equals(id) || "org.eclipse.core.runtime".equals(id) || "org.eclipse.core.runtime.compatibility".equals(id) || "org.eclipse.core.boot".equals(id) || "org.eclipse.core.applicationrunner".equals(id) || "org.eclipse.update.configurator".equals(id)) {
            return;
        }
        String extraPrereqs = "org.eclipse.core.runtime.compatibility";
        PluginPrerequisiteModel[] oldRequires = model.getRequires();
        String[] extraPrereqsList = Utils.getArrayFromString(extraPrereqs);
        int oldRequiresLength = oldRequires == null ? 0 : oldRequires.length;
        PluginPrerequisiteModel[] newRequires = new PluginPrerequisiteModel[oldRequiresLength + extraPrereqsList.length];
        if (oldRequires != null) {
            System.arraycopy(oldRequires, 0, newRequires, 0, oldRequires.length);
        }
        int i = 0;
        while (i < extraPrereqsList.length) {
            PluginPrerequisiteModel prereq = new PluginPrerequisiteModel();
            prereq.setPlugin(extraPrereqsList[i]);
            newRequires[oldRequiresLength + i] = prereq;
            ++i;
        }
        model.setRequires(newRequires);
    }

    private void setFragments() {
        PluginFragmentModel[] fragments = this.pluginRegistry.getFragments();
        int i = 0;
        while (i < fragments.length) {
            String pluginId = fragments[i].getPluginId();
            PluginDescriptorModel plugin = this.pluginRegistry.getPlugin(pluginId);
            if (plugin == null) {
                Status status = new Status(2, "org.eclipse.pde.build", 5, Policy.bind("exception.missingPlugin", pluginId), null);
                Platform.getPlugin((String)"org.eclipse.pde.build").getLog().log((IStatus)status);
            } else {
                PluginFragmentModel[] existingFragments = plugin.getFragments();
                if (existingFragments == null) {
                    plugin.setFragments(new PluginFragmentModel[]{fragments[i]});
                } else {
                    PluginFragmentModel[] newFragments = new PluginFragmentModel[existingFragments.length + 1];
                    System.arraycopy(existingFragments, 0, newFragments, 0, existingFragments.length);
                    newFragments[newFragments.length - 1] = fragments[i];
                    plugin.setFragments(newFragments);
                }
            }
            ++i;
        }
    }

    public IFeature findFeature(String featureId) throws CoreException {
        ISiteFeatureReference[] features = this.getFeatureReferences();
        int i = 0;
        while (i < features.length) {
            if (features[i].getVersionedIdentifier().getIdentifier().equals(featureId)) {
                return features[i].getFeature(null);
            }
            ++i;
        }
        return null;
    }
}

