/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.packager;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.build.AssembleConfigScriptGenerator;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;

public class PackagingConfigScriptGenerator
extends AssembleConfigScriptGenerator {
    private Properties packagingProperties;

    public void generate() throws CoreException {
        this.generatePrologue();
        this.generateMainTarget();
        this.generateAssembleTarget();
        this.generateEpilogue();
    }

    private void generatePrologue() {
        this.script.printProjectDeclaration("Package " + this.featureId, "main", null);
        this.script.printProperty("archiveName", this.computeArchiveName());
    }

    private void generateMainTarget() {
        this.script.printTargetDeclaration("main", null, null, null, null);
        HashMap<String, String> parameters = new HashMap<String, String>(1);
        parameters.put("assembleScriptName", this.filename);
        this.script.printAntTask(this.getPropertyFormat("customTargets"), null, "assemble." + this.configInfo.toStringReplacingAny(".", "ANY") + ".xml", null, null, parameters);
        this.script.printTargetEnd();
    }

    private void generateAssembleTarget() throws CoreException {
        this.script.printTargetDeclaration("assemble", null, null, null, null);
        this.generateZipRootFiles();
        this.generateZip();
        ArrayList<String> args = new ArrayList<String>(2);
        args.add("-R");
        args.add("700");
        args.add(".");
        this.script.printExecTask("chmod", String.valueOf(this.getPropertyFormat("tempDirectory")) + "/" + this.getPropertyFormat("collBase") + "/" + this.getPropertyFormat("collPlace"), args, "Linux");
        this.script.printDeleteTask(String.valueOf(this.getPropertyFormat("tempDirectory")) + "/" + this.getPropertyFormat("collBase") + "/" + this.getPropertyFormat("collPlace"), "**/*", null);
        this.script.printTargetEnd();
    }

    private void generateZipRootFiles() {
        String fileList = this.packagingProperties.getProperty("root", "");
        if (!this.configInfo.equals(Config.genericConfig())) {
            fileList = String.valueOf(fileList) + (fileList.length() == 0 ? "" : ",") + this.packagingProperties.getProperty("root." + this.configInfo.toString("."), "");
        }
        String[] files = Utils.getArrayFromString(fileList, ",");
        ArrayList<String> parameters = new ArrayList<String>(1);
        int i = 0;
        while (i < files.length) {
            String file = files[i];
            if (file.startsWith("file:")) {
                Path target = new Path(file.substring(5));
                file = target.removeLastSegments(1).toOSString();
            }
            parameters.add(String.valueOf(this.getPropertyFormat("collPlace")) + "/" + file);
            this.createZipExecCommand(parameters);
            parameters.clear();
            ++i;
        }
    }

    private void generateZip() throws CoreException {
        ArrayList<String> parameters = new ArrayList<String>(16);
        int i = 0;
        while (i < this.plugins.length) {
            parameters.add(String.valueOf(this.getPropertyFormat("collPlace")) + "/" + "plugins" + "/" + this.plugins[i].getPluginId() + "_" + this.plugins[i].getVersion());
            if (i % 15 == 0) {
                this.createZipExecCommand(parameters);
                parameters.clear();
            }
            ++i;
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        i = 0;
        while (i < this.fragments.length) {
            parameters.add(String.valueOf(this.getPropertyFormat("collPlace")) + "/" + "plugins" + "/" + this.fragments[i].getId() + "_" + this.fragments[i].getVersion());
            if (i % 15 == 0) {
                this.createZipExecCommand(parameters);
                parameters.clear();
            }
            ++i;
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        i = 0;
        while (i < this.features.length) {
            parameters.add(String.valueOf(this.getPropertyFormat("collPlace")) + "/" + "features" + "/" + this.features[i].getVersionedIdentifier().toString());
            if (i % 15 == 0) {
                this.createZipExecCommand(parameters);
                parameters.clear();
            }
            ++i;
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
    }

    private void createZipExecCommand(List parameters) {
        parameters.add(0, "-r -q " + this.getPropertyFormat("zipargs") + " " + this.getPropertyFormat("archiveName"));
        this.script.printExecTask("zip", String.valueOf(this.getPropertyFormat("tempDirectory")) + "/" + this.getPropertyFormat("collBase"), parameters, null);
    }

    private void generateEpilogue() {
        this.script.printProjectEnd();
        this.script.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPackagingPropertiesLocation(String packagingPropertiesLocation) throws CoreException {
        this.packagingProperties = new Properties();
        if (packagingPropertiesLocation == null) return;
        if (packagingPropertiesLocation.equals("")) {
            return;
        }
        BufferedInputStream propertyStream = null;
        try {
            propertyStream = new BufferedInputStream(new FileInputStream(packagingPropertiesLocation));
            try {
                this.packagingProperties.load(new BufferedInputStream(propertyStream));
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                ((InputStream)propertyStream).close();
                throw throwable;
            }
            {
                Object var3_7 = null;
                ((InputStream)propertyStream).close();
                return;
            }
        }
        catch (FileNotFoundException e) {
            String message = Policy.bind("exception.readingFile", packagingPropertiesLocation);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
        }
        catch (IOException e) {
            String message = Policy.bind("exception.readingFile", packagingPropertiesLocation);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
        }
    }
}

