/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.packager;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.pde.internal.build.packager.PackagingConfigScriptGenerator;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.model.IncludedFeatureReferenceModel;

public class PackagerBuildScriptGenerator
extends FeatureBuildScriptGenerator {
    boolean zipWithEclipse = false;
    private String packagingPropertiesLocation;
    private String[] featureList;

    public PackagerBuildScriptGenerator() {
    }

    public PackagerBuildScriptGenerator(String featureId, AssemblyInformation assemblageInformation) throws CoreException {
        super(featureId, assemblageInformation);
    }

    public void run() throws CoreException {
        AssemblyInformation assemblageInformation = new AssemblyInformation();
        int i = 0;
        while (i < this.featureList.length) {
            PackagerBuildScriptGenerator generator = new PackagerBuildScriptGenerator(this.featureList[i], assemblageInformation);
            generator.setGenerateIncludedFeatures(true);
            generator.setAnalyseChildren(true);
            generator.setSourceFeatureGeneration(false);
            generator.setBinaryFeatureGeneration(true);
            generator.setScriptGeneration(false);
            generator.setPluginPath(this.pluginPath);
            generator.setBuildSiteFactory(this.siteFactory);
            generator.setDevEntries(this.devEntries);
            generator.setCompiledElements(this.getCompiledElements());
            generator.setBuildingOSGi(AbstractScriptGenerator.isBuildingOSGi());
            this.setFeature(this.featureList[i]);
            generator.generate();
            ++i;
        }
        PackagingConfigScriptGenerator configAssembler = new PackagingConfigScriptGenerator();
        Config config = (Config)AbstractScriptGenerator.getConfigInfos().get(0);
        configAssembler.initialize(AbstractScriptGenerator.workingDirectory, "assemble.xml", "", config, assemblageInformation.getPlugins(config), assemblageInformation.getFragments(config), assemblageInformation.getFeatures(config), true);
        configAssembler.setPackagingPropertiesLocation(this.packagingPropertiesLocation);
        configAssembler.generate();
    }

    protected void generateIncludedFeatureBuildFile() throws CoreException {
        IIncludedFeatureReference[] referencedFeatures = this.feature.getIncludedFeatureReferences();
        int i = 0;
        while (i < referencedFeatures.length) {
            block3: {
                String featureId = ((IncludedFeatureReferenceModel)referencedFeatures[i]).getFeatureIdentifier();
                PackagerBuildScriptGenerator generator = new PackagerBuildScriptGenerator(featureId, this.assemblyData);
                generator.setGenerateIncludedFeatures(true);
                generator.setAnalyseChildren(true);
                generator.setSourceFeatureGeneration(false);
                generator.setBinaryFeatureGeneration(true);
                generator.setScriptGeneration(false);
                generator.setPluginPath(this.pluginPath);
                generator.setBuildSiteFactory(this.siteFactory);
                generator.setDevEntries(this.devEntries);
                generator.setCompiledElements(this.getCompiledElements());
                generator.setBuildingOSGi(AbstractScriptGenerator.isBuildingOSGi());
                try {
                    generator.generate();
                }
                catch (CoreException exception) {
                    if (exception.getStatus().getCode() != 1 || referencedFeatures[i].isOptional()) break block3;
                    throw exception;
                }
            }
            ++i;
        }
    }

    public void setPropertyFile(String propertyFile) {
        this.packagingPropertiesLocation = propertyFile;
    }

    public void setFeatureList(String features) {
        this.featureList = Utils.getArrayFromString(features, ",");
    }
}

