/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.packager;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;

public class FetchFileGenerator
extends AbstractScriptGenerator {
    private Config config;
    private String[] filters;
    private String mapLocation;
    private String collectedFiles;
    private Properties mapContent;
    private Properties selectedFiles;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws CoreException {
        this.config = (Config)AbstractScriptGenerator.getConfigInfos().get(0);
        this.collectedFiles = "";
        this.openScript(AbstractScriptGenerator.workingDirectory, "fetch.xml");
        this.generatePrologue();
        try {
            this.processMapFile();
            this.writeDirectory();
            this.generateEpilogue();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.closeScript();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.closeScript();
    }

    private void generatePrologue() {
        this.script.printProjectDeclaration("Packager' File fetcher", "main", ".");
        this.script.println();
        this.script.printTargetDeclaration("main", null, null, null, null);
    }

    private void generateEpilogue() {
        this.script.printTargetEnd();
        this.script.printProjectEnd();
        this.script.close();
    }

    public void generateFetchFileFor(String fileName, String baseurl, String loginInfo) {
        String login = null;
        String password = null;
        String[] login_password = Utils.getArrayFromString(loginInfo, ":");
        if (login_password.length == 2) {
            login = login_password[0];
            password = login_password[1];
        }
        this.script.printGet(String.valueOf(baseurl) + fileName, String.valueOf(this.getPropertyFormat("downloadDirectory")) + "/" + fileName, login, password, true);
    }

    public void setContentFilter(String filters) {
        this.filters = Utils.getArrayFromStringWithBlank(filters, "&");
    }

    public void setMapLocation(String mapLocation) {
        this.mapLocation = mapLocation;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeDirectory() throws CoreException {
        this.selectedFiles = new Properties();
        this.selectedFiles.put(this.config.toString(","), this.collectedFiles);
        try {
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(String.valueOf(AbstractScriptGenerator.workingDirectory) + "/" + "packager.directory.txt"));
            try {
                this.selectedFiles.store(stream, null);
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                ((OutputStream)stream).close();
                throw throwable;
            }
            {
                Object var2_6 = null;
                ((OutputStream)stream).close();
                return;
            }
        }
        catch (FileNotFoundException e) {
            String message = Policy.bind("exception.writingFile", String.valueOf(AbstractScriptGenerator.workingDirectory) + "/" + "packager.directory.txt");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
        catch (IOException e) {
            String message = Policy.bind("exception.writingFile", String.valueOf(AbstractScriptGenerator.workingDirectory) + "/" + "packager.directory.txt");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
    }

    private void processMapFile() throws CoreException {
        this.mapContent = this.readProperties(this.mapLocation, "");
        Iterator<Map.Entry<Object, Object>> iter = this.mapContent.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> mapEntry = iter.next();
            String fileName = (String)mapEntry.getKey();
            String[] fileDescription = Utils.getArrayFromStringWithBlank((String)mapEntry.getValue(), "|");
            if (fileDescription.length < 4) {
                String message = Policy.bind("error.incorrectDirectoryEntry", String.valueOf((String)mapEntry.getKey()) + "=" + (String)mapEntry.getValue());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 9, message, null));
            }
            String userInfos = "";
            try {
                userInfos = new URL(fileDescription[0]).getUserInfo();
            }
            catch (MalformedURLException malformedURLException) {}
            if (!this.filterByConfig(fileDescription[1]) || !this.filterByFilter(fileDescription[3])) continue;
            this.generateFetchFileFor(fileName, fileDescription[0], userInfos);
            this.collectedFiles = String.valueOf(this.collectedFiles) + fileName + ", " + (fileDescription[2].equals("") ? "." : fileDescription[2]) + " & ";
        }
    }

    private boolean filterByFilter(String filterString) {
        if (this.filters.length == 0) {
            return true;
        }
        String[] entryFilters = Utils.getArrayFromStringWithBlank(filterString, ",");
        if (entryFilters.length == 0) {
            return true;
        }
        int i = 0;
        while (i < entryFilters.length) {
            int j = 0;
            while (j < this.filters.length) {
                if (this.filters[j].equals(entryFilters[i])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private boolean filterByConfig(String entryConfigString) {
        String[] entryConfigs = Utils.getArrayFromStringWithBlank(entryConfigString, "&");
        if (entryConfigs.length == 0 || this.config.equals(Config.genericConfig())) {
            return true;
        }
        int i = 0;
        while (i < entryConfigs.length) {
            Config aConfig = new Config(entryConfigs[i]);
            if (aConfig.equals(this.config) || aConfig.equals(Config.genericConfig())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

