/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.builder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.ant.JavacTask;
import org.eclipse.pde.internal.build.builder.AbstractBuildScriptGenerator;
import org.eclipse.pde.internal.build.builder.ClasspathComputer;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.update.core.IPluginEntry;

public abstract class ModelBuildScriptGenerator
extends AbstractBuildScriptGenerator {
    protected PluginModel model;
    protected String fullName;
    protected String pluginZipDestination;
    protected String pluginUpdateJarDestination;
    private FeatureBuildScriptGenerator featureGenerator;
    protected final String PLUGIN_DESTINATION = this.getPropertyFormat("plugin.destination");
    private Properties permissionProperties;
    private String propertiesFileName = "build.properties";
    private String buildScriptFileName = "build.xml";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws CoreException {
        if (this.model == null) {
            String message = Policy.bind("error.missingElement");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, message, null));
        }
        if (this.featureGenerator != null && !this.featureGenerator.isSourceFeatureGeneration() && this.featureGenerator.getBuildProperties().containsKey("generate.plugin@" + this.model.getId())) {
            return;
        }
        this.checkBootAndRuntime();
        this.initializeVariables();
        String custom = (String)this.getBuildProperties().get("custom");
        if (custom != null && custom.equalsIgnoreCase("true")) {
            this.updateExistingScript();
            return;
        }
        this.openScript(this.getLocation(this.model), this.buildScriptFileName);
        try {
            this.generateBuildScript();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.closeScript();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.closeScript();
    }

    private void checkBootAndRuntime() throws CoreException {
        if (this.getSite(false).getPluginRegistry().getPlugin("org.eclipse.core.boot") == null) {
            Status status = new Status(4, "org.eclipse.pde.build", 5, Policy.bind("exception.missingPlugin", "org.eclipse.core.boot"), null);
            throw new CoreException((IStatus)status);
        }
        if (this.getSite(false).getPluginRegistry().getPlugin("org.eclipse.core.runtime") == null) {
            Status status = new Status(4, "org.eclipse.pde.build", 5, Policy.bind("exception.missingPlugin", "org.eclipse.core.runtime"), null);
            throw new CoreException((IStatus)status);
        }
    }

    private void initializeVariables() {
        this.fullName = String.valueOf(this.model.getId()) + "_" + this.model.getVersion();
        this.pluginZipDestination = String.valueOf(this.PLUGIN_DESTINATION) + "/" + this.fullName + ".zip";
        this.pluginUpdateJarDestination = String.valueOf(this.PLUGIN_DESTINATION) + "/" + this.fullName + ".jar";
    }

    private void generateBuildScript() throws CoreException {
        this.generatePrologue();
        this.generateBuildUpdateJarTarget();
        this.generateGatherBinPartsTarget();
        if (this.getBuildProperties().getProperty("sourcePlugin", null) == null) {
            this.generateBuildJarsTarget(this.model);
        } else {
            this.generateBuildJarsTargetForSourceGathering();
            this.generateEmptyBuildSourcesTarget();
        }
        this.generateBuildZipsTarget();
        this.generateGatherSourcesTarget();
        this.generateGatherLogTarget();
        this.generateCleanTarget();
        this.generateRefreshTarget();
        this.generateZipPluginTarget();
        this.generateEpilogue();
    }

    private void generateEmptyBuildSourcesTarget() {
        this.script.printTargetDeclaration("build.sources", null, null, null, null);
        this.script.printTargetEnd();
    }

    private void generateBuildJarsTargetForSourceGathering() throws CoreException {
        this.script.printTargetDeclaration("build.jars", null, null, null, null);
        IPluginEntry entry = Utils.getPluginEntry(this.featureGenerator.feature, this.model.getId())[0];
        Config configInfo = entry.getOS() == null && entry.getWS() == null && entry.getOSArch() == null ? Config.genericConfig() : new Config(entry.getOS(), entry.getWS(), entry.getOSArch());
        Set pluginsToGatherSourceFrom = (Set)this.featureGenerator.sourceToGather.getElementEntries().get(configInfo);
        if (pluginsToGatherSourceFrom != null) {
            Iterator iter = pluginsToGatherSourceFrom.iterator();
            while (iter.hasNext()) {
                PluginModel plugin = (PluginModel)iter.next();
                if (plugin.getId().equals(this.model.getId())) continue;
                IPath location = Utils.makeRelative((IPath)new Path(this.getLocation(plugin)), (IPath)new Path(this.getLocation(this.model)));
                this.script.printAntTask(location.append(this.buildScriptFileName).toString(), location.toOSString(), "build.sources", null, null, null);
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("destination.temp.folder", String.valueOf(this.getPropertyFormat("basedir")) + "/src");
                this.script.printAntTask(location.append(this.buildScriptFileName).toString(), location.toOSString(), "gather.sources", null, null, params);
            }
        }
        this.script.printTargetEnd();
    }

    private void generateCleanTarget() throws CoreException {
        this.script.println();
        Properties properties = this.getBuildProperties();
        JAR[] availableJars = this.extractJars(properties);
        this.script.printTargetDeclaration("clean", "init", null, null, Policy.bind("build.plugin.clean", this.model.getId()));
        int i = 0;
        while (i < availableJars.length) {
            String jarName = availableJars[i].getName(true);
            this.script.printDeleteTask(null, this.getJARLocation(jarName), null);
            this.script.printDeleteTask(null, this.getSRCLocation(jarName), null);
            ++i;
        }
        this.script.printDeleteTask(null, this.pluginUpdateJarDestination, null);
        this.script.printDeleteTask(null, this.pluginZipDestination, null);
        this.script.printDeleteTask(this.getPropertyFormat("temp.folder"), null, null);
        this.script.printTargetEnd();
    }

    private void generateGatherLogTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("gather.logs", "init", "destination.temp.folder", null, null);
        Path baseDestination = new Path(this.getPropertyFormat("destination.temp.folder"));
        baseDestination = baseDestination.append(this.fullName);
        ArrayList<IPath> destinations = new ArrayList<IPath>(5);
        Properties properties = this.getBuildProperties();
        JAR[] availableJars = this.extractJars(properties);
        int i = 0;
        while (i < availableJars.length) {
            String name = availableJars[i].getName(true);
            IPath destination = baseDestination.append(name).removeLastSegments(1);
            if (!destinations.contains(destination)) {
                this.script.printMkdirTask(destination.toString());
                destinations.add(destination);
            }
            this.script.printCopyTask(String.valueOf(this.getTempJARFolderLocation(name)) + ".log", destination.toString(), null);
            ++i;
        }
        this.script.printTargetEnd();
    }

    private void generateZipIndividualTarget(String zipName, String source) throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration(zipName, "init", null, null, null);
        Path root = new Path(this.getPropertyFormat("basedir"));
        this.script.printZipTask(root.append(zipName).toString(), root.append(source).toString(), false, null);
        this.script.printTargetEnd();
    }

    private void generateGatherSourcesTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("gather.sources", "init", "destination.temp.folder", null, null);
        Path baseDestination = new Path(this.getPropertyFormat("destination.temp.folder"));
        baseDestination = baseDestination.append(this.fullName);
        ArrayList<IPath> destinations = new ArrayList<IPath>(5);
        Properties properties = this.getBuildProperties();
        JAR[] availableJars = this.extractJars(properties);
        int i = 0;
        while (i < availableJars.length) {
            String jar = availableJars[i].getName(true);
            IPath destination = baseDestination.append(jar).removeLastSegments(1);
            if (!destinations.contains(destination)) {
                this.script.printMkdirTask(destination.toString());
                destinations.add(destination);
            }
            this.script.printCopyTask(this.getSRCLocation(jar), destination.toString(), null);
            ++i;
        }
        String include = (String)this.getBuildProperties().get("src.includes");
        String exclude = (String)this.getBuildProperties().get("src.excludes");
        if (include != null || exclude != null) {
            FileSet fileSet = new FileSet(this.getPropertyFormat("basedir"), null, include, null, exclude, null, null);
            this.script.printCopyTask(null, baseDestination.toString(), new FileSet[]{fileSet});
        }
        this.script.printTargetEnd();
    }

    private void generateGatherBinPartsTarget() throws CoreException {
        FileSet fileSet;
        this.script.println();
        this.script.printTargetDeclaration("gather.bin.parts", "init", "destination.temp.folder", null, null);
        Path destination = new Path(this.getPropertyFormat("destination.temp.folder"));
        destination = destination.append(this.fullName);
        String root = destination.toString();
        this.script.printMkdirTask(root);
        ArrayList<Path> destinations = new ArrayList<Path>(5);
        destinations.add(destination);
        String include = (String)this.getBuildProperties().get("bin.includes");
        String exclude = (String)this.getBuildProperties().get("bin.excludes");
        if (include != null || exclude != null) {
            fileSet = new FileSet(this.getPropertyFormat("build.result.folder"), null, this.replaceVariables(include, true), null, this.replaceVariables(exclude, true), null, null);
            this.script.printCopyTask(null, root, new FileSet[]{fileSet});
        }
        if (include != null || exclude != null) {
            fileSet = new FileSet(this.getPropertyFormat("basedir"), null, this.replaceVariables(include, true), null, this.replaceVariables(exclude, true), null, null);
            this.script.printCopyTask(null, root, new FileSet[]{fileSet});
        }
        this.generatePermissionProperties(root);
        this.script.printTargetEnd();
    }

    private void generatePermissionProperties(String directory) throws CoreException {
        this.getPermissionProperties();
        Iterator<Map.Entry<Object, Object>> iter = this.permissionProperties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> permission = iter.next();
            String instruction = (String)permission.getKey();
            String parameters = (String)permission.getValue();
            int index = instruction.indexOf("permissions");
            if (index != -1) {
                this.generateChmodInstruction(directory, instruction.substring(index + "permissions".length() + 1), parameters);
                continue;
            }
            if (!instruction.startsWith("link")) continue;
            this.generateLinkInstruction(directory, parameters);
        }
    }

    private void generateChmodInstruction(String dir, String rights, String files) {
        if (rights.equals("executable")) {
            rights = "755";
        }
        this.script.printChmod(dir, rights, files);
    }

    private void generateLinkInstruction(String dir, String files) {
        String[] links = Utils.getArrayFromString(files, ",");
        ArrayList<String> arguments = new ArrayList<String>(2);
        int i = 0;
        while (i < links.length) {
            arguments.add(links[i]);
            arguments.add(links[i + 1]);
            this.script.printExecTask("ln -s", dir, arguments, "Linux");
            arguments.clear();
            i += 2;
        }
    }

    protected Properties getPermissionProperties() throws CoreException {
        if (this.permissionProperties == null) {
            this.permissionProperties = this.readProperties(this.getLocation(this.model), "permissions.properties");
        }
        return this.permissionProperties;
    }

    private void generateZipPluginTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("zip.plugin", "init", null, null, Policy.bind("build.plugin.zipPlugin", this.model.getId()));
        this.script.printDeleteTask(this.getPropertyFormat("temp.folder"), null, null);
        this.script.printMkdirTask(this.getPropertyFormat("temp.folder"));
        this.script.printAntCallTask("build.jars", null, null);
        this.script.printAntCallTask("build.sources", null, null);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("destination.temp.folder", String.valueOf(this.getPropertyFormat("temp.folder")) + "/");
        this.script.printAntCallTask("gather.bin.parts", null, params);
        this.script.printAntCallTask("gather.sources", null, params);
        FileSet fileSet = new FileSet(this.getPropertyFormat("temp.folder"), null, "**/*.bin.log", null, null, null, null);
        this.script.printDeleteTask(null, null, new FileSet[]{fileSet});
        this.script.printZipTask(this.pluginZipDestination, this.getPropertyFormat("temp.folder"), true, null);
        this.script.printDeleteTask(this.getPropertyFormat("temp.folder"), null, null);
        this.script.printTargetEnd();
    }

    private void generateBuildUpdateJarTarget() {
        this.script.println();
        this.script.printTargetDeclaration("build.update.jar", "init", null, null, Policy.bind("build.plugin.buildUpdateJar", this.model.getId()));
        this.script.printDeleteTask(this.getPropertyFormat("temp.folder"), null, null);
        this.script.printMkdirTask(this.getPropertyFormat("temp.folder"));
        this.script.printAntCallTask("build.jars", null, null);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("destination.temp.folder", String.valueOf(this.getPropertyFormat("temp.folder")) + "/");
        this.script.printAntCallTask("gather.bin.parts", null, params);
        this.script.printZipTask(this.pluginUpdateJarDestination, String.valueOf(this.getPropertyFormat("temp.folder")) + "/" + this.fullName, false, null);
        this.script.printDeleteTask(this.getPropertyFormat("temp.folder"), null, null);
        this.script.printTargetEnd();
    }

    private void generateRefreshTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("refresh", "init", "eclipse.running", null, Policy.bind("build.plugin.refresh"));
        this.script.printConvertPathTask(new Path(this.getLocation(this.model)).removeLastSegments(0).toOSString().replace('\\', '/'), "resourcePath", false);
        this.script.printRefreshLocalTask(this.model.getId(), "infinite");
        this.script.printTargetEnd();
    }

    private void generateEpilogue() {
        this.script.println();
        this.script.printProjectEnd();
    }

    private void generatePrologue() {
        this.script.printProjectDeclaration(this.model.getId(), "build.jars", ".");
        this.script.println();
        this.script.printProperty("bootclasspath", "");
        this.script.printProperty("basews", this.getPropertyFormat("ws"));
        this.script.printProperty("baseos", this.getPropertyFormat("os"));
        this.script.printProperty("basearch", this.getPropertyFormat("arch"));
        this.script.printProperty("basenl", this.getPropertyFormat("nl"));
        this.script.printProperty("javacFailOnError", "false");
        this.script.printProperty("javacDebugInfo", "on");
        this.script.printProperty("javacVerbose", "true");
        this.script.printProperty("javacSource", "1.3");
        this.script.printProperty("javacTarget", "1.1");
        this.script.println();
        this.script.printTargetDeclaration("init", "properties", null, null, null);
        this.script.printProperty("temp.folder", String.valueOf(this.getPropertyFormat("basedir")) + "/" + "temp.folder");
        this.script.printProperty("plugin.destination", this.getPropertyFormat("basedir"));
        this.script.printProperty("build.result.folder", this.getPropertyFormat("basedir"));
        this.script.printTargetEnd();
        this.script.println();
        this.script.printTargetDeclaration("properties", null, "eclipse.running", null, null);
        this.script.printProperty("build.compiler", "org.eclipse.jdt.core.JDTCompilerAdapter");
        this.script.printTargetEnd();
    }

    protected abstract String getModelTypeName();

    public void setModel(PluginModel model) throws CoreException {
        if (model == null) {
            String message = Policy.bind("error.missingElement");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, message, null));
        }
        this.model = model;
        this.getCompiledElements().add(model.getId());
    }

    public void setModelId(String modelId) throws CoreException {
        PluginModel newModel = this.getModel(modelId);
        if (newModel == null) {
            String message = Policy.bind("exception.missingElement", modelId);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, message, null));
        }
        this.setModel(newModel);
    }

    protected abstract PluginModel getModel(String var1) throws CoreException;

    private void generateBuildZipsTarget() throws CoreException {
        StringBuffer zips = new StringBuffer();
        Properties props = this.getBuildProperties();
        Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("source.") || !key.endsWith(".zip")) continue;
            String zipName = key.substring("source.".length());
            zips.append(',');
            zips.append(zipName);
            this.generateZipIndividualTarget(zipName, (String)entry.getValue());
        }
        this.script.println();
        this.script.printTargetDeclaration("build.zips", "init" + zips.toString(), null, null, null);
        this.script.printTargetEnd();
    }

    public void setFeatureGenerator(FeatureBuildScriptGenerator featureGenerator) {
        this.featureGenerator = featureGenerator;
    }

    private void generateBuildJarsTarget(PluginModel pluginModel) throws CoreException {
        Properties properties = this.getBuildProperties();
        JAR[] availableJars = this.extractJars(properties);
        ArrayList<String> jarNames = new ArrayList<String>(availableJars.length);
        HashMap<String, JAR> jars = new HashMap<String, JAR>(availableJars.length);
        int i = 0;
        while (i < availableJars.length) {
            jars.put(availableJars[i].getName(false), availableJars[i]);
            ++i;
        }
        String jarOrder = (String)this.getBuildProperties().get("jars.compile.order");
        ClasspathComputer classpath = new ClasspathComputer(this);
        if (jarOrder != null) {
            String[] order = Utils.getArrayFromString(jarOrder);
            int i2 = 0;
            while (i2 < order.length) {
                JAR jar = (JAR)jars.get(order[i2]);
                if (jar != null) {
                    String name = jar.getName(false);
                    jarNames.add(name);
                    this.generateJARTarget(classpath.getClasspath(pluginModel, jar), jar);
                    this.generateSRCTarget(jar);
                    jars.remove(order[i2]);
                }
                ++i2;
            }
        }
        Iterator iterator = jars.values().iterator();
        while (iterator.hasNext()) {
            JAR jar = (JAR)iterator.next();
            String name = jar.getName(false);
            jarNames.add(name);
            this.generateJARTarget(classpath.getClasspath(pluginModel, jar), jar);
            this.generateSRCTarget(jar);
        }
        this.script.println();
        this.script.printTargetDeclaration("build.jars", "init", null, null, Policy.bind("build.plugin.buildJars", pluginModel.getId()));
        Iterator iter = jarNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            this.script.printAvailableTask(name, this.replaceVariables(this.getJARLocation(name), true));
            this.script.printAntCallTask(name, null, null);
        }
        this.script.printTargetEnd();
        this.script.println();
        this.script.printTargetDeclaration("build.sources", "init", null, null, null);
        iter = jarNames.iterator();
        while (iter.hasNext()) {
            String jarName = (String)iter.next();
            String srcName = this.getSRCName(jarName);
            this.script.printAvailableTask(srcName, this.getSRCLocation(jarName));
            this.script.printAntCallTask(srcName, null, null);
        }
        this.script.printTargetEnd();
    }

    private void generateJARTarget(String classpath, JAR jar) throws CoreException {
        this.script.println();
        String name = jar.getName(false);
        this.script.printTargetDeclaration(name, "init", null, jar.getName(true), Policy.bind("build.plugin.jar", name));
        String destdir = this.getTempJARFolderLocation(jar.getName(true));
        this.script.printDeleteTask(destdir, null, null);
        this.script.printMkdirTask(destdir);
        this.script.printComment("compile the source code");
        JavacTask javac = new JavacTask();
        javac.setClasspath(classpath);
        javac.setBootClasspath(this.getPropertyFormat("bootclasspath"));
        javac.setDestdir(destdir);
        javac.setFailOnError(this.getPropertyFormat("javacFailOnError"));
        javac.setDebug(this.getPropertyFormat("javacDebugInfo"));
        javac.setVerbose(this.getPropertyFormat("javacVerbose"));
        javac.setIncludeAntRuntime("no");
        javac.setSource(this.getPropertyFormat("javacSource"));
        javac.setTarget(this.getPropertyFormat("javacTarget"));
        String[] sources = jar.getSource();
        javac.setSrcdir(sources);
        this.script.print(javac);
        this.script.printComment("copy necessary resources");
        FileSet[] fileSets = new FileSet[sources.length];
        int i = 0;
        while (i < sources.length) {
            fileSets[i] = new FileSet(sources[i], null, null, null, "**/*.java", null, null);
            ++i;
        }
        this.script.printCopyTask(null, destdir, fileSets);
        String jarLocation = this.getJARLocation(jar.getName(true));
        this.script.printMkdirTask(new Path(jarLocation).removeLastSegments(1).toString());
        this.script.printJarTask(jarLocation, destdir);
        this.script.printDeleteTask(destdir, null, null);
        this.script.printTargetEnd();
    }

    protected JAR[] extractJars(Properties properties) {
        ArrayList<JAR> result = new ArrayList<JAR>(5);
        int prefixLength = "source.".length();
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("source.") || !key.endsWith(".jar")) continue;
            key = key.substring(prefixLength);
            String[] source = Utils.getArrayFromString((String)entry.getValue());
            String[] output = Utils.getArrayFromString(properties.getProperty("output." + key));
            String[] extraClasspath = Utils.getArrayFromString(properties.getProperty("extra." + key));
            JAR jar = new JAR(key, source, output, extraClasspath);
            result.add(jar);
        }
        return result.toArray(new JAR[result.size()]);
    }

    private void generateSRCTarget(JAR jar) throws CoreException {
        this.script.println();
        String name = jar.getName(false);
        String srcName = this.getSRCName(name);
        this.script.printTargetDeclaration(srcName, "init", null, srcName, null);
        String[] sources = jar.getSource();
        this.filterNonExistingSourceFolders(sources);
        FileSet[] fileSets = new FileSet[sources.length];
        int count = 0;
        int i = 0;
        while (i < sources.length) {
            if (sources[i] != null) {
                fileSets[count++] = new FileSet(sources[i], null, "**/*.java", null, null, null, null);
            }
            ++i;
        }
        String srcLocation = this.getSRCLocation(name);
        this.script.printMkdirTask(new Path(srcLocation).removeLastSegments(1).toString());
        if (count != 0) {
            this.script.printZipTask(srcLocation, null, false, fileSets);
        }
        this.script.printTargetEnd();
    }

    private void filterNonExistingSourceFolders(String[] sources) {
        File pluginRoot;
        try {
            pluginRoot = new File(this.getLocation(this.model));
        }
        catch (CoreException e) {
            Platform.getPlugin((String)"org.eclipse.pde.build").getLog().log(e.getStatus());
            return;
        }
        int i = 0;
        while (i < sources.length) {
            File file = new File(pluginRoot, sources[i]);
            if (!file.exists()) {
                sources[i] = null;
                Status status = new Status(2, "org.eclipse.pde.build", 11, Policy.bind("warning.cannotLocateSource", file.getAbsolutePath()), null);
                Platform.getPlugin((String)"org.eclipse.pde.build").getLog().log((IStatus)status);
            }
            ++i;
        }
    }

    protected String getSRCLocation(String jarName) {
        return this.getSRCName(this.getJARLocation(jarName));
    }

    protected String getTempJARFolderLocation(String jarName) {
        Path destination = new Path(this.getPropertyFormat("temp.folder"));
        destination = destination.append(String.valueOf(jarName) + ".bin");
        return destination.toString();
    }

    protected String getJARLocation(String jarName) {
        return new Path(this.getPropertyFormat("build.result.folder")).append(jarName).toString();
    }

    protected Properties getBuildProperties() throws CoreException {
        if (this.buildProperties == null) {
            this.buildProperties = this.readProperties(this.getLocation(this.model), this.propertiesFileName);
        }
        return this.buildProperties;
    }

    protected String getSRCName(String jarName) {
        return String.valueOf(jarName.substring(0, jarName.length() - 4)) + "src.zip";
    }

    private void updateExistingScript() throws CoreException {
        String root = this.getLocation(this.model);
        File buildFile = new File(root, this.buildScriptFileName);
        try {
            this.updateVersion(buildFile, "version.suffix", this.model.getVersion());
        }
        catch (IOException e) {
            String message = Policy.bind("exception.writeScript");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 7, message, (Throwable)e));
        }
    }

    protected String replaceVariables(String sourceString, boolean compiledElement) {
        if (sourceString == null) {
            return null;
        }
        int i = -1;
        String result = sourceString;
        while ((i = result.indexOf("$ws$")) >= 0) {
            result = String.valueOf(result.substring(0, i)) + "ws/" + this.getPropertyFormat(compiledElement ? "ws" : "basews") + result.substring(i + "$ws$".length());
        }
        while ((i = result.indexOf("$os$")) >= 0) {
            result = String.valueOf(result.substring(0, i)) + "os/" + this.getPropertyFormat(compiledElement ? "os" : "baseos") + result.substring(i + "$os$".length());
        }
        while ((i = result.indexOf("$arch$")) >= 0) {
            result = String.valueOf(result.substring(0, i)) + "arch/" + this.getPropertyFormat(compiledElement ? "arch" : "basearch") + result.substring(i + "$os$".length());
        }
        while ((i = result.indexOf("$nl$")) >= 0) {
            result = String.valueOf(result.substring(0, i)) + "nl/" + this.getPropertyFormat(compiledElement ? "nl" : "basenl") + result.substring(i + "$nl$".length());
        }
        return result;
    }

    public PluginModel getModel() {
        return this.model;
    }

    public String getPropertiesFileName() {
        return this.propertiesFileName;
    }

    public void setPropertiesFileName(String propertyFileName) {
        this.propertiesFileName = propertyFileName;
    }

    public String getBuildScriptFileName() {
        return this.buildScriptFileName;
    }

    public void setBuildScriptFileName(String buildScriptFileName) {
        this.buildScriptFileName = buildScriptFileName;
    }

    public boolean hasManifest() {
        try {
            return new File(this.getLocation(this.model), "META-INF/MANIFEST.MF").exists();
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected class JAR {
        private String name;
        private String resolvedName;
        private String[] source;
        private String[] output;
        private String[] extraClasspath;

        protected JAR(String name, String[] source, String[] output, String[] extraClasspath) {
            this.name = name;
            this.source = source;
            this.output = output;
            this.extraClasspath = extraClasspath;
        }

        protected String getName(boolean resolved) {
            if (!resolved) {
                return this.name;
            }
            if (this.resolvedName == null) {
                this.resolvedName = ModelBuildScriptGenerator.this.replaceVariables(this.name, true);
            }
            return this.resolvedName;
        }

        protected String[] getSource() {
            return this.source;
        }

        public String[] getOutput() {
            return this.output;
        }

        public String[] getExtraClasspath() {
            return this.extraClasspath;
        }
    }
}

