/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.builder;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.SourceFeatureInformation;
import org.eclipse.pde.internal.build.SourceFeatureWriter;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.builder.AbstractBuildScriptGenerator;
import org.eclipse.pde.internal.build.builder.PluginBuildScriptGenerator;
import org.eclipse.update.core.Feature;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPlatformEnvironment;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.IncludedFeatureReferenceModel;
import org.eclipse.update.core.model.PluginEntryModel;

public class FeatureBuildScriptGenerator
extends AbstractBuildScriptGenerator {
    protected boolean analyseIncludedFeatures = false;
    protected boolean analysePlugins = true;
    protected boolean sourceFeatureGeneration = false;
    protected boolean binaryFeature = true;
    private boolean scriptGeneration = true;
    protected String featureIdentifier;
    protected IFeature feature;
    protected String featureFullName;
    protected String featureFolderName;
    protected String featureRootLocation;
    protected String featureTempFolder;
    protected Feature sourceFeature;
    protected PluginEntry sourcePlugin;
    protected String sourceFeatureFullName;
    protected String sourceFeatureFullNameVersionned;
    protected SourceFeatureInformation sourceToGather;
    protected boolean sourcePluginOnly = false;
    private String[] extraPlugins = new String[0];

    public FeatureBuildScriptGenerator() {
    }

    public FeatureBuildScriptGenerator(String featureId, AssemblyInformation informationGathering) throws CoreException {
        if (featureId == null) {
            String message = Policy.bind("error.missingFeatureId");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, message, null));
        }
        this.featureIdentifier = featureId;
        this.assemblyData = informationGathering;
    }

    protected List computeElements(boolean fragments) throws CoreException {
        ArrayList<PluginFragmentModel> result = new ArrayList<PluginFragmentModel>(5);
        IPluginEntry[] pluginList = this.feature.getRawPluginEntries();
        int i = 0;
        while (i < pluginList.length) {
            IPluginEntry entry = pluginList[i];
            if (fragments == entry.isFragment()) {
                Object model;
                VersionedIdentifier identifier = entry.getVersionedIdentifier();
                String versionRequested = identifier.getVersion().toString();
                if (versionRequested.equals("0.0.0")) {
                    versionRequested = null;
                }
                if ((model = fragments ? this.getSite(false).getPluginRegistry().getFragment(identifier.getIdentifier(), versionRequested) : this.getSite(false).getPluginRegistry().getPlugin(identifier.getIdentifier(), versionRequested)) == null && this.getBuildProperties().containsKey("generate.plugin@" + identifier.getIdentifier())) {
                    this.generateEmbeddedSource(identifier.getIdentifier());
                    model = this.getSite(true).getPluginRegistry().getPlugin(identifier.getIdentifier(), versionRequested);
                }
                if (model == null) {
                    String message = Policy.bind("exception.missingPlugin", entry.getVersionedIdentifier().toString());
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 5, message, null));
                }
                result.add((PluginFragmentModel)model);
                this.getCompiledElements().add(model.getId());
                this.collectElementToAssemble(pluginList[i]);
                this.collectSourcePlugins(pluginList[i], (PluginModel)model);
            }
            ++i;
        }
        return result;
    }

    private void generateEmbeddedSource(String pluginId) throws CoreException {
        FeatureBuildScriptGenerator featureGenerator = new FeatureBuildScriptGenerator(Utils.getArrayFromString(this.getBuildProperties().getProperty("generate.plugin@" + pluginId))[0], this.assemblyData);
        featureGenerator.setGenerateIncludedFeatures(false);
        featureGenerator.setAnalyseChildren(this.analysePlugins);
        featureGenerator.setSourceFeatureGeneration(true);
        featureGenerator.setExtraPlugins(Utils.getArrayFromString(this.getBuildProperties().getProperty("generate.plugin@" + pluginId)));
        featureGenerator.setBinaryFeatureGeneration(false);
        featureGenerator.setScriptGeneration(false);
        featureGenerator.setPluginPath(this.pluginPath);
        featureGenerator.setBuildSiteFactory(this.siteFactory);
        featureGenerator.setDevEntries(this.devEntries);
        featureGenerator.setCompiledElements(this.getCompiledElements());
        featureGenerator.setSourceToGather(this.sourceToGather);
        featureGenerator.setSourcePluginOnly(true);
        featureGenerator.setBuildingOSGi(AbstractScriptGenerator.isBuildingOSGi());
        featureGenerator.generate();
    }

    public void setSourcePluginOnly(boolean b) {
        this.sourcePluginOnly = b;
    }

    private void collectSourcePlugins(IPluginEntry pluginEntry, PluginModel model) {
        if (!this.sourceFeatureGeneration) {
            return;
        }
        if (pluginEntry.getOS() == null && pluginEntry.getWS() == null && pluginEntry.getOSArch() == null) {
            this.sourceToGather.addElementEntry(Config.genericConfig(), model);
            return;
        }
        List correctConfigs = this.selectConfigs((IPlatformEnvironment)pluginEntry);
        Iterator iter = correctConfigs.iterator();
        while (iter.hasNext()) {
            this.sourceToGather.addElementEntry((Config)iter.next(), model);
        }
    }

    public void setAnalyseChildren(boolean generate) {
        this.analysePlugins = generate;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws CoreException {
        if (AbstractScriptGenerator.workingDirectory == null) {
            String message = Policy.bind("error.missingInstallLocation");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 2, message, null));
        }
        this.initializeVariables();
        String custom = (String)this.getBuildProperties().get("custom");
        if (custom != null && custom.equalsIgnoreCase("true")) {
            File buildFile = new File(this.featureRootLocation, "build.xml");
            try {
                this.updateVersion(buildFile, "feature.version.suffix", this.feature.getVersionedIdentifier().getVersion().toString());
                return;
            }
            catch (IOException e) {
                String message = Policy.bind("exception.writeScript");
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 7, message, (Throwable)e));
            }
        }
        if (this.sourceFeatureGeneration) {
            this.generateSourceFeature();
        }
        if (this.analysePlugins) {
            this.generateChildrenScripts();
        }
        if (this.sourceFeatureGeneration) {
            this.addSourceFragmentsToFeature();
            this.writeSourceFeature();
            this.getSite(true);
        }
        if (!this.sourcePluginOnly) {
            this.collectElementToAssemble(this.getSite(false).findFeature(this.feature.getVersionedIdentifier().getIdentifier()));
        }
        if (this.analyseIncludedFeatures) {
            this.generateIncludedFeatureBuildFile();
        }
        if (this.sourceFeatureGeneration) {
            this.generateSourceFeatureScripts();
        }
        if (!this.scriptGeneration) return;
        this.openScript(this.featureRootLocation, "build.xml");
        try {
            this.generateBuildScript();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.closeScript();
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        this.closeScript();
    }

    protected void generateIncludedFeatureBuildFile() throws CoreException {
        IIncludedFeatureReference[] referencedFeatures = this.feature.getIncludedFeatureReferences();
        int i = 0;
        while (i < referencedFeatures.length) {
            String featureId = ((IncludedFeatureReferenceModel)referencedFeatures[i]).getFeatureIdentifier();
            boolean doSourceFeatureGeneration = this.getBuildProperties().containsKey("generate.feature@" + featureId);
            FeatureBuildScriptGenerator generator = new FeatureBuildScriptGenerator(doSourceFeatureGeneration ? Utils.getArrayFromString(this.getBuildProperties().getProperty("generate.feature@" + featureId))[0] : featureId, this.assemblyData);
            generator.setGenerateIncludedFeatures(!doSourceFeatureGeneration);
            generator.setAnalyseChildren(this.analysePlugins);
            generator.setSourceFeatureGeneration(doSourceFeatureGeneration);
            generator.setBinaryFeatureGeneration(!doSourceFeatureGeneration);
            generator.setScriptGeneration(!doSourceFeatureGeneration);
            if (doSourceFeatureGeneration) {
                generator.setExtraPlugins(Utils.getArrayFromString(this.getBuildProperties().getProperty("generate.feature@" + featureId)));
            }
            generator.setPluginPath(this.pluginPath);
            generator.setBuildSiteFactory(this.siteFactory);
            generator.setDevEntries(this.devEntries);
            generator.setCompiledElements(this.getCompiledElements());
            generator.setSourceToGather(new SourceFeatureInformation());
            generator.setBuildingOSGi(AbstractScriptGenerator.isBuildingOSGi());
            generator.generate();
            ++i;
        }
    }

    protected void setExtraPlugins(String[] plugins) {
        this.extraPlugins = plugins;
    }

    private void generateBuildScript() throws CoreException {
        this.getSite(true);
        this.generatePrologue();
        this.generateAllPluginsTarget();
        this.generateAllFeaturesTarget();
        this.generateUpdateFeatureFile();
        this.generateAllChildrenTarget();
        this.generateChildrenTarget();
        this.generateBuildJarsTarget();
        this.generateBuildZipsTarget();
        this.generateBuildUpdateJarTarget();
        this.generateGatherBinPartsTarget();
        this.generateZipDistributionWholeTarget();
        this.generateZipSourcesTarget();
        this.generateZipLogsTarget();
        this.generateCleanTarget();
        this.generateRefreshTarget();
        this.generateGatherSourcesTarget();
        this.generateGatherLogsTarget();
        this.generateEpilogue();
    }

    private void generateGatherSourcesTarget() throws CoreException {
        this.script.printTargetDeclaration("gather.sources", null, null, null, null);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("destination.temp.folder", String.valueOf(this.getPropertyFormat("feature.temp.folder")) + "/" + "plugins" + "/" + this.sourceFeatureFullNameVersionned + "/" + "src");
        params.put("target", "gather.sources");
        this.script.printAntCallTask("children", null, params);
        this.script.printTargetEnd();
    }

    private void generateGatherLogsTarget() {
        this.script.println();
        this.script.printTargetDeclaration("gather.logs", "init", null, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("target", "gather.logs");
        params.put("destination.temp.folder", new Path(this.featureTempFolder).append("plugins").toString());
        this.script.printAntCallTask("all.children", "false", params);
        this.script.printTargetEnd();
    }

    private void generateUpdateFeatureFile() {
        this.script.printTargetDeclaration("update.feature", "init", null, null, null);
        this.script.printTargetEnd();
    }

    private void generateBuildZipsTarget() throws CoreException {
        StringBuffer zips = new StringBuffer();
        Properties props = this.getBuildProperties();
        Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("source.") || !key.endsWith(".zip")) continue;
            String zipName = key.substring("source.".length());
            zips.append(',');
            zips.append(zipName);
            this.generateZipIndividualTarget(zipName, (String)entry.getValue());
        }
        this.script.println();
        this.script.printTargetDeclaration("build.zips", "init" + zips.toString(), null, null, null);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("target", "build.zips");
        this.script.printAntCallTask("all.children", null, params);
        this.script.printTargetEnd();
    }

    private void generateZipIndividualTarget(String zipName, String source) throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration(zipName, "init", null, null, null);
        this.script.printZipTask(String.valueOf(this.getPropertyFormat("basedir")) + "/" + zipName, String.valueOf(this.getPropertyFormat("basedir")) + "/" + source, false, null);
        this.script.printTargetEnd();
    }

    private void generateCleanTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("clean", "init", null, null, Policy.bind("build.feature.clean", this.featureIdentifier));
        this.script.printDeleteTask(null, String.valueOf(this.getPropertyFormat("feature.destination")) + "/" + this.featureFullName + ".jar", null);
        this.script.printDeleteTask(null, String.valueOf(this.getPropertyFormat("feature.destination")) + "/" + this.featureFullName + ".bin.dist.zip", null);
        this.script.printDeleteTask(null, String.valueOf(this.getPropertyFormat("feature.destination")) + "/" + this.featureFullName + ".log.zip", null);
        this.script.printDeleteTask(null, String.valueOf(this.getPropertyFormat("feature.destination")) + "/" + this.featureFullName + ".src.zip", null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("target", "clean");
        this.script.printAntCallTask("all.children", null, params);
        this.script.printTargetEnd();
    }

    private void generateZipLogsTarget() {
        this.script.println();
        this.script.printTargetDeclaration("zip.logs", "init", null, null, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("include.children", "true");
        params.put("target", "gather.logs");
        params.put("destination.temp.folder", new Path(this.featureTempFolder).append("plugins").toString());
        this.script.printAntCallTask("all.children", "false", params);
        IPath destination = new Path(this.getPropertyFormat("feature.destination")).append(String.valueOf(this.featureFullName) + ".log.zip");
        this.script.printZipTask(destination.toString(), this.featureTempFolder, true, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printTargetEnd();
    }

    protected void generateZipSourcesTarget() {
        this.script.println();
        this.script.printTargetDeclaration("zip.sources", "init", null, null, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("include.children", "true");
        params.put("target", "gather.sources");
        params.put("destination.temp.folder", String.valueOf(this.featureTempFolder) + "/" + "plugins" + "/" + this.sourceFeatureFullNameVersionned + "/" + "src");
        this.script.printAntCallTask("all.children", null, params);
        this.script.printZipTask(String.valueOf(this.getPropertyFormat("feature.destination")) + "/" + this.featureFullName + ".src.zip", this.featureTempFolder, true, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printTargetEnd();
    }

    private void generateGatherBinPartsTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("gather.bin.parts", "init", "feature.base", null, null);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("target", "gather.bin.parts");
        params.put("destination.temp.folder", new Path(this.getPropertyFormat("feature.base")).append("plugins").toString());
        this.script.printAntCallTask("children", null, params);
        String include = (String)this.getBuildProperties().get("bin.includes");
        String exclude = (String)this.getBuildProperties().get("bin.excludes");
        String root = String.valueOf(this.getPropertyFormat("feature.base")) + "/" + this.featureFolderName;
        this.script.printMkdirTask(root);
        if (include != null || exclude != null) {
            FileSet fileSet = new FileSet(this.getPropertyFormat("basedir"), null, include, null, exclude, null, null);
            this.script.printCopyTask(null, root, new FileSet[]{fileSet});
        }
        String featureVersionInfo = "";
        IIncludedFeatureReference[] includedFeatures = this.feature.getRawIncludedFeatureReferences();
        int i = 0;
        while (i < includedFeatures.length) {
            IFeature includedFeature = this.getSite(false).findFeature(includedFeatures[i].getVersionedIdentifier().getIdentifier());
            VersionedIdentifier includedFeatureVersionId = includedFeature.getVersionedIdentifier();
            featureVersionInfo = String.valueOf(featureVersionInfo) + includedFeatureVersionId.getIdentifier() + "," + includedFeatureVersionId.getVersion().toString() + ",";
            ++i;
        }
        String pluginVersionInfo = "";
        IPluginEntry[] pluginsIncluded = this.feature.getRawPluginEntries();
        int i2 = 0;
        while (i2 < pluginsIncluded.length) {
            VersionedIdentifier identifier = pluginsIncluded[i2].getVersionedIdentifier();
            String versionRequested = identifier.getVersion().toString();
            if (versionRequested.equals("0.0.0")) {
                versionRequested = null;
            }
            String entryIdentifier = identifier.getIdentifier();
            Object model = pluginsIncluded[i2].isFragment() ? this.getSite(false).getPluginRegistry().getFragment(entryIdentifier, versionRequested) : this.getSite(false).getPluginRegistry().getPlugin(entryIdentifier, versionRequested);
            pluginVersionInfo = String.valueOf(pluginVersionInfo) + entryIdentifier + "," + model.getVersion() + ",";
            ++i2;
        }
        this.script.println("<eclipse.idReplacer featureFilePath=\"" + root + "/" + "feature.xml" + "\" featureIds=\"" + featureVersionInfo + "\" pluginIds=\"" + pluginVersionInfo + "\"/>");
        this.generateRootFilesAndPermissionsCalls();
        this.script.printTargetEnd();
        this.generateRootFilesAndPermissions();
    }

    private void generateRootFilesAndPermissionsCalls() {
        this.script.printAntCallTask("ROOTFILES" + this.getPropertyFormat("os") + "_" + this.getPropertyFormat("ws") + "_" + this.getPropertyFormat("arch"), null, null);
    }

    private void generateRootFilesAndPermissions() throws CoreException {
        Iterator iter = AbstractScriptGenerator.getConfigInfos().iterator();
        while (iter.hasNext()) {
            Config aConfig = (Config)iter.next();
            this.script.printTargetDeclaration("ROOTFILES" + aConfig.toString("_"), null, null, null, null);
            this.generateCopyRootFiles(aConfig);
            this.generatePermissions(aConfig);
            this.script.printTargetEnd();
        }
    }

    private void generateCopyRootFiles(Config aConfig) throws CoreException {
        String baseList = this.getBuildProperties().getProperty("root", "");
        String fileList = this.getBuildProperties().getProperty("root." + aConfig.toString("."), "");
        fileList = String.valueOf(fileList.length() == 0 ? "" : String.valueOf(fileList) + ",") + baseList;
        if (fileList.equals("")) {
            return;
        }
        this.assemblyData.setCopyRootFile(aConfig);
        String configName = aConfig.toStringReplacingAny(".", "ANY");
        this.script.printMkdirTask(String.valueOf(this.getPropertyFormat("feature.base")) + "/" + configName + "/" + this.getPropertyFormat("collPlace"));
        String[] files = Utils.getArrayFromString(fileList, ",");
        FileSet[] fileSet = new FileSet[files.length];
        int i = 0;
        while (i < files.length) {
            String fromDir = String.valueOf(this.getPropertyFormat("basedir")) + "/";
            String file = files[i];
            if (file.startsWith("file:")) {
                Path target = new Path(file.substring(5));
                fileSet[i] = new FileSet(String.valueOf(fromDir) + target.removeLastSegments(1), null, target.lastSegment(), null, null, null, null);
            } else {
                fileSet[i] = new FileSet(String.valueOf(fromDir) + file, null, "**", null, null, null, null);
            }
            ++i;
        }
        this.script.printCopyTask(null, String.valueOf(this.getPropertyFormat("feature.base")) + "/" + configName + "/" + this.getPropertyFormat("collPlace"), fileSet);
    }

    private void generatePermissions(Config aConfig) throws CoreException {
        String configInfix = aConfig.toString(".");
        Properties featureProperties = this.getBuildProperties();
        String prefixPermissions = "root." + configInfix + "." + "permissions" + ".";
        String prefixLinks = "root." + configInfix + "." + "link";
        String commonPermissions = "root.permissions.";
        String commonLinks = "root.link";
        Iterator<Map.Entry<Object, Object>> iter = featureProperties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> permission = iter.next();
            String instruction = (String)permission.getKey();
            String parameters = (String)permission.getValue();
            if (instruction.startsWith(prefixPermissions)) {
                this.generateChmodInstruction(String.valueOf(this.getPropertyFormat("feature.base")) + "/" + configInfix + "/" + this.getPropertyFormat("collPlace"), instruction.substring(prefixPermissions.length()), parameters);
                continue;
            }
            if (instruction.startsWith(prefixLinks)) {
                this.generateLinkInstruction(String.valueOf(this.getPropertyFormat("feature.base")) + "/" + configInfix + "/" + this.getPropertyFormat("collPlace"), parameters);
                continue;
            }
            if (instruction.startsWith(commonPermissions)) {
                this.generateChmodInstruction(String.valueOf(this.getPropertyFormat("feature.base")) + "/" + configInfix + "/" + this.getPropertyFormat("collPlace"), instruction.substring(commonPermissions.length()), parameters);
                continue;
            }
            if (!instruction.startsWith(commonLinks)) continue;
            this.generateLinkInstruction(String.valueOf(this.getPropertyFormat("feature.base")) + "/" + configInfix + "/" + this.getPropertyFormat("collPlace"), parameters);
        }
    }

    private void generateChmodInstruction(String dir, String rights, String files) {
        if (rights.equals("executable")) {
            rights = "755";
        }
        this.script.printChmod(dir, rights, files);
    }

    private void generateLinkInstruction(String dir, String files) {
        String[] links = Utils.getArrayFromString(files, ",");
        ArrayList<String> arguments = new ArrayList<String>(2);
        int i = 0;
        while (i < links.length) {
            arguments.add("-s");
            arguments.add(links[i]);
            arguments.add(links[i + 1]);
            this.script.printExecTask("ln", dir, arguments, "Linux");
            arguments.clear();
            i += 2;
        }
    }

    private void generateBuildUpdateJarTarget() {
        this.script.println();
        this.script.printTargetDeclaration("build.update.jar", "init", null, null, Policy.bind("build.feature.buildUpdateJar", this.featureIdentifier));
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("target", "build.update.jar");
        this.script.printAntCallTask("all.children", null, params);
        this.script.printProperty("feature.base", this.featureTempFolder);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        params.clear();
        params.put("feature.base", this.featureTempFolder);
        params.put("os", this.feature.getOS() == null ? Config.ANY : this.feature.getOS());
        params.put("ws", this.feature.getWS() == null ? Config.ANY : this.feature.getWS());
        params.put("arch", this.feature.getOSArch() == null ? Config.ANY : this.feature.getOSArch());
        params.put("nl", this.feature.getNL() == null ? Config.ANY : this.feature.getNL());
        this.script.printAntCallTask("gather.bin.parts", "false", params);
        this.script.printJarTask(String.valueOf(this.getPropertyFormat("feature.destination")) + "/" + this.featureFullName + ".jar", String.valueOf(this.featureTempFolder) + "/" + this.featureFolderName);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printTargetEnd();
    }

    protected void generateZipDistributionWholeTarget() {
        this.script.println();
        this.script.printTargetDeclaration("zip.distribution", "init", null, null, Policy.bind("build.feature.zips", this.featureIdentifier));
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("feature.base", this.featureTempFolder);
        params.put("include.children", "true");
        params.put("os", this.feature.getOS() == null ? Config.ANY : this.feature.getOS());
        params.put("ws", this.feature.getWS() == null ? Config.ANY : this.feature.getWS());
        params.put("arch", this.feature.getOSArch() == null ? Config.ANY : this.feature.getOSArch());
        params.put("nl", this.feature.getNL() == null ? Config.ANY : this.feature.getNL());
        this.script.printAntCallTask("gather.bin.parts", null, params);
        this.script.printZipTask(String.valueOf(this.getPropertyFormat("feature.destination")) + "/" + this.featureFullName + ".bin.dist.zip", this.featureTempFolder, false, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printTargetEnd();
    }

    private void generateAllChildrenTarget() {
        StringBuffer depends = new StringBuffer();
        depends.append("init");
        depends.append(',');
        depends.append("all.features");
        depends.append(',');
        depends.append("all.plugins");
        depends.append(',');
        depends.append("update.feature");
        this.script.println();
        this.script.printTargetDeclaration("all.children", depends.toString(), null, null, null);
        this.script.printTargetEnd();
    }

    protected void generateAllPluginsTarget() throws CoreException {
        List plugins = this.computeElements(false);
        List fragments = this.computeElements(true);
        String[] sortedPlugins = Utils.computePrerequisiteOrder(plugins.toArray(new PluginModel[plugins.size()]), fragments.toArray(new PluginModel[fragments.size()]), AbstractScriptGenerator.isBuildingOSGi());
        this.script.println();
        this.script.printTargetDeclaration("all.plugins", "init", null, null, null);
        HashSet<String> writtenCalls = new HashSet<String>(plugins.size() + fragments.size());
        int i = 0;
        while (i < sortedPlugins.length) {
            PluginDescriptorModel plugin = this.getSite(false).getPluginRegistry().getPlugin(sortedPlugins[i]);
            if (plugin == null) {
                plugin = this.getSite(false).getPluginRegistry().getFragment(sortedPlugins[i]);
            }
            if (!writtenCalls.contains(sortedPlugins[i])) {
                writtenCalls.add(sortedPlugins[i]);
                IPluginEntry[] entries = Utils.getPluginEntry(this.feature, sortedPlugins[i]);
                int j = 0;
                while (j < entries.length) {
                    List list = this.selectConfigs((IPlatformEnvironment)entries[j]);
                    if (list.size() != 0) {
                        HashMap<String, String> params = null;
                        Config aMatchingConfig = (Config)list.get(0);
                        params = new HashMap<String, String>(3);
                        if (!aMatchingConfig.getOs().equals(Config.ANY)) {
                            params.put("os", aMatchingConfig.getOs());
                        }
                        if (!aMatchingConfig.getWs().equals(Config.ANY)) {
                            params.put("ws", aMatchingConfig.getWs());
                        }
                        if (!aMatchingConfig.getArch().equals(Config.ANY)) {
                            params.put("arch", aMatchingConfig.getArch());
                        }
                        IPath location = Utils.makeRelative((IPath)new Path(this.getLocation((PluginModel)plugin)), (IPath)new Path(this.featureRootLocation));
                        this.script.printAntTask("build.xml", location.toString(), this.getPropertyFormat("target"), null, null, params);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.script.printTargetEnd();
    }

    private void generateAllFeaturesTarget() throws CoreException {
        this.script.printTargetDeclaration("all.features", "init", null, null, null);
        if (this.analyseIncludedFeatures) {
            IIncludedFeatureReference[] features = this.feature.getIncludedFeatureReferences();
            int i = 0;
            while (i < features.length) {
                String featureId = features[i].getVersionedIdentifier().getIdentifier();
                IFeature includedFeature = this.getSite(false).findFeature(featureId);
                String includedFeatureDirectory = includedFeature.getURL().getPath();
                int j = includedFeatureDirectory.lastIndexOf("feature.xml");
                if (j != -1) {
                    includedFeatureDirectory = includedFeatureDirectory.substring(0, j);
                }
                IPath location = Utils.makeRelative((IPath)new Path(includedFeatureDirectory), (IPath)new Path(this.featureRootLocation));
                this.script.printAntTask("build.xml", location.toString(), this.getPropertyFormat("target"), null, null, null);
                ++i;
            }
        }
        this.script.printTargetEnd();
    }

    private void generateEpilogue() {
        this.script.println();
        this.script.printProjectEnd();
    }

    private void generatePrologue() {
        this.script.printProjectDeclaration(this.feature.getVersionedIdentifier().getIdentifier(), "build.update.jar", ".");
        this.script.println();
        this.script.printTargetDeclaration("init", null, null, null, null);
        this.script.printProperty("feature.temp.folder", String.valueOf(this.getPropertyFormat("basedir")) + "/" + "feature.temp.folder");
        this.script.printProperty("feature.destination", this.getPropertyFormat("basedir"));
        this.script.printTargetEnd();
    }

    private void generateChildrenScripts() throws CoreException {
        List plugins = this.computeElements(false);
        List fragments = this.computeElements(true);
        this.generateModels(plugins);
        this.generateModels(fragments);
    }

    private void generateModels(List models) throws CoreException {
        if (!this.scriptGeneration) {
            return;
        }
        if (!this.binaryFeature || models.isEmpty()) {
            return;
        }
        Iterator iterator = models.iterator();
        while (iterator.hasNext()) {
            PluginModel model = (PluginModel)iterator.next();
            PluginBuildScriptGenerator generator = new PluginBuildScriptGenerator();
            generator.setBuildSiteFactory(this.siteFactory);
            generator.setModel(model);
            generator.setFeatureGenerator(this);
            generator.setPluginPath(this.getPluginPath());
            generator.setBuildingOSGi(AbstractScriptGenerator.isBuildingOSGi());
            generator.setCompiledElements(this.getCompiledElements());
            generator.generate();
        }
    }

    public void setFeature(String featureID) throws CoreException {
        if (featureID == null) {
            String message = Policy.bind("error.missingFeatureId");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, message, null));
        }
        this.featureIdentifier = featureID;
    }

    private void initializeVariables() throws CoreException {
        this.feature = this.getSite(false).findFeature(this.featureIdentifier);
        if (this.feature == null) {
            String message = Policy.bind("exception.missingFeature", this.featureIdentifier);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, message, null));
        }
        if (this.featureRootLocation == null) {
            this.featureRootLocation = this.feature.getURL().getPath();
            int i = this.featureRootLocation.lastIndexOf("feature.xml");
            if (i != -1) {
                this.featureRootLocation = this.featureRootLocation.substring(0, i);
            }
        }
        this.featureFullName = this.feature.getVersionedIdentifier().toString();
        this.featureFolderName = "features/" + this.featureFullName;
        this.sourceFeatureFullName = this.computeSourceFeatureName(this.feature, false);
        this.sourceFeatureFullNameVersionned = this.computeSourceFeatureName(this.feature, true);
        this.featureTempFolder = this.getPropertyFormat("feature.temp.folder");
    }

    private String computeSourceFeatureName(IFeature featureForName, boolean withNumber) {
        return String.valueOf(featureForName.getVersionedIdentifier().getIdentifier()) + ".source" + (withNumber ? "_" + featureForName.getVersionedIdentifier().getVersion().toString() : "");
    }

    protected Properties getBuildProperties() throws CoreException {
        if (this.buildProperties == null) {
            this.buildProperties = this.readProperties(this.featureRootLocation, "build.properties");
        }
        return this.buildProperties;
    }

    private void generateChildrenTarget() {
        this.script.println();
        this.script.printTargetDeclaration("children", null, "include.children", null, null);
        this.script.printAntCallTask("all.children", null, null);
        this.script.printTargetEnd();
    }

    private void generateBuildJarsTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("build.jars", "init", null, null, Policy.bind("build.feature.buildJars", this.featureIdentifier));
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("target", "build.jars");
        this.script.printAntCallTask("all.children", null, params);
        this.script.printTargetEnd();
        this.script.println();
        this.script.printTargetDeclaration("build.sources", "init", null, null, null);
        params.clear();
        params.put("target", "build.sources");
        this.script.printAntCallTask("all.children", null, params);
        this.script.printTargetEnd();
    }

    private void generateRefreshTarget() {
        this.script.println();
        this.script.printTargetDeclaration("refresh", "init", "eclipse.running", null, Policy.bind("build.feature.refresh", this.featureIdentifier));
        this.script.printConvertPathTask(new Path(this.featureRootLocation).removeLastSegments(0).toOSString().replace('\\', '/'), "resourcePath", false);
        this.script.printRefreshLocalTask(this.getPropertyFormat(this.featureFullName), "infinite");
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("target", "refresh");
        this.script.printAntCallTask("all.children", null, params);
        this.script.printTargetEnd();
    }

    public void setGenerateIncludedFeatures(boolean recursiveGeneration) {
        this.analyseIncludedFeatures = recursiveGeneration;
    }

    protected void collectElementToAssemble(IFeature featureToCollect) throws CoreException {
        if (this.assemblyData == null) {
            return;
        }
        List correctConfigs = this.selectConfigs((IPlatformEnvironment)featureToCollect);
        Iterator iter = correctConfigs.iterator();
        while (iter.hasNext()) {
            Config config = (Config)iter.next();
            this.assemblyData.addFeature(config, this.feature);
        }
    }

    private void generateSourceFeature() throws CoreException {
        Feature featureExample = (Feature)this.feature;
        this.sourceFeature = this.createSourceFeature(featureExample);
        this.associateExtraPlugins();
        this.sourcePlugin = this.createSourcePlugin();
        this.generateSourceFragment();
        this.getSite(true);
    }

    private void generateSourceFragment() throws CoreException {
        Map fragments = this.sourceToGather.getElementEntries();
        Iterator iter = fragments.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry fragmentInfo = iter.next();
            Config configInfo = (Config)fragmentInfo.getKey();
            if (configInfo.equals(Config.genericConfig())) continue;
            PluginEntry sourceFragment = new PluginEntry();
            String sourceFragmentId = String.valueOf(this.sourceFeature.getFeatureIdentifier()) + "." + configInfo.toString(".");
            sourceFragment.setPluginIdentifier(sourceFragmentId);
            sourceFragment.setPluginVersion(this.sourceFeature.getFeatureVersion());
            sourceFragment.setOS(configInfo.getOs());
            sourceFragment.setWS(configInfo.getWs());
            sourceFragment.setArch(configInfo.getArch());
            sourceFragment.isFragment(true);
            this.createSourceFragment(sourceFragment, this.sourcePlugin);
        }
        this.getSite(true);
    }

    private void addSourceFragmentsToFeature() throws CoreException {
        Map fragments = this.sourceToGather.getElementEntries();
        Iterator iter = fragments.entrySet().iterator();
        while (iter.hasNext()) {
            Set sourceList;
            Map.Entry fragmentInfo = iter.next();
            Config configInfo = (Config)fragmentInfo.getKey();
            if (configInfo.equals(Config.genericConfig()) || (sourceList = (Set)fragmentInfo.getValue()).size() == 0) continue;
            PluginEntry sourceFragment = new PluginEntry();
            String sourceFragmentId = String.valueOf(this.sourceFeature.getFeatureIdentifier()) + "." + configInfo.toString(".");
            sourceFragment.setPluginIdentifier(sourceFragmentId);
            sourceFragment.setPluginVersion(this.sourceFeature.getFeatureVersion());
            sourceFragment.setOS(configInfo.getOs());
            sourceFragment.setWS(configInfo.getWs());
            sourceFragment.setArch(configInfo.getArch());
            sourceFragment.isFragment(true);
            this.sourceFeature.addPluginEntryModel((PluginEntryModel)sourceFragment);
        }
        this.getSite(true);
    }

    private void generateSourceFeatureScripts() throws CoreException {
        FeatureBuildScriptGenerator sourceScriptGenerator = new FeatureBuildScriptGenerator(this.sourceFeatureFullName, this.assemblyData);
        sourceScriptGenerator.setGenerateIncludedFeatures(false);
        sourceScriptGenerator.setAnalyseChildren(true);
        sourceScriptGenerator.setSourceToGather(this.sourceToGather);
        sourceScriptGenerator.setBinaryFeatureGeneration(true);
        sourceScriptGenerator.setSourceFeatureGeneration(false);
        sourceScriptGenerator.setScriptGeneration(true);
        sourceScriptGenerator.setPluginPath(this.pluginPath);
        sourceScriptGenerator.setBuildSiteFactory(this.siteFactory);
        sourceScriptGenerator.setDevEntries(this.devEntries);
        sourceScriptGenerator.setCompiledElements(this.getCompiledElements());
        sourceScriptGenerator.setSourcePluginOnly(this.sourcePluginOnly);
        sourceScriptGenerator.setBuildingOSGi(AbstractScriptGenerator.isBuildingOSGi());
        sourceScriptGenerator.generate();
    }

    private void associateExtraPlugins() throws CoreException {
        int i = 1;
        while (i < this.extraPlugins.length) {
            Object model = this.extraPlugins[i].startsWith("plugin@") ? this.getSite(false).getPluginRegistry().getPlugin(this.extraPlugins[i].substring(7)) : this.getSite(false).getPluginRegistry().getFragment(this.extraPlugins[i].substring(8));
            if (model == null) {
                String message = Policy.bind("exception.missingPlugin", this.extraPlugins[i]);
                Platform.getPlugin((String)"org.eclipse.pde.build").getLog().log((IStatus)new Status(2, this.extraPlugins[i], 5, message, null));
            }
            PluginEntry entry = new PluginEntry();
            entry.setPluginIdentifier(model.getId());
            entry.setPluginVersion(model.getVersion());
            this.sourceFeature.addPluginEntryModel((PluginEntryModel)entry);
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PluginEntry createSourcePlugin() throws CoreException {
        StringBuffer buffer;
        PluginEntry result = new PluginEntry();
        String sourcePluginId = this.sourceFeature.getFeatureIdentifier();
        result.setPluginIdentifier(sourcePluginId);
        result.setPluginVersion(this.sourceFeature.getFeatureVersion());
        this.sourceFeature.addPluginEntryModel((PluginEntryModel)result);
        Path sourcePluginDirURL = new Path(String.valueOf(AbstractScriptGenerator.workingDirectory) + "/" + "plugins" + "/" + this.getSourcePluginName(result, false));
        File sourcePluginDir = sourcePluginDirURL.toFile();
        sourcePluginDir.mkdir();
        String templatePluginXML = "templates/plugin/plugin.xml";
        URL templatePluginURL = Platform.getPlugin((String)"org.eclipse.pde.build").find((IPath)new Path(templatePluginXML));
        if (templatePluginURL == null) {
            return null;
        }
        try {
            buffer = this.readFile(templatePluginURL.openStream());
        }
        catch (IOException e1) {
            String message = Policy.bind("exception.readingFile", templatePluginXML);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e1));
        }
        int beginId = this.scan(buffer, 0, "PLUGIN_ID");
        buffer.replace(beginId, beginId + "PLUGIN_ID".length(), result.getPluginIdentifier());
        beginId = this.scan(buffer, beginId, "PLUGIN_VERSION");
        buffer.replace(beginId, beginId + "PLUGIN_VERSION".length(), result.getPluginVersion());
        try {
            Utils.transferStreams(new ByteArrayInputStream(buffer.toString().getBytes()), new FileOutputStream(sourcePluginDirURL.append("plugin.xml").toOSString()));
        }
        catch (IOException e1) {
            String message = Policy.bind("exception.readingFile", templatePluginXML);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e1));
        }
        Collection copiedFiles = Utils.copyFiles(String.valueOf(this.featureRootLocation) + "/" + "sourceTemplatePlugin", sourcePluginDir.getAbsolutePath());
        File buildProperty = sourcePluginDirURL.append("build.properties").toFile();
        if (buildProperty.exists()) return result;
        copiedFiles.add("plugin.xml");
        copiedFiles.add("src/**/*.zip");
        Properties sourceBuildProperties = new Properties();
        sourceBuildProperties.put("bin.includes", Utils.getStringFromCollection(copiedFiles, ","));
        sourceBuildProperties.put("sourcePlugin", "true");
        try {
            BufferedOutputStream buildFile = new BufferedOutputStream(new FileOutputStream(buildProperty));
            try {
                sourceBuildProperties.store(buildFile, null);
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                ((OutputStream)buildFile).close();
                throw throwable;
            }
            {
                Object var13_21 = null;
                ((OutputStream)buildFile).close();
                return result;
            }
        }
        catch (FileNotFoundException e) {
            String message = Policy.bind("exception.writingFile", buildProperty.getAbsolutePath());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
        catch (IOException e) {
            String message = Policy.bind("exception.writingFile", buildProperty.getAbsolutePath());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSourceFragment(PluginEntry fragment, PluginEntry plugin) throws CoreException {
        Path sourceFragmentDirURL = new Path(String.valueOf(AbstractScriptGenerator.workingDirectory) + "/" + "plugins" + "/" + this.getSourcePluginName(fragment, false));
        File sourceFragmentDir = new File(sourceFragmentDirURL.toOSString());
        sourceFragmentDir.mkdir();
        try {
            URL templateLocation = Platform.getPlugin((String)"org.eclipse.pde.build").find((IPath)new Path("templates/fragment/fragment.xml"));
            if (templateLocation == null) {
                return;
            }
            StringBuffer buffer = this.readFile(templateLocation.openStream());
            int beginId = this.scan(buffer, 0, "FRAGMENT_ID");
            buffer.replace(beginId, beginId + "FRAGMENT_ID".length(), fragment.getPluginIdentifier());
            beginId = this.scan(buffer, beginId, "FRAGMENT_VERSION");
            buffer.replace(beginId, beginId + "FRAGMENT_VERSION".length(), fragment.getPluginVersion());
            beginId = this.scan(buffer, beginId, "PLUGIN_ID");
            buffer.replace(beginId, beginId + "PLUGIN_ID".length(), plugin.getPluginIdentifier());
            beginId = this.scan(buffer, beginId, "PLUGIN_VERSION");
            buffer.replace(beginId, beginId + "PLUGIN_VERSION".length(), plugin.getPluginVersion());
            Utils.transferStreams(new ByteArrayInputStream(buffer.toString().getBytes()), new FileOutputStream(sourceFragmentDirURL.append("fragment.xml").toOSString()));
            Collection copiedFiles = Utils.copyFiles(String.valueOf(this.featureRootLocation) + "/" + "sourceTemplateFragment", sourceFragmentDir.getAbsolutePath());
            File buildProperty = sourceFragmentDirURL.append("build.properties").toFile();
            if (buildProperty.exists()) return;
            copiedFiles.add("fragment.xml");
            copiedFiles.add("src/**");
            Properties sourceBuildProperties = new Properties();
            sourceBuildProperties.put("bin.includes", Utils.getStringFromCollection(copiedFiles, ","));
            sourceBuildProperties.put("sourcePlugin", "true");
            try {
                BufferedOutputStream buildFile = new BufferedOutputStream(new FileOutputStream(buildProperty));
                try {
                    sourceBuildProperties.store(buildFile, null);
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    ((OutputStream)buildFile).close();
                    throw throwable;
                }
                {
                    Object var12_17 = null;
                    ((OutputStream)buildFile).close();
                    return;
                }
            }
            catch (FileNotFoundException e) {
                String message = Policy.bind("exception.writingFile", buildProperty.getAbsolutePath());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
            }
            catch (IOException e) {
                String message = Policy.bind("exception.writingFile", buildProperty.getAbsolutePath());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
            }
        }
        catch (IOException iOException) {
            String message = Policy.bind("exception.writingFile", sourceFragmentDir.getName());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, null));
        }
    }

    public String getSourcePluginName(PluginEntry plugin, boolean versionSuffix) {
        return String.valueOf(plugin.getPluginIdentifier()) + (versionSuffix ? "_" + plugin.getPluginVersion() : "");
    }

    public void setFeatureRootLocation(String featureLocation) {
        this.featureRootLocation = featureLocation;
    }

    public void setSourceToGather(SourceFeatureInformation sourceToGather) {
        this.sourceToGather = sourceToGather;
    }

    public void setSourceFeatureGeneration(boolean sourceFeatureGeneration) {
        this.sourceFeatureGeneration = sourceFeatureGeneration;
    }

    public void setBinaryFeatureGeneration(boolean binaryFeatureGeneration) {
        this.binaryFeature = binaryFeatureGeneration;
    }

    public void setScriptGeneration(boolean scriptGeneration) {
        this.scriptGeneration = scriptGeneration;
    }

    public boolean isSourceFeatureGeneration() {
        return this.sourceFeatureGeneration;
    }

    protected void collectElementToAssemble(IPluginEntry entryToCollect) throws CoreException {
        if (this.assemblyData == null) {
            return;
        }
        List correctConfigs = this.selectConfigs((IPlatformEnvironment)entryToCollect);
        String versionRequested = entryToCollect.getVersionedIdentifier().getVersion().toString();
        if (versionRequested.equals("0.0.0")) {
            versionRequested = null;
        }
        Object effectivePlugin = null;
        effectivePlugin = entryToCollect.isFragment() ? this.getSite(false).getPluginRegistry().getFragment(entryToCollect.getVersionedIdentifier().getIdentifier(), versionRequested) : this.getSite(false).getPluginRegistry().getPlugin(entryToCollect.getVersionedIdentifier().getIdentifier(), versionRequested);
        Iterator iter = correctConfigs.iterator();
        while (iter.hasNext()) {
            if (entryToCollect.isFragment()) {
                this.assemblyData.addFragment((Config)iter.next(), (PluginModel)effectivePlugin);
                continue;
            }
            this.assemblyData.addPlugin((Config)iter.next(), (PluginModel)effectivePlugin);
        }
    }

    private Feature createSourceFeature(Feature featureExample) throws CoreException {
        Feature result = new Feature();
        result.setFeatureIdentifier(this.computeSourceFeatureName((IFeature)featureExample, false));
        result.setFeatureVersion(featureExample.getVersionedIdentifier().getVersion().toString());
        result.setLabel(featureExample.getLabelNonLocalized());
        result.setProvider(featureExample.getProviderNonLocalized());
        result.setImageURLString(featureExample.getImageURLString());
        result.setInstallHandlerModel(featureExample.getInstallHandlerModel());
        result.setDescriptionModel(featureExample.getDescriptionModel());
        result.setCopyrightModel(featureExample.getCopyrightModel());
        result.setLicenseModel(featureExample.getLicenseModel());
        result.setUpdateSiteEntryModel(featureExample.getUpdateSiteEntryModel());
        result.setOS(featureExample.getOS());
        result.setArch(featureExample.getOSArch());
        result.setWS(featureExample.getWS());
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeSourceFeature() throws CoreException {
        String sourceFeatureDir = String.valueOf(AbstractScriptGenerator.workingDirectory) + "/" + "features" + "/" + this.sourceFeatureFullName;
        File sourceDir = new File(sourceFeatureDir);
        sourceDir.mkdir();
        File file = new File(String.valueOf(sourceFeatureDir) + "/" + "feature.xml");
        try {
            SourceFeatureWriter writer = new SourceFeatureWriter((OutputStream)new FileOutputStream(file), this.sourceFeature, this);
            try {
                writer.printFeature();
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                writer.close();
                throw throwable;
            }
            {
                Object var5_9 = null;
                writer.close();
            }
        }
        catch (IOException e) {
            String message = Policy.bind("error.creatingFeature", this.sourceFeature.getFeatureIdentifier());
            throw new CoreException((IStatus)new Status(0, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
        Collection copiedFiles = Utils.copyFiles(String.valueOf(this.featureRootLocation) + "/" + "sourceTemplateFeature", sourceFeatureDir);
        File buildProperty = new File(String.valueOf(sourceFeatureDir) + "/" + "build.properties");
        if (buildProperty.exists()) {
            return;
        }
        copiedFiles.add("feature.xml");
        Properties sourceBuildProperties = new Properties();
        sourceBuildProperties.put("bin.includes", Utils.getStringFromCollection(copiedFiles, ","));
        try {
            sourceBuildProperties.store(new FileOutputStream(buildProperty), null);
            return;
        }
        catch (FileNotFoundException e) {
            String message = Policy.bind("exception.writingFile", buildProperty.getAbsolutePath());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
        catch (IOException e) {
            String message = Policy.bind("exception.writingFile", buildProperty.getAbsolutePath());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
    }
}

