/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.builder;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.LibraryModel;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.core.runtime.model.PluginPrerequisiteModel;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.IXMLConstants;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.builder.ModelBuildScriptGenerator;

public class ClasspathComputer
implements IPDEBuildConstants,
IXMLConstants {
    private ModelBuildScriptGenerator generator;

    public ClasspathComputer(ModelBuildScriptGenerator generator) {
        this.generator = generator;
    }

    public String getClasspath(PluginModel model, ModelBuildScriptGenerator.JAR jar) throws CoreException {
        ArrayList classpath = new ArrayList(20);
        ArrayList pluginChain = new ArrayList(10);
        String location = this.generator.getLocation(model);
        if (!AbstractScriptGenerator.isBuildingOSGi() || AbstractScriptGenerator.isBuildingOSGi() && !this.generator.hasManifest()) {
            this.addPlugin(this.getPlugin("org.eclipse.core.boot", null), classpath, location);
        }
        this.addSelf(model, jar, classpath, location, pluginChain);
        this.addPrerequisites(model, classpath, location, pluginChain);
        return Utils.getStringFromCollection(classpath, ";");
    }

    private void addPlugin(PluginModel plugin, List classpath, String location) throws CoreException {
        this.addRuntimeLibraries(plugin, classpath, location);
        this.addFragmentsLibraries(plugin, classpath, location);
    }

    private void addRuntimeLibraries(PluginModel model, List classpath, String baseLocation) throws CoreException {
        LibraryModel[] libraries = model.getRuntime();
        if (libraries == null) {
            return;
        }
        String root = this.generator.getLocation(model);
        IPath base = Utils.makeRelative((IPath)new Path(root), (IPath)new Path(baseLocation));
        int i = 0;
        while (i < libraries.length) {
            this.addDevEntries(model, baseLocation, classpath, Utils.getArrayFromString(this.generator.getBuildProperties().getProperty("output." + libraries[i].getName())));
            String library = base.append(libraries[i].getName()).toString();
            this.addPathAndCheck(model.getId(), library, classpath);
            ++i;
        }
    }

    private PluginModel getPlugin(String id, String version) throws CoreException {
        PluginDescriptorModel plugin = this.generator.getSite(false).getPluginRegistry().getPlugin(id, version);
        return plugin;
    }

    private void addFragmentsLibraries(PluginModel plugin, List classpath, String baseLocation) throws CoreException {
        if (!(plugin instanceof PluginDescriptorModel)) {
            return;
        }
        PluginDescriptorModel pluginModel = (PluginDescriptorModel)plugin;
        PluginFragmentModel[] fragments = pluginModel.getFragments();
        if (fragments == null) {
            return;
        }
        int i = 0;
        while (i < fragments.length) {
            if (fragments[i] != this.generator.getModel()) {
                this.addPluginLibrariesToFragmentLocations(plugin, fragments[i], classpath, baseLocation);
                this.addRuntimeLibraries((PluginModel)fragments[i], classpath, baseLocation);
            }
            ++i;
        }
    }

    private void addPluginLibrariesToFragmentLocations(PluginModel plugin, PluginFragmentModel fragment, List classpath, String baseLocation) throws CoreException {
        LibraryModel[] libraries = plugin.getRuntime();
        if (libraries == null) {
            return;
        }
        String root = this.generator.getLocation((PluginModel)fragment);
        IPath base = Utils.makeRelative((IPath)new Path(root), (IPath)new Path(baseLocation));
        int i = 0;
        while (i < libraries.length) {
            String libraryName = base.append(libraries[i].getName()).toString();
            this.addPathAndCheck(fragment.getId(), libraryName, classpath);
            ++i;
        }
    }

    private void addPathAndCheck(String pluginId, String path, List classpath) {
        if (!classpath.contains(path = this.generator.replaceVariables(path, pluginId == null ? false : this.generator.getCompiledElements().contains(pluginId)))) {
            classpath.add(path);
        }
    }

    private void addSelf(PluginModel model, ModelBuildScriptGenerator.JAR jar, List classpath, String location, List pluginChain) throws CoreException {
        String extraClasspath;
        Properties modelProperties;
        String jarOrder;
        if (model instanceof PluginFragmentModel) {
            PluginDescriptorModel plugin = this.generator.getSite(false).getPluginRegistry().getPlugin(((PluginFragmentModel)model).getPlugin());
            this.addPluginAndPrerequisites((PluginModel)plugin, classpath, location, pluginChain);
        }
        if ((jarOrder = (String)(modelProperties = this.generator.getBuildProperties()).get("jars.compile.order")) == null) {
            LibraryModel[] libraries = model.getRuntime();
            if (libraries != null) {
                int i = 0;
                while (i < libraries.length) {
                    String libraryName = libraries[i].getName();
                    if (!jar.getName(false).equals(libraryName)) {
                        boolean isSource;
                        boolean bl = isSource = modelProperties.getProperty("source." + libraryName) != null;
                        if (isSource) {
                            this.addDevEntries(model, location, classpath, Utils.getArrayFromString(modelProperties.getProperty("output." + libraryName)));
                        }
                        this.addPathAndCheck(model.getId(), libraryName, classpath);
                    }
                    ++i;
                }
            }
        } else {
            String[] order = Utils.getArrayFromString(jarOrder);
            int i = 0;
            while (i < order.length) {
                if (order[i].equals(jar.getName(false))) break;
                this.addDevEntries(model, location, classpath, Utils.getArrayFromString((String)modelProperties.get("output." + order[i])));
                this.addPathAndCheck(model.getId(), order[i], classpath);
                ++i;
            }
            LibraryModel[] libraries = model.getRuntime();
            int i2 = 0;
            while (i2 < libraries.length) {
                String libraryName = libraries[i2].getName();
                if (modelProperties.get("source." + libraryName) == null) {
                    this.addPathAndCheck(model.getId(), libraryName, classpath);
                }
                ++i2;
            }
        }
        if ((extraClasspath = (String)modelProperties.get("jars.extra.classpath")) != null) {
            String[] extra = Utils.getArrayFromString(extraClasspath, ";,");
            int i = 0;
            while (i < extra.length) {
                this.addPathAndCheck(null, this.computeExtraPath(extra[i], location), classpath);
                ++i;
            }
        }
        String[] jarSpecificExtraClasspath = jar.getExtraClasspath();
        int i = 0;
        while (i < jarSpecificExtraClasspath.length) {
            this.addPathAndCheck(null, this.computeExtraPath(jarSpecificExtraClasspath[i], location), classpath);
            ++i;
        }
    }

    private String computeExtraPath(String url, String location) throws CoreException {
        String relativePath = null;
        String[] urlfragments = Utils.getArrayFromString(url, "/");
        if (urlfragments.length > 2 && urlfragments[0].equals("platform:")) {
            String modelLocation = null;
            if (urlfragments[1].equalsIgnoreCase("plugin")) {
                modelLocation = this.generator.getLocation((PluginModel)this.generator.getSite(false).getPluginRegistry().getPlugin(urlfragments[2]));
            }
            if (urlfragments[1].equalsIgnoreCase("fragment")) {
                modelLocation = this.generator.getLocation((PluginModel)this.generator.getSite(false).getPluginRegistry().getFragment(urlfragments[2]));
            }
            if (urlfragments[1].equalsIgnoreCase("resource")) {
                String message = Policy.bind("exception.url", String.valueOf(this.generator.getPropertiesFileName()) + "::" + url);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 3, message, null));
            }
            if (modelLocation != null) {
                int i = 3;
                while (i < urlfragments.length) {
                    modelLocation = i == 3 ? String.valueOf(modelLocation) + urlfragments[i] : String.valueOf(modelLocation) + "/" + urlfragments[i];
                    ++i;
                }
                relativePath = Utils.makeRelative((IPath)new Path(modelLocation), (IPath)new Path(location)).toOSString();
                return relativePath;
            }
        }
        try {
            URL extraURL = new URL(url);
            try {
                relativePath = Utils.makeRelative((IPath)new Path(Platform.resolve((URL)extraURL).getFile()), (IPath)new Path(location)).toOSString();
            }
            catch (IOException e) {
                String message = Policy.bind("exception.url", String.valueOf(this.generator.getPropertiesFileName()) + "::" + url);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 3, message, (Throwable)e));
            }
        }
        catch (MalformedURLException malformedURLException) {
            relativePath = url;
        }
        return relativePath;
    }

    private void addPrerequisites(PluginModel target, List classpath, String baseLocation, List pluginChain) throws CoreException {
        PluginPrerequisiteModel[] requires;
        if (pluginChain.contains(target)) {
            if (AbstractScriptGenerator.isBuildingOSGi() ? target == this.getPlugin("org.eclipse.core.runtime", null) || target == this.getPlugin("org.eclipse.osgi", null) || target == this.getPlugin("org.eclipse.core.runtime.osgi", null) : target == this.getPlugin("org.eclipse.core.runtime", null)) {
                return;
            }
            String message = Policy.bind("error.pluginCycle");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 14, message, null));
        }
        if ((!AbstractScriptGenerator.isBuildingOSGi() || AbstractScriptGenerator.isBuildingOSGi() && !this.generator.hasManifest()) && target != this.getPlugin("org.eclipse.core.runtime", null) && target != this.getPlugin("org.eclipse.core.runtime.osgi", null) && target != this.getPlugin("org.eclipse.osgi", null) && target != this.getPlugin("org.eclipse.core.runtime.compatibility", null)) {
            this.addPluginAndPrerequisites(this.getPlugin("org.eclipse.core.runtime", null), classpath, baseLocation, pluginChain);
        }
        if ((requires = target.getRequires()) != null) {
            pluginChain.add(target);
            int i = 0;
            while (i < requires.length) {
                PluginModel plugin = this.getPlugin(requires[i].getPlugin(), requires[i].getVersion());
                if (plugin != null) {
                    this.addPluginAndPrerequisites(plugin, classpath, baseLocation, pluginChain);
                }
                ++i;
            }
            pluginChain.remove(target);
        }
    }

    private void addPluginAndPrerequisites(PluginModel target, List classpath, String baseLocation, List pluginChain) throws CoreException {
        this.addPlugin(target, classpath, baseLocation);
        this.addPrerequisites(target, classpath, baseLocation, pluginChain);
    }

    private void addDevEntries(PluginModel model, String baseLocation, List classpath, String[] jarSpecificEntries) throws CoreException {
        if (this.generator.devEntries != null && this.generator.devEntries.length == 0) {
            return;
        }
        if (this.generator.devEntries == null && (jarSpecificEntries == null || jarSpecificEntries.length == 0)) {
            return;
        }
        String[] entries = jarSpecificEntries != null && jarSpecificEntries.length > 0 ? jarSpecificEntries : this.generator.devEntries;
        IPath root = Utils.makeRelative((IPath)new Path(this.generator.getLocation(model)), (IPath)new Path(baseLocation));
        int i = 0;
        while (i < entries.length) {
            String path = root.append(entries[i]).toString();
            this.addPathAndCheck(model.getId(), path, classpath);
            ++i;
        }
    }
}

