/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.core.runtime.model.PluginPrerequisiteModel;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IPluginEntry;

public final class Utils
implements IPDEBuildConstants {
    public static String[] getArrayFromString(String list, String separator) {
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getArrayFromStringWithBlank(String list, String separator) {
        if (list == null || list.trim().length() == 0) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        boolean previousWasSeparator = true;
        StringTokenizer tokens = new StringTokenizer(list, separator, true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals(separator)) {
                if (previousWasSeparator) {
                    result.add("");
                }
                previousWasSeparator = true;
                continue;
            }
            result.add(token);
            previousWasSeparator = false;
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getArrayFromString(String list) {
        return Utils.getArrayFromString(list, ",");
    }

    public static boolean contains(IStatus status, int severity) {
        if (status.matches(severity)) {
            return true;
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                if (Utils.contains(children[i], severity)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static URL[] asURL(String[] target) throws CoreException {
        if (target == null) {
            return null;
        }
        try {
            URL[] result = new URL[target.length];
            int i = 0;
            while (i < target.length) {
                result[i] = new URL(target[i]);
                ++i;
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 3, e.getMessage(), (Throwable)e));
        }
    }

    public static String getStringFromCollection(Collection collection, String separator) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(i.next());
        }
        return result.toString();
    }

    public static String getStringFromArray(String[] values, String separator) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(values[i]);
            ++i;
        }
        return result.toString();
    }

    public static String[] computePrerequisiteOrder(PluginModel[] plugins, PluginModel[] fragments, boolean buildingOSGi) {
        ArrayList<String[]> prereqs = new ArrayList<String[]>(9);
        ArrayList<String> pluginList = new ArrayList<String>(plugins.length + (fragments == null ? 0 : fragments.length));
        int i = 0;
        while (i < plugins.length) {
            pluginList.add(plugins[i].getId());
            ++i;
        }
        if (fragments != null) {
            i = 0;
            while (i < fragments.length) {
                pluginList.add(fragments[i].getId());
                ++i;
            }
        }
        i = 0;
        while (i < plugins.length) {
            boolean boot = false;
            boolean runtime = false;
            boolean found = false;
            PluginPrerequisiteModel[] prereqList = plugins[i].getRequires();
            if (prereqList != null) {
                int j = 0;
                while (j < prereqList.length) {
                    String prereq = prereqList[j].getPlugin();
                    boot = boot || prereq.equals("org.eclipse.core.boot");
                    boolean bl = runtime = runtime || prereq.equals("org.eclipse.core.runtime");
                    if (pluginList.indexOf(prereq) != -1) {
                        found = true;
                        prereqs.add(new String[]{plugins[i].getId(), prereq});
                    }
                    ++j;
                }
            }
            if (!found) {
                String[] stringArray = new String[2];
                stringArray[0] = plugins[i].getId();
                prereqs.add(stringArray);
            }
            if (!(plugins[i].getId().equals("org.apache.xerces") || buildingOSGi && (plugins[i].getId().startsWith("org.eclipse.osgi") || plugins[i].getId().equals("org.eclipse.core.runtime") || plugins[i].getId().equals("org.eclipse.core.runtime.osgi") || plugins[i].getId().equals("org.eclipse.core.runtime.compatibility") || plugins[i].getId().equals("org.eclipse.update.configurator")) || buildingOSGi && (!buildingOSGi || new File(plugins[i].getLocation(), "META-INF/MANIFEST.MF").exists()))) {
                if (!boot && pluginList.contains("org.eclipse.core.boot") && !plugins[i].getId().equals("org.eclipse.core.boot")) {
                    prereqs.add(new String[]{plugins[i].getId(), "org.eclipse.core.boot"});
                }
                if (!(runtime || !pluginList.contains("org.eclipse.core.runtime") || plugins[i].getId().equals("org.eclipse.core.runtime") || plugins[i].getId().equals("org.eclipse.core.boot") || plugins[i].getId().equals("org.eclipse.core.runtime.compatibility"))) {
                    prereqs.add(new String[]{plugins[i].getId(), "org.eclipse.core.runtime.compatibility"});
                }
            }
            ++i;
        }
        if (fragments != null) {
            i = 0;
            while (i < fragments.length) {
                PluginFragmentModel fragment;
                boolean found = false;
                PluginPrerequisiteModel[] prereqList = fragments[i].getRequires();
                if (prereqList != null) {
                    int j = 0;
                    while (j < prereqList.length) {
                        String prereq = prereqList[j].getPlugin();
                        if (pluginList.contains(prereq)) {
                            found = true;
                            prereqs.add(new String[]{fragments[i].getId(), prereq});
                        }
                        ++j;
                    }
                }
                if (pluginList.contains((fragment = (PluginFragmentModel)fragments[i]).getPlugin())) {
                    found = true;
                    prereqs.add(new String[]{fragments[i].getId(), fragment.getPlugin()});
                }
                if (!found) {
                    String[] stringArray = new String[2];
                    stringArray[0] = fragments[i].getId();
                    prereqs.add(stringArray);
                }
                ++i;
            }
        }
        String[][] prereqArray = (String[][])prereqs.toArray((T[])new String[prereqs.size()][]);
        return Utils.computeNodeOrder(prereqArray);
    }

    protected static String[] computeNodeOrder(String[][] specs) {
        Map counts = Utils.computeCounts(specs);
        ArrayList nodes = new ArrayList(counts.size());
        while (!counts.isEmpty()) {
            List roots = Utils.findRootNodes(counts);
            if (roots.isEmpty()) break;
            Iterator i = roots.iterator();
            while (i.hasNext()) {
                counts.remove(i.next());
            }
            nodes.addAll(roots);
            Utils.removeArcs(specs, roots, counts);
        }
        String[] result = new String[nodes.size()];
        nodes.toArray(result);
        return result;
    }

    protected static List findRootNodes(Map counts) {
        ArrayList<String> result = new ArrayList<String>(5);
        Iterator i = counts.keySet().iterator();
        while (i.hasNext()) {
            String node = (String)i.next();
            int count = (Integer)counts.get(node);
            if (count != 0) continue;
            result.add(node);
        }
        return result;
    }

    protected static void removeArcs(String[][] mappings, List roots, Map counts) {
        Iterator j = roots.iterator();
        while (j.hasNext()) {
            String root = (String)j.next();
            int i = 0;
            while (i < mappings.length) {
                String input;
                Integer count;
                if (root.equals(mappings[i][1]) && (count = (Integer)counts.get(input = mappings[i][0])) != null) {
                    counts.put(input, new Integer(count - 1));
                }
                ++i;
            }
        }
    }

    protected static Map computeCounts(String[][] mappings) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>(5);
        int i = 0;
        while (i < mappings.length) {
            String from = mappings[i][0];
            Integer fromCount = (Integer)counts.get(from);
            String to = mappings[i][1];
            if (to == null) {
                counts.put(from, new Integer(0));
            } else {
                if ((Integer)counts.get(to) == null) {
                    counts.put(to, new Integer(0));
                }
                fromCount = fromCount == null ? new Integer(1) : new Integer(fromCount + 1);
                counts.put(from, fromCount);
            }
            ++i;
        }
        return counts;
    }

    public static ArrayList getArrayList(Object[] args) {
        ArrayList<Object> result = new ArrayList<Object>(args.length);
        int i = 0;
        while (i < args.length) {
            result.add(args[i]);
            ++i;
        }
        return result;
    }

    public static IPath makeRelative(IPath location, IPath base) {
        if (location.getDevice() != null && !location.getDevice().equalsIgnoreCase(base.getDevice())) {
            return location;
        }
        int baseCount = base.segmentCount();
        int count = base.matchingFirstSegments(location);
        String temp = "";
        int j = 0;
        while (j < baseCount - count) {
            temp = String.valueOf(temp) + "../";
            ++j;
        }
        return new Path(temp).append(location.removeFirstSegments(count));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void transferStreams(InputStream source, OutputStream destination) throws IOException {
        source = new BufferedInputStream(source);
        destination = new BufferedOutputStream(destination);
        try {
            byte[] buffer = new byte[8192];
            while (true) {
                int bytesRead = -1;
                bytesRead = source.read(buffer);
                if (bytesRead != -1) {
                    destination.write(buffer, 0, bytesRead);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                source.close();
            }
            catch (IOException iOException) {}
            try {
                destination.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {}
        source.close();
        try {}
        catch (IOException iOException) {
            return;
        }
        destination.close();
    }

    public static IPluginEntry[] getPluginEntry(IFeature feature, String pluginId) {
        IPluginEntry[] plugins = feature.getRawPluginEntries();
        ArrayList<IPluginEntry> foundEntries = new ArrayList<IPluginEntry>(5);
        int i = 0;
        while (i < plugins.length) {
            if (plugins[i].getVersionedIdentifier().getIdentifier().equals(pluginId)) {
                foundEntries.add(plugins[i]);
            }
            ++i;
        }
        return foundEntries.toArray(new IPluginEntry[foundEntries.size()]);
    }

    public static Collection findFiles(String from, String foldername, final String filename) {
        File root = new File(from);
        if (root.isFile() && root.getName().equals(filename)) {
            ArrayList<File> coll = new ArrayList<File>(1);
            coll.add(root);
            return coll;
        }
        String featureDirectory = String.valueOf(from) + "/" + foldername;
        ArrayList<File> collectedElements = new ArrayList<File>(10);
        File[] featureDirectoryContent = new File(featureDirectory).listFiles();
        if (featureDirectoryContent == null) {
            return null;
        }
        int i = 0;
        while (i < featureDirectoryContent.length) {
            File[] featureFiles;
            if (featureDirectoryContent[i].isDirectory() && (featureFiles = featureDirectoryContent[i].listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.equals(filename);
                }
            })).length != 0) {
                collectedElements.add(featureFiles[0]);
            }
            ++i;
        }
        return collectedElements;
    }

    public static boolean isIn(IPluginEntry[] array, IPluginEntry element) {
        int i = 0;
        while (i < array.length) {
            if (array[i].getVersionedIdentifier().equals((Object)element.getVersionedIdentifier())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Collection copyFiles(String fromDir, String toDir) throws CoreException {
        File[] files;
        File templateLocation = new File(fromDir);
        ArrayList<String> copiedFiles = new ArrayList<String>();
        if (templateLocation.exists() && (files = templateLocation.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                if (!files[i].isDirectory()) {
                    FileInputStream inputStream = null;
                    FileOutputStream outputStream = null;
                    try {
                        inputStream = new FileInputStream(files[i]);
                    }
                    catch (FileNotFoundException e) {
                        String message = Policy.bind("exception.missingFile", files[i].getAbsolutePath());
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
                    }
                    String fileToCopy = String.valueOf(toDir) + "/" + files[i].getName();
                    try {
                        outputStream = new FileOutputStream(fileToCopy);
                    }
                    catch (FileNotFoundException e) {
                        String message = Policy.bind("exception.missingFile", fileToCopy);
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
                    }
                    try {
                        Utils.transferStreams(inputStream, outputStream);
                        copiedFiles.add(files[i].getName());
                    }
                    catch (IOException e) {
                        String message = Policy.bind("exception.writingFile", fileToCopy);
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
                    }
                }
                ++i;
            }
        }
        return copiedFiles;
    }
}

