/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.AntScript;
import org.eclipse.update.core.Feature;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.internal.core.FeatureExecutableFactory;

public class FetchScriptGenerator
extends AbstractScriptGenerator {
    protected boolean recursiveGeneration = true;
    protected String directoryLocation;
    protected static Properties directory;
    protected String cvsPassFileLocation;
    protected boolean fetchChildren = true;
    protected String fetchTag = "";
    protected String element;
    protected IFeature feature;
    protected Map mapInfos;
    protected Properties featureProperties;
    protected List mkdirLocations = new ArrayList(5);
    public static final String FEATURE_ONLY = "featureOnly";
    public static final String FEATURE_AND_PLUGINS = "featureAndPlugins";
    public static final String FEATURES_RECURSIVELY = "featuresRecursively";
    public static final String FETCH_FILE_PREFIX = "fetch_";
    private String scriptName;

    public FetchScriptGenerator() {
    }

    public FetchScriptGenerator(String element) throws CoreException {
        this.setElement(element);
    }

    public void setElement(String element) throws CoreException {
        this.element = element;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws CoreException {
        this.mapInfos = this.processMapFileEntry(this.element);
        if (this.mapInfos == null) {
            return;
        }
        this.scriptName = FETCH_FILE_PREFIX + this.mapInfos.get("element") + ".xml";
        this.openScript(AbstractScriptGenerator.workingDirectory, this.scriptName);
        try {
            this.generateFetchScript();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.closeScript();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.closeScript();
        if (this.recursiveGeneration && this.mapInfos.get("type").equals("feature")) {
            this.generateFetchFilesForIncludedFeatures();
        }
    }

    private void generateFetchFilesForIncludedFeatures() throws CoreException {
        IIncludedFeatureReference[] referencedFeatures = ((Feature)this.feature).getFeatureIncluded();
        int i = 0;
        while (i < referencedFeatures.length) {
            String featureId = referencedFeatures[i].getVersionedIdentifier().getIdentifier();
            if (!this.featureProperties.containsKey("generate.feature@" + featureId)) {
                FetchScriptGenerator generator = new FetchScriptGenerator("feature@" + featureId);
                generator.setDirectoryLocation(this.directoryLocation);
                generator.setFetchChildren(this.fetchChildren);
                generator.setCvsPassFileLocation(this.cvsPassFileLocation);
                generator.setRecursiveGeneration(this.recursiveGeneration);
                generator.setFetchTag(this.fetchTag);
                generator.generate();
            }
            ++i;
        }
    }

    protected void generateFetchScript() throws CoreException {
        this.generatePrologue();
        this.generateFetchTarget();
        this.generateFetchElementTarget();
        if (this.mapInfos.get("type").equals("feature")) {
            this.generateFetchPluginsTarget();
            this.generateFetchRecusivelyTarget();
        }
        this.generateGetFromCVSTarget();
        this.generateEpilogue();
    }

    protected void generateFetchTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("fetch", null, null, null, null);
        this.script.printAntCallTask("fetch.element", null, null);
        if (this.mapInfos.get("type").equals("feature")) {
            this.script.printAntCallTask("fetch.plugins", null, null);
            this.script.printAntCallTask("fetch.recursively", null, null);
        }
        this.script.printTargetEnd();
    }

    protected void generateFetchElementTarget() {
        this.script.printTargetDeclaration("fetch.element", null, FEATURE_ONLY, null, null);
        try {
            this.generateFetchEntry(this.element, false);
        }
        catch (CoreException coreException) {}
        this.script.printTargetEnd();
    }

    protected void generateFetchPluginsTarget() throws CoreException {
        this.script.printTargetDeclaration("fetch.plugins", null, FEATURE_AND_PLUGINS, null, null);
        this.retrieveFeature((String)this.mapInfos.get("element"), (String)this.mapInfos.get("cvsRoot"), (String)this.mapInfos.get("tag"), (String)this.mapInfos.get("password"), (String)this.mapInfos.get("path"));
        this.generateChildrenFetchScript();
        this.script.printTargetEnd();
    }

    private Map processMapFileEntry(String entry) throws CoreException {
        HashMap<String, String> entryInfos = new HashMap<String, String>(5);
        String cvsInfo = this.getCVSInfo(entry);
        if (cvsInfo == null) {
            String message = Policy.bind("error.missingDirectoryEntry", entry);
            Platform.getPlugin((String)"org.eclipse.pde.build").getLog().log((IStatus)new Status(4, "org.eclipse.pde.build", 9, message, null));
            return null;
        }
        String[] cvsFields = Utils.getArrayFromStringWithBlank(cvsInfo, ",");
        if (cvsFields.length < 2) {
            String message = Policy.bind("error.incorrectDirectoryEntry", this.element);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 9, message, null));
        }
        entryInfos.put("tag", this.fetchTag.length() == 0 ? cvsFields[0] : this.fetchTag);
        entryInfos.put("cvsRoot", cvsFields[1]);
        entryInfos.put("password", cvsFields.length > 2 && !cvsFields[2].equals("") ? cvsFields[2] : null);
        entryInfos.put("path", cvsFields.length > 3 && !cvsFields[3].equals("") ? cvsFields[3] : null);
        int index = entry.indexOf(64);
        entryInfos.put("type", entry.substring(0, index));
        entryInfos.put("element", entry.substring(index + 1));
        return entryInfos;
    }

    protected void generateFetchRecusivelyTarget() throws CoreException {
        this.script.printTargetDeclaration("fetch.recursively", null, FEATURES_RECURSIVELY, null, null);
        IIncludedFeatureReference[] compiledFeatures = ((Feature)this.feature).getFeatureIncluded();
        int i = 0;
        while (i < compiledFeatures.length) {
            String featureId = compiledFeatures[i].getVersionedIdentifier().getIdentifier();
            if (this.featureProperties.containsKey("generate.feature@" + featureId)) {
                String[] extraElementsToFetch = Utils.getArrayFromString(this.featureProperties.getProperty("generate.feature@" + featureId), ",");
                int j = 1;
                while (j < extraElementsToFetch.length) {
                    this.generateFetchEntry(extraElementsToFetch[j], false);
                    ++j;
                }
            } else {
                this.script.printAntTask("${buildDirectory}/fetch_" + featureId + ".xml", null, "fetch", null, null, null);
            }
            ++i;
        }
        this.script.printTargetEnd();
    }

    protected void generateFetchEntry(String entry, boolean xmlFileOnly) throws CoreException {
        Map mapFileEntry = this.mapInfos;
        if (!entry.equals(this.element) && (mapFileEntry = this.processMapFileEntry(entry)) == null) {
            return;
        }
        String password = (String)mapFileEntry.get("password");
        if (password != null) {
            this.script.printCVSPassTask((String)mapFileEntry.get("cvsRoot"), password, this.cvsPassFileLocation);
        }
        String type = (String)mapFileEntry.get("type");
        String location = this.getElementLocation(type);
        HashMap params = new HashMap(5);
        params.put("destination", mapFileEntry.get("element"));
        params.put("tag", mapFileEntry.get("tag"));
        params.put("cvsRoot", mapFileEntry.get("cvsRoot"));
        params.put("quiet", "${quiet}");
        String cvsPackage = (String)mapFileEntry.get("path") == null ? (String)mapFileEntry.get("element") : (String)mapFileEntry.get("path");
        String fullLocation = null;
        if (type.equals("feature")) {
            fullLocation = String.valueOf(location) + "/" + (String)mapFileEntry.get("element") + "/" + "feature.xml";
            params.put("fileToCheck", fullLocation);
            cvsPackage = String.valueOf(cvsPackage) + (xmlFileOnly ? "/feature.xml" : "");
        } else if (type.equals("plugin")) {
            fullLocation = String.valueOf(location) + "/" + (String)mapFileEntry.get("element") + "/" + "plugin.xml";
            params.put("fileToCheck", fullLocation);
            cvsPackage = String.valueOf(cvsPackage) + (xmlFileOnly ? "/plugin.xml" : "");
        } else if (type.equals("fragment")) {
            fullLocation = String.valueOf(location) + "/" + (String)mapFileEntry.get("element") + "/" + "fragment.xml";
            params.put("fileToCheck", fullLocation);
            cvsPackage = String.valueOf(cvsPackage) + (xmlFileOnly ? "/fragment.xml" : "");
        }
        params.put("package", cvsPackage);
        this.script.printAvailableTask(fullLocation, fullLocation);
        this.script.printAntTask("../" + this.scriptName, "${buildDirectory}/" + (type.equals("feature") ? "features" : "plugins"), "getFromCVS", null, null, params);
    }

    protected void generateGetFromCVSTarget() {
        this.script.printTargetDeclaration("getFromCVS", null, null, "${fileToCheck}", null);
        this.script.printCVSTask("export -d ${destination} -r ${tag} ${package}", "${cvsRoot}", null, null, null, "${quiet}", null);
        this.script.printTargetEnd();
    }

    protected void generateMkdirs(String location) {
        if (this.mkdirLocations.contains(location)) {
            return;
        }
        this.mkdirLocations.add(location);
        this.script.printMkdirTask(location);
    }

    protected void generateChildrenFetchScript() throws CoreException {
        IPluginEntry[] allChildren = this.feature.getRawPluginEntries();
        IPluginEntry[] compiledChildren = this.feature.getPluginEntries();
        int i = 0;
        while (i < allChildren.length) {
            String elementId = allChildren[i].getVersionedIdentifier().getIdentifier();
            if (this.featureProperties.containsKey("generate.plugin@" + elementId)) {
                String[] extraElementsToFetch = Utils.getArrayFromString(this.featureProperties.getProperty("generate.plugin@" + elementId), ",");
                int j = 1;
                while (j < extraElementsToFetch.length) {
                    this.generateFetchEntry(extraElementsToFetch[j], false);
                    ++j;
                }
            } else if (allChildren[i].isFragment()) {
                this.generateFetchEntry("fragment@" + elementId, !Utils.isIn(compiledChildren, allChildren[i]));
            } else {
                this.generateFetchEntry("plugin@" + elementId, !Utils.isIn(compiledChildren, allChildren[i]));
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void retrieveFeature(String elementName, String cvsRoot, String tag, String password, String path) throws CoreException {
        File root = new File(AbstractScriptGenerator.workingDirectory);
        File target = new File(root, "retrieve.xml");
        try {
            AntScript retrieve = new AntScript(new FileOutputStream(target));
            try {
                IPath moduleFeatureProperties;
                IPath moduleFeatureFile;
                retrieve.printProjectDeclaration("RetrieveFeature", "main", ".");
                retrieve.printTargetDeclaration("main", null, null, null, null);
                if (path != null) {
                    moduleFeatureFile = new Path(path).append("feature.xml");
                    moduleFeatureProperties = new Path(path).append("build.properties");
                } else {
                    moduleFeatureFile = new Path(elementName).append("feature.xml");
                    moduleFeatureProperties = new Path(path).append("build.properties");
                }
                if (password != null) {
                    retrieve.printCVSPassTask(cvsRoot, password, this.cvsPassFileLocation);
                }
                retrieve.printCVSTask("export -r " + tag + " " + moduleFeatureFile.toString(), cvsRoot, null, null, null, "true", null);
                retrieve.printCVSTask("export -r " + tag + " " + moduleFeatureProperties.toString(), cvsRoot, null, null, null, "true", null);
                retrieve.printTargetEnd();
                retrieve.printProjectEnd();
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                retrieve.close();
                throw throwable;
            }
            {
                Object var11_17 = null;
                retrieve.close();
            }
        }
        catch (IOException e) {
            String message = Policy.bind("exception.writeScript");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 7, message, (Throwable)e));
        }
        try {
            AntRunner runner = new AntRunner();
            runner.setBuildFileLocation(target.getAbsolutePath());
            runner.run();
            FeatureExecutableFactory factory = new FeatureExecutableFactory();
            File featureFolder = new File(root, path == null ? elementName : path);
            this.feature = (Feature)factory.createFeature(featureFolder.toURL(), null, null);
            target.delete();
            this.featureProperties = new Properties();
            FileInputStream featureStream = new FileInputStream(root + "/" + (path == null ? elementName : path) + "/" + "build.properties");
            this.featureProperties.load(featureStream);
            ((InputStream)featureStream).close();
            FetchScriptGenerator.clear(featureFolder);
            if (this.feature != null) return;
            String message = Policy.bind("exception.missingFeature", elementName);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, message, null));
        }
        catch (Exception e) {
            String message = Policy.bind("error.fetchingFeature", elementName);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, message, (Throwable)e));
        }
    }

    public static boolean clear(File root) {
        String[] list;
        boolean result = true;
        if (root.isDirectory() && (list = root.list()) != null) {
            int i = 0;
            while (i < list.length) {
                result &= FetchScriptGenerator.clear(new File(root, list[i]));
                ++i;
            }
        }
        try {
            if (root.exists()) {
                result &= root.delete();
            }
        }
        catch (Exception exception) {
            result = false;
        }
        return result;
    }

    protected String getElementLocation(String type) {
        Path location = new Path(this.getPropertyFormat("buildDirectory"));
        location = type.equals("feature") ? location.append("features") : location.append("plugins");
        return location.toString();
    }

    protected String getCVSInfo(String elementName) throws CoreException {
        if (directory == null) {
            directory = this.readProperties(this.directoryLocation, "");
        }
        return directory.getProperty(elementName);
    }

    protected void generatePrologue() {
        this.script.println();
        this.script.printComment("Fetch script for " + this.element);
        this.script.println();
        this.script.printProjectDeclaration("FetchScript", "fetch", null);
        this.script.printProperty("quiet", "true");
    }

    protected void generateEpilogue() {
        this.script.println();
        this.script.printProjectEnd();
    }

    public void setDirectoryLocation(String directoryLocation) {
        this.directoryLocation = directoryLocation;
    }

    public void setFetchChildren(boolean fetchChildren) {
        this.fetchChildren = fetchChildren;
    }

    public void setFetchTag(String value) {
        this.fetchTag = value;
    }

    public void setCvsPassFileLocation(String cvsPassFileLocation) {
        this.cvsPassFileLocation = cvsPassFileLocation;
    }

    public void setRecursiveGeneration(boolean recursiveGeneration) {
        this.recursiveGeneration = recursiveGeneration;
    }
}

