/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.AssembleScriptGenerator;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.SourceFeatureInformation;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.pde.internal.build.builder.FragmentBuildScriptGenerator;
import org.eclipse.pde.internal.build.builder.ModelBuildScriptGenerator;
import org.eclipse.pde.internal.build.builder.PluginBuildScriptGenerator;

public class BuildScriptGenerator
extends AbstractScriptGenerator {
    protected boolean children = true;
    protected String[] elements;
    protected String[] devEntries = new String[0];
    protected String[] pluginPath;
    protected boolean recursiveGeneration = true;

    public void generate() throws CoreException {
        ArrayList plugins = new ArrayList(5);
        ArrayList fragments = new ArrayList(5);
        ArrayList features = new ArrayList(5);
        this.sortElements(features, plugins, fragments);
        this.generateModels(new PluginBuildScriptGenerator(), plugins);
        this.generateModels(new FragmentBuildScriptGenerator(), fragments);
        this.generateFeatures(features);
    }

    protected void sortElements(List features, List plugins, List fragments) {
        int i = 0;
        while (i < this.elements.length) {
            int index = this.elements[i].indexOf(64);
            String type = this.elements[i].substring(0, index);
            String element = this.elements[i].substring(index + 1);
            if (type.equals("plugin")) {
                plugins.add(element);
            } else if (type.equals("fragment")) {
                fragments.add(element);
            } else if (type.equals("feature")) {
                features.add(element);
            }
            ++i;
        }
    }

    protected void generateModels(ModelBuildScriptGenerator generator, List models) throws CoreException {
        Iterator iterator = models.iterator();
        while (iterator.hasNext()) {
            String model = (String)iterator.next();
            generator.setModelId(model);
            generator.generate();
        }
    }

    protected void generateFeatures(List features) throws CoreException {
        Iterator i = features.iterator();
        while (i.hasNext()) {
            AssemblyInformation assemblageInformation = null;
            assemblageInformation = new AssemblyInformation();
            String featureId = (String)i.next();
            FeatureBuildScriptGenerator generator = new FeatureBuildScriptGenerator(featureId, assemblageInformation);
            generator.setGenerateIncludedFeatures(this.recursiveGeneration);
            generator.setAnalyseChildren(this.children);
            generator.setSourceFeatureGeneration(false);
            generator.setBinaryFeatureGeneration(true);
            generator.setScriptGeneration(true);
            generator.getSite(true);
            generator.setPluginPath(Utils.asURL(this.pluginPath));
            generator.setBuildSiteFactory(null);
            generator.setDevEntries(this.devEntries);
            generator.setSourceToGather(new SourceFeatureInformation());
            generator.setCompiledElements(generator.getCompiledElements());
            generator.setBuildingOSGi(AbstractScriptGenerator.isBuildingOSGi());
            generator.generate();
            AssembleScriptGenerator assembler = new AssembleScriptGenerator(AbstractScriptGenerator.workingDirectory, assemblageInformation, featureId, null);
            assembler.generate();
        }
    }

    public void setChildren(boolean children) {
        this.children = children;
    }

    public void setDevEntries(String[] devEntries) {
        this.devEntries = devEntries;
    }

    public void setElements(String[] elements) {
        this.elements = elements;
    }

    public void setPluginPath(String[] pluginPath) {
        this.pluginPath = pluginPath;
    }

    public void setRecursiveGeneration(boolean recursiveGeneration) {
        this.recursiveGeneration = recursiveGeneration;
    }
}

