/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.site.BuildTimeFeature;
import org.eclipse.update.core.IFeature;

public class AssemblyInformation {
    private Map assembleInformation = new HashMap(8);

    public AssemblyInformation() {
        Iterator iter = AbstractScriptGenerator.getConfigInfos().iterator();
        while (iter.hasNext()) {
            this.assembleInformation.put(iter.next(), new AssemblyLevelConfigInfo());
        }
    }

    public void addFeature(Config config, IFeature feature) {
        AssemblyLevelConfigInfo entry = (AssemblyLevelConfigInfo)this.assembleInformation.get(config);
        entry.addFeature(feature);
    }

    public void addPlugin(Config config, PluginModel plugin) {
        AssemblyLevelConfigInfo entry = (AssemblyLevelConfigInfo)this.assembleInformation.get(config);
        entry.addPlugin(plugin);
    }

    public Collection getPlugins(Config config) {
        return ((AssemblyLevelConfigInfo)this.assembleInformation.get(config)).getPlugins();
    }

    public void addFragment(Config config, PluginModel fragment) {
        AssemblyLevelConfigInfo entry = (AssemblyLevelConfigInfo)this.assembleInformation.get(config);
        entry.addFragment(fragment);
    }

    public Collection getFragments(Config config) {
        return ((AssemblyLevelConfigInfo)this.assembleInformation.get(config)).getFragments();
    }

    public Collection getFeatures(Config config) {
        return ((AssemblyLevelConfigInfo)this.assembleInformation.get(config)).getFeatures();
    }

    public boolean copyRootFile(Config config) {
        return ((AssemblyLevelConfigInfo)this.assembleInformation.get(config)).hasRootFile();
    }

    public void setCopyRootFile(Config config) {
        ((AssemblyLevelConfigInfo)this.assembleInformation.get(config)).setHasRootFile(true);
    }

    private class AssemblyLevelConfigInfo {
        private Collection plugins = new HashSet(20);
        private Collection fragments = new HashSet(10);
        private Collection features = new HashSet(7);
        private boolean hasRootFile = false;

        AssemblyLevelConfigInfo() {
        }

        public void setHasRootFile(boolean rootFile) {
            this.hasRootFile = rootFile;
        }

        public boolean hasRootFile() {
            return this.hasRootFile;
        }

        public Collection getFeatures() {
            return this.features;
        }

        public Collection getPlugins() {
            return this.plugins;
        }

        public Collection getFragments() {
            return this.fragments;
        }

        public void addFeature(IFeature feature) {
            Iterator iter = this.features.iterator();
            while (iter.hasNext()) {
                BuildTimeFeature featureDescriptor = (BuildTimeFeature)((Object)iter.next());
                if (!((BuildTimeFeature)feature).getFeatureIdentifier().equals(featureDescriptor.getFeatureIdentifier()) || !((BuildTimeFeature)feature).getFeatureVersion().equals(featureDescriptor.getFeatureVersion())) continue;
                return;
            }
            this.features.add(feature);
        }

        public void addPlugin(PluginModel plugin) {
            Iterator iter = this.plugins.iterator();
            while (iter.hasNext()) {
                PluginDescriptorModel descriptor = (PluginDescriptorModel)iter.next();
                if (!descriptor.getId().equals(plugin.getId()) || !descriptor.getVersion().equals(plugin.getVersion())) continue;
                return;
            }
            this.plugins.add(plugin);
        }

        public void addFragment(PluginModel fragment) {
            Iterator iter = this.fragments.iterator();
            while (iter.hasNext()) {
                PluginFragmentModel descriptor = (PluginFragmentModel)iter.next();
                if (!descriptor.getId().equals(fragment.getId()) || !descriptor.getVersion().equals(fragment.getVersion())) continue;
                return;
            }
            this.fragments.add(fragment);
        }
    }
}

