/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.AssembleConfigScriptGenerator;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.ant.AntScript;

public class AssembleScriptGenerator
extends AbstractScriptGenerator {
    private String directory;
    private AssemblyInformation assemblageInformation;
    private String featureId;
    private AssembleConfigScriptGenerator configScriptGenerator = new AssembleConfigScriptGenerator();

    public AssembleScriptGenerator(String directory, AssemblyInformation assemblageInformation, String featureId, String scriptFilename) throws CoreException {
        this.directory = directory;
        this.assemblageInformation = assemblageInformation;
        this.featureId = featureId;
        String filename = String.valueOf(directory) + "/" + (scriptFilename == null ? "assemble." + featureId + "." + "all.xml" : scriptFilename);
        try {
            this.script = new AntScript(new FileOutputStream(filename));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            String message = Policy.bind("exception.writingFile", filename);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws CoreException {
        try {
            this.script.printProjectDeclaration("Assemble All Config of " + this.featureId, "main", null);
            this.generateMainTarget();
            this.script.printProjectEnd();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.script.close();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.script.close();
            return;
        }
    }

    private void generateMainTarget() throws CoreException {
        this.script.printTargetDeclaration("main", null, null, null, null);
        Iterator iter = AbstractScriptGenerator.getConfigInfos().iterator();
        while (iter.hasNext()) {
            this.generateAssembleConfigFileTargetCall((Config)iter.next());
        }
        this.script.printTargetEnd();
    }

    protected void generateAssembleConfigFileTargetCall(Config aConfig) throws CoreException {
        this.configScriptGenerator.initialize(this.directory, null, this.featureId, aConfig, this.assemblageInformation.getPlugins(aConfig), this.assemblageInformation.getFragments(aConfig), this.assemblageInformation.getFeatures(aConfig), this.assemblageInformation.copyRootFile(aConfig));
        this.configScriptGenerator.generate();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("assembleScriptName", this.configScriptGenerator.getFilename());
        this.script.printAntTask(this.getPropertyFormat("customTargets"), null, this.configScriptGenerator.getTargetName(), null, null, params);
    }

    public void setConfigGenerator(AssembleConfigScriptGenerator generator) {
        this.configScriptGenerator = generator;
    }
}

