/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.AntScript;
import org.eclipse.update.core.IFeature;

public class AssembleConfigScriptGenerator
extends AbstractScriptGenerator {
    protected String directory;
    protected String featureId;
    protected Config configInfo;
    protected IFeature[] features;
    protected PluginModel[] plugins;
    protected PluginFragmentModel[] fragments;
    protected String filename;
    protected boolean copyRootFile;
    private String PROPERTY_TMP_DIR = "tmp_dir";

    public void initialize(String directoryName, String scriptName, String feature, Config configurationInformation, Collection pluginList, Collection fragmentList, Collection featureList, boolean rootFileCopy) throws CoreException {
        this.directory = directoryName;
        this.featureId = feature;
        this.configInfo = configurationInformation;
        this.copyRootFile = rootFileCopy;
        this.features = new IFeature[featureList.size()];
        featureList.toArray(this.features);
        this.plugins = new PluginModel[pluginList.size()];
        pluginList.toArray(this.plugins);
        this.fragments = new PluginFragmentModel[fragmentList.size()];
        fragmentList.toArray(this.fragments);
        this.filename = String.valueOf(this.directory) + "/" + (scriptName != null ? scriptName : this.getFilename());
        try {
            this.script = new AntScript(new FileOutputStream(this.filename));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            String message = Policy.bind("exception.writingFile", this.filename);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
    }

    public void generate() throws CoreException {
        this.generatePrologue();
        this.generateInitializationSteps();
        this.generateGatherBinPartsCalls();
        if (this.configInfo.getOs().equalsIgnoreCase("macosx")) {
            this.generateTarTarget();
            this.generateGZipTarget();
        } else {
            this.generateZipTarget();
        }
        this.generateEpilogue();
    }

    private void generateGZipTarget() {
        this.script.println("<move file=\"" + this.getPropertyFormat("archiveFullPath") + "\" tofile=\"" + this.getPropertyFormat(this.PROPERTY_TMP_DIR) + "/" + this.getPropertyFormat("collBase") + "/tmp.tar\"/>");
        this.script.printGZip(String.valueOf(this.getPropertyFormat(this.PROPERTY_TMP_DIR)) + "/" + this.getPropertyFormat("collBase") + "/tmp.tar", this.getPropertyFormat("archiveFullPath"));
        ArrayList<String> args = new ArrayList<String>(2);
        args.add("-rf");
        args.add(this.getPropertyFormat(this.PROPERTY_TMP_DIR));
        this.script.printExecTask("rm", null, args, null);
    }

    private void generatePrologue() {
        this.script.printProjectDeclaration("Assemble " + this.featureId, "main", null);
        this.script.printProperty("archiveName", this.computeArchiveName());
        this.script.printProperty("os", this.configInfo.getOs());
        this.script.printProperty("ws", this.configInfo.getWs());
        this.script.printProperty("arch", this.configInfo.getArch());
        this.script.printProperty(this.PROPERTY_TMP_DIR, String.valueOf(this.getPropertyFormat("buildDirectory")) + "/tmp");
        this.script.printProperty("feature.base", String.valueOf(this.getPropertyFormat(this.PROPERTY_TMP_DIR)) + "/" + this.getPropertyFormat("collPlace"));
        this.script.printProperty("destination.temp.folder", String.valueOf(this.getPropertyFormat("feature.base")) + "/" + "plugins");
        this.script.printProperty("archiveFullPath", String.valueOf(this.getPropertyFormat("basedir")) + "/" + this.getPropertyFormat("buildLabel") + "/" + this.getPropertyFormat("archiveName"));
        this.script.printTargetDeclaration("main", null, null, null, null);
    }

    private void generateInitializationSteps() {
        this.script.printDeleteTask(this.getPropertyFormat(this.PROPERTY_TMP_DIR), null, null);
        this.script.printMkdirTask(this.getPropertyFormat(this.PROPERTY_TMP_DIR));
        this.script.printMkdirTask(this.getPropertyFormat("buildLabel"));
    }

    private void generateGatherBinPartsCalls() throws CoreException {
        String placeToGather;
        int i = 0;
        while (i < this.plugins.length) {
            PluginModel plugin = this.plugins[i];
            placeToGather = this.getLocation(plugin);
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(AbstractScriptGenerator.workingDirectory)).toOSString(), "gather.bin.parts", null, null, null);
            ++i;
        }
        i = 0;
        while (i < this.fragments.length) {
            PluginFragmentModel fragment = this.fragments[i];
            placeToGather = this.getLocation((PluginModel)fragment);
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(AbstractScriptGenerator.workingDirectory)).toOSString(), "gather.bin.parts", null, null, null);
            ++i;
        }
        i = 0;
        while (i < this.features.length) {
            IFeature feature = this.features[i];
            placeToGather = feature.getURL().getPath();
            int j = placeToGather.lastIndexOf("feature.xml");
            if (j != -1) {
                placeToGather = placeToGather.substring(0, j);
            }
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(AbstractScriptGenerator.workingDirectory)).toOSString(), "gather.bin.parts", null, null, null);
            ++i;
        }
    }

    private void generateEpilogue() {
        this.script.printTargetEnd();
        this.script.printProjectEnd();
        this.script.close();
    }

    public String getFilename() {
        return String.valueOf(this.getTargetName()) + ".xml";
    }

    public String getTargetName() {
        return "assemble" + (this.featureId.equals("") ? "" : "." + this.featureId) + (this.configInfo.equals(Config.genericConfig()) ? "" : "." + this.configInfo.toStringReplacingAny(".", "ANY"));
    }

    private void generateZipTarget() {
        ArrayList<String> parameters = new ArrayList<String>(16);
        int i = 0;
        while (i < this.plugins.length) {
            parameters.add(String.valueOf(this.getPropertyFormat("collPlace")) + "/" + "plugins" + "/" + this.plugins[i].getPluginId() + "_" + this.plugins[i].getVersion());
            if (i % 15 == 0) {
                this.createZipExecCommand(parameters);
                parameters.clear();
            }
            ++i;
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        i = 0;
        while (i < this.fragments.length) {
            parameters.add(String.valueOf(this.getPropertyFormat("collPlace")) + "/" + "plugins" + "/" + this.fragments[i].getId() + "_" + this.fragments[i].getVersion());
            if (i % 15 == 0) {
                this.createZipExecCommand(parameters);
                parameters.clear();
            }
            ++i;
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        i = 0;
        while (i < this.features.length) {
            parameters.add(String.valueOf(this.getPropertyFormat("collPlace")) + "/" + "features" + "/" + this.features[i].getVersionedIdentifier().toString());
            if (i % 15 == 0) {
                this.createZipExecCommand(parameters);
                parameters.clear();
            }
            ++i;
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        this.createZipRootFileCommand();
    }

    private void createZipRootFileCommand() {
        if (!this.copyRootFile) {
            return;
        }
        ArrayList<String> parameters = new ArrayList<String>(1);
        parameters.add("-r -q ${zipargs} " + this.getPropertyFormat("archiveFullPath") + " . ");
        this.script.printExecTask("zip", String.valueOf(this.getPropertyFormat("feature.base")) + "/" + this.configInfo.toStringReplacingAny(".", "ANY") + "/" + this.getPropertyFormat("collBase"), parameters, null);
    }

    private void createZipExecCommand(List parameters) {
        parameters.add(0, "-r -q " + this.getPropertyFormat("zipargs") + " " + this.getPropertyFormat("archiveFullPath"));
        this.script.printExecTask("zip", String.valueOf(this.getPropertyFormat(this.PROPERTY_TMP_DIR)) + "/" + this.getPropertyFormat("collBase"), parameters, null);
    }

    protected String computeArchiveName() {
        return String.valueOf(this.featureId) + "-" + this.getPropertyFormat("buildId") + (this.configInfo.equals(Config.genericConfig()) ? "" : "-" + this.configInfo.toStringReplacingAny(".", "ANY")) + ".zip";
    }

    public void generateTarTarget() {
        ArrayList<String> parameters = new ArrayList<String>(2);
        parameters.add("-r " + this.getPropertyFormat(this.PROPERTY_TMP_DIR) + "/" + this.getPropertyFormat("collBase") + "/" + this.getPropertyFormat("collPlace") + "/" + this.configInfo.toStringReplacingAny(".", "ANY") + "/eclipse " + this.getPropertyFormat(this.PROPERTY_TMP_DIR) + "/" + this.getPropertyFormat("collBase"));
        this.script.printExecTask("cp", this.getPropertyFormat("basedir"), parameters, "Linux");
        parameters.clear();
        parameters.add("-rf " + this.getPropertyFormat(this.PROPERTY_TMP_DIR) + "/" + this.getPropertyFormat("collBase") + "/" + this.getPropertyFormat("collPlace") + "/" + this.configInfo.toStringReplacingAny(".", "ANY"));
        this.script.printExecTask("rm", this.getPropertyFormat("basedir"), parameters, "Linux");
        parameters.clear();
        parameters.add("-cvf " + this.getPropertyFormat("archiveFullPath") + " eclipse ");
        this.script.printExecTask("tar", String.valueOf(this.getPropertyFormat(this.PROPERTY_TMP_DIR)) + "/" + this.getPropertyFormat("collBase"), parameters, "Linux");
    }
}

