/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.IXMLConstants;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.AntScript;
import org.eclipse.update.core.SiteManager;

public abstract class AbstractScriptGenerator
implements IXMLConstants,
IPDEBuildConstants {
    private static List configInfos;
    protected static String workingDirectory;
    protected static boolean buildingOSGi;
    protected AntScript script;

    static {
        buildingOSGi = false;
        configInfos = new ArrayList(1);
        configInfos.add(Config.genericConfig());
    }

    public static List getConfigInfos() {
        return configInfos;
    }

    public abstract void generate() throws CoreException;

    public String getPropertyFormat(String propertyName) {
        StringBuffer sb = new StringBuffer();
        sb.append("${");
        sb.append(propertyName);
        sb.append("}");
        return sb.toString();
    }

    public static void setConfigInfo(String spec) throws CoreException {
        configInfos.clear();
        String[] configs = Utils.getArrayFromStringWithBlank(spec, "&");
        configInfos = new ArrayList(configs.length);
        String[] os = new String[configs.length];
        String[] ws = new String[configs.length];
        String[] archs = new String[configs.length];
        int i = 0;
        while (i < configs.length) {
            Config aConfig = new Config(configs[i]);
            if (aConfig.equals(Config.genericConfig())) {
                configInfos.add(Config.genericConfig());
            } else {
                configInfos.add(aConfig);
            }
            os[i] = aConfig.getOs();
            ws[i] = aConfig.getWs();
            archs[i] = aConfig.getArch();
            ++i;
        }
        SiteManager.setOS((String)Utils.getStringFromArray(os, ","));
        SiteManager.setWS((String)Utils.getStringFromArray(ws, ","));
        SiteManager.setOSArch((String)Utils.getStringFromArray(archs, ","));
    }

    public void setWorkingDirectory(String location) {
        workingDirectory = location;
    }

    public String getLocation(PluginModel model) throws CoreException {
        try {
            return new URL(model.getLocation()).getFile();
        }
        catch (MalformedURLException e) {
            String message = Policy.bind("exception.url");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 3, message, (Throwable)e));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Properties readProperties(String location, String fileName) throws CoreException {
        Properties result = new Properties();
        File file = new File(location, fileName);
        try {
            FileInputStream input = new FileInputStream(file);
            try {
                result.load(input);
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                ((InputStream)input).close();
                throw throwable;
            }
            {
                Object var6_9 = null;
                ((InputStream)input).close();
                return result;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return result;
        }
        catch (IOException e) {
            String message = Policy.bind("exception.readingFile", file.toString());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
        }
    }

    public void openScript(String scriptLocation, String scriptName) throws CoreException {
        if (this.script != null) {
            return;
        }
        try {
            BufferedOutputStream scriptStream = new BufferedOutputStream(new FileOutputStream(String.valueOf(scriptLocation) + "/" + scriptName));
            try {
                this.script = new AntScript(scriptStream);
            }
            catch (IOException e) {
                try {
                    ((OutputStream)scriptStream).close();
                    String message = Policy.bind("exception.writingFile", String.valueOf(scriptLocation) + "/" + scriptName);
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException e) {
            String message = Policy.bind("exception.writingFile", String.valueOf(scriptLocation) + "/" + scriptName);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
    }

    public void closeScript() {
        this.script.close();
    }

    public void setBuildingOSGi(boolean b) {
        buildingOSGi = b;
    }

    public static boolean isBuildingOSGi() {
        return buildingOSGi;
    }
}

