/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.internal.configurator.ConfigurationActivator;
import org.eclipse.update.internal.configurator.Messages;

public class Utils {
    private static final String PLUGIN_PATH = ".plugin-path";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URL[] getPluginPath(URL pluginPathLocation) {
        InputStream input = null;
        if (pluginPathLocation == null) {
            return null;
        }
        try {
            input = pluginPathLocation.openStream();
        }
        catch (IOException iOException) {}
        if (input == null) {
            try {
                URL url = new URL("platform:/base/.plugin-path");
                input = url.openStream();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        if (input == null) {
            return null;
        }
        URL[] result = null;
        try {
            try {
                result = Utils.readPluginPath(input);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                input.close();
                throw throwable;
            }
            {
                Object var3_5 = null;
                input.close();
                return result;
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    private static URL[] readPluginPath(InputStream input) {
        Properties ini = new Properties();
        try {
            ini.load(input);
        }
        catch (IOException iOException) {
            return null;
        }
        Vector<URL> result = new Vector<URL>(5);
        Enumeration<?> groups = ini.propertyNames();
        while (groups.hasMoreElements()) {
            String group = (String)groups.nextElement();
            StringTokenizer entries = new StringTokenizer(ini.getProperty(group), ";");
            while (entries.hasMoreElements()) {
                String entry = (String)entries.nextElement();
                if (entry.equals("")) continue;
                try {
                    result.addElement(new URL(entry));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println(Messages.getString("ignore.plugin", entry));
                }
            }
        }
        return result.toArray(new URL[result.size()]);
    }

    public static void debug(String s) {
        if (ConfigurationActivator.DEBUG) {
            System.out.println("PlatformConfig: " + s);
        }
    }

    public static CoreException newCoreException(String s, Throwable e) {
        MultiStatus status;
        if (e instanceof CoreException) {
            if (s == null) {
                s = "";
            }
            status = new MultiStatus("org.eclipse.update.configurator", 0, s, e);
            IStatus childrenStatus = ((CoreException)e).getStatus();
            status.add(childrenStatus);
            status.addAll(childrenStatus);
        } else {
            StringBuffer completeString = new StringBuffer("");
            if (s != null) {
                completeString.append(s);
            }
            if (e != null) {
                completeString.append(" [");
                String msg = e.getLocalizedMessage();
                completeString.append(msg != null ? msg : e.toString());
                completeString.append("]");
            }
            status = new Status(4, "org.eclipse.update.configurator", 0, completeString.toString(), e);
        }
        return new CoreException((IStatus)status);
    }
}

