/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.internal.configurator.ConfigurationActivator;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.Utils;

public class SiteEntry
implements IPlatformConfiguration.ISiteEntry {
    private static final String PLUGINS = "plugins";
    private static final String FEATURES = "features";
    private static final String PLUGIN_XML = "plugin.xml";
    private static final String FRAGMENT_XML = "fragment.xml";
    private static final String FEATURE_XML = "feature.xml";
    private URL url;
    private URL resolvedURL;
    private IPlatformConfiguration.ISitePolicy policy;
    private boolean updateable = true;
    private ArrayList featureEntries = new ArrayList();
    private ArrayList pluginEntries = new ArrayList();
    private ArrayList features;
    private ArrayList plugins;
    private PlatformConfiguration parent;
    private long changeStamp;
    private boolean changeStampIsValid;
    private long lastFeaturesChangeStamp;
    private long featuresChangeStamp;
    private boolean featuresChangeStampIsValid;
    private long lastPluginsChangeStamp;
    private long pluginsChangeStamp;
    private boolean pluginsChangeStampIsValid;
    private String linkFileName;

    public SiteEntry() {
    }

    public SiteEntry(URL url, IPlatformConfiguration.ISitePolicy policy, PlatformConfiguration parent) {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        if (policy == null) {
            throw new IllegalArgumentException();
        }
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this.url = url;
        this.policy = policy;
        this.parent = parent;
        this.features = null;
        this.plugins = null;
        this.resolvedURL = this.url;
        if (url.getProtocol().equals("platform")) {
            try {
                this.resolvedURL = PlatformConfiguration.resolvePlatformURL(url);
            }
            catch (IOException iOException) {}
        }
    }

    public URL getURL() {
        return this.url;
    }

    public IPlatformConfiguration.ISitePolicy getSitePolicy() {
        return this.policy;
    }

    public synchronized void setSitePolicy(IPlatformConfiguration.ISitePolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException();
        }
        this.policy = policy;
    }

    public String[] getFeatures() {
        return this.getDetectedFeatures();
    }

    public String[] getPlugins() {
        IPlatformConfiguration.ISitePolicy policy = this.getSitePolicy();
        if (policy.getType() == 0) {
            return policy.getList();
        }
        if (policy.getType() == 1) {
            ArrayList<String> detectedPlugins = new ArrayList<String>(Arrays.asList(this.getDetectedPlugins()));
            String[] excludedPlugins = policy.getList();
            int i = 0;
            while (i < excludedPlugins.length) {
                if (detectedPlugins.contains(excludedPlugins[i])) {
                    detectedPlugins.remove(excludedPlugins[i]);
                }
                ++i;
            }
            return detectedPlugins.toArray(new String[0]);
        }
        return new String[0];
    }

    public long getChangeStamp() {
        if (!this.changeStampIsValid) {
            this.computeChangeStamp();
        }
        return this.changeStamp;
    }

    public long getFeaturesChangeStamp() {
        if (!this.featuresChangeStampIsValid) {
            this.computeFeaturesChangeStamp();
        }
        return this.featuresChangeStamp;
    }

    public long getPluginsChangeStamp() {
        if (!this.pluginsChangeStampIsValid) {
            this.computePluginsChangeStamp();
        }
        return this.pluginsChangeStamp;
    }

    public boolean isUpdateable() {
        return this.updateable;
    }

    public void setUpdateable(boolean updateable) {
        this.updateable = updateable;
    }

    public boolean isNativelyLinked() {
        return this.isExternallyLinkedSite();
    }

    public URL getResolvedURL() {
        return this.resolvedURL;
    }

    private String[] detectFeatures() {
        this.invalidateFeaturesChangeStamp();
        this.features = new ArrayList();
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL)) {
            return new String[0];
        }
        File siteRoot = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        File root = new File(siteRoot, FEATURES);
        String[] list = root.list();
        int i = 0;
        while (list != null && i < list.length) {
            String path = String.valueOf(list[i]) + File.separator + FEATURE_XML;
            File plugin = new File(root, path);
            if (plugin.exists()) {
                this.features.add("features/" + path.replace(File.separatorChar, '/'));
            }
            ++i;
        }
        Utils.debug(String.valueOf(this.resolvedURL.toString()) + " located  " + this.features.size() + " feature(s)");
        return this.features.toArray(new String[0]);
    }

    private String[] detectPlugins() {
        this.invalidatePluginsChangeStamp();
        this.plugins = new ArrayList();
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL)) {
            return new String[0];
        }
        File root = new File(String.valueOf(this.resolvedURL.getFile().replace('/', File.separatorChar)) + PLUGINS);
        String[] list = root.list();
        int i = 0;
        while (list != null && i < list.length) {
            String path = String.valueOf(list[i]) + File.separator + PLUGIN_XML;
            File plugin = new File(root, path);
            if (plugin.exists() || (plugin = new File(root, path = String.valueOf(list[i]) + File.separator + FRAGMENT_XML)).exists()) {
                this.plugins.add("plugins/" + path.replace(File.separatorChar, '/'));
            }
            ++i;
        }
        Utils.debug(String.valueOf(this.resolvedURL.toString()) + " located  " + this.plugins.size() + " plugin(s)");
        return this.plugins.toArray(new String[0]);
    }

    private synchronized String[] getDetectedFeatures() {
        if (this.features == null) {
            return this.detectFeatures();
        }
        return this.features.toArray(new String[0]);
    }

    private synchronized String[] getDetectedPlugins() {
        if (this.plugins == null) {
            return this.detectPlugins();
        }
        return this.plugins.toArray(new String[0]);
    }

    private void computeChangeStamp() {
        this.computeFeaturesChangeStamp();
        this.computePluginsChangeStamp();
        this.changeStamp = (long)this.resolvedURL.hashCode() ^ this.featuresChangeStamp ^ this.pluginsChangeStamp;
        this.changeStampIsValid = true;
    }

    private synchronized void computeFeaturesChangeStamp() {
        if (this.featuresChangeStampIsValid) {
            return;
        }
        long start = 0L;
        if (ConfigurationActivator.DEBUG) {
            start = new Date().getTime();
        }
        String[] features = this.getFeatures();
        this.featuresChangeStamp = this.computeStamp(features);
        this.featuresChangeStampIsValid = true;
        if (ConfigurationActivator.DEBUG) {
            long end = new Date().getTime();
            Utils.debug(String.valueOf(this.resolvedURL.toString()) + " feature stamp: " + this.featuresChangeStamp + (this.featuresChangeStamp == this.lastFeaturesChangeStamp ? " [no changes]" : " [was " + this.lastFeaturesChangeStamp + "]") + " in " + (end - start) + "ms");
        }
    }

    private synchronized void computePluginsChangeStamp() {
        if (this.pluginsChangeStampIsValid) {
            return;
        }
        long start = 0L;
        if (ConfigurationActivator.DEBUG) {
            start = new Date().getTime();
        }
        String[] plugins = this.getPlugins();
        this.pluginsChangeStamp = this.computeStamp(plugins);
        this.pluginsChangeStampIsValid = true;
        if (ConfigurationActivator.DEBUG) {
            long end = new Date().getTime();
            Utils.debug(String.valueOf(this.resolvedURL.toString()) + " plugin stamp: " + this.pluginsChangeStamp + (this.pluginsChangeStamp == this.lastPluginsChangeStamp ? " [no changes]" : " [was " + this.lastPluginsChangeStamp + "]") + " in " + (end - start) + "ms");
        }
    }

    private long computeStamp(String[] targets) {
        long result = 0L;
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL)) {
            int i = 0;
            while (i < targets.length) {
                result ^= (long)targets[i].hashCode();
                ++i;
            }
            Utils.debug("*WARNING* computing stamp using URL hashcodes only");
        } else {
            File rootFile;
            String rootPath = this.resolvedURL.getFile().replace('/', File.separatorChar);
            if (!rootPath.endsWith(File.separator)) {
                rootPath = String.valueOf(rootPath) + File.separator;
            }
            if ((rootFile = new File(rootPath)).exists()) {
                File f = null;
                int i = 0;
                while (i < targets.length) {
                    f = new File(rootFile, targets[i]);
                    if (f.exists()) {
                        result ^= (long)f.getAbsolutePath().hashCode() ^ f.lastModified() ^ f.length();
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public void setLinkFileName(String linkFileName) {
        this.linkFileName = linkFileName;
    }

    public String getLinkFileName() {
        return this.linkFileName;
    }

    public boolean isExternallyLinkedSite() {
        return this.linkFileName != null && !this.linkFileName.trim().equals("");
    }

    public synchronized void refresh() {
        this.lastFeaturesChangeStamp = this.featuresChangeStamp;
        this.lastPluginsChangeStamp = this.pluginsChangeStamp;
        this.changeStampIsValid = false;
        this.featuresChangeStampIsValid = false;
        this.pluginsChangeStampIsValid = false;
        this.features = null;
        this.plugins = null;
    }

    public void setLastFeaturesChangeStamp(long stamp) {
        this.lastFeaturesChangeStamp = stamp;
    }

    public void setLastPluginsChangeStamp(long stamp) {
        this.lastPluginsChangeStamp = stamp;
    }

    public void invalidateFeaturesChangeStamp() {
        this.changeStampIsValid = false;
        this.featuresChangeStampIsValid = false;
        this.parent.invalidateFeaturesChangeStamp();
    }

    public void invalidatePluginsChangeStamp() {
        this.changeStampIsValid = false;
        this.pluginsChangeStampIsValid = false;
        this.parent.invalidatePluginsChangeStamp();
    }

    public void addFeatureEntry(IPlatformConfiguration.IFeatureEntry feature) {
        this.featureEntries.add(feature);
    }

    public IPlatformConfiguration.IFeatureEntry[] getFeatureEntries() {
        return this.featureEntries.toArray(new IPlatformConfiguration.IFeatureEntry[this.featureEntries.size()]);
    }

    public void addPluginEntry(PluginEntry plugin) {
        this.pluginEntries.add(plugin);
    }

    public PluginEntry[] getPluginEntries() {
        return this.pluginEntries.toArray(new PluginEntry[this.pluginEntries.size()]);
    }
}

