/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.internal.configurator.BootDescriptor;
import org.eclipse.update.internal.configurator.ConfigurationActivator;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.SiteEntry;
import org.eclipse.update.internal.configurator.SitePolicy;
import org.eclipse.update.internal.configurator.Utils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PlatformConfiguration
implements IPlatformConfiguration {
    private static PlatformConfiguration currentPlatformConfiguration = null;
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private URL configLocation;
    private HashMap sites = new HashMap();
    private HashMap externalLinkSites = new HashMap();
    private HashMap cfgdFeatures = new HashMap();
    private HashMap bootPlugins = new HashMap();
    private String defaultFeature;
    private long changeStamp;
    private boolean changeStampIsValid = false;
    private long lastFeaturesChangeStamp;
    private long featuresChangeStamp;
    private boolean featuresChangeStampIsValid = false;
    private long lastPluginsChangeStamp;
    private long pluginsChangeStamp;
    private boolean pluginsChangeStampIsValid = false;
    private boolean transientConfig = false;
    private File cfgLockFile;
    private RandomAccessFile cfgLockFileRAF;
    private BootDescriptor runtimeDescriptor;
    private static String cmdFeature = null;
    private static String cmdApplication = null;
    private static boolean cmdInitialize = false;
    private static boolean cmdFirstUse = false;
    private static boolean cmdUpdate = false;
    private static boolean cmdNoUpdate = false;
    private static boolean cmdDev = false;
    private static final String ECLIPSE = "eclipse";
    private static final String CONFIG_DIR = ".config";
    private static final String CONFIG_NAME = "platform.cfg";
    private static final String CONFIG_FILE = ".config/platform.cfg";
    private static final String CONFIG_FILE_INIT = "install.ini";
    private static final String CONFIG_INI = "config.ini";
    private static final String CONFIG_FILE_LOCK_SUFFIX = ".lock";
    private static final String CONFIG_FILE_TEMP_SUFFIX = ".tmp";
    private static final String CONFIG_FILE_BAK_SUFFIX = ".bak";
    private static final String CHANGES_MARKER = ".newupdates";
    private static final String LINKS = "links";
    private static final String RUNTIME_PLUGIN_ID = "org.eclipse.core.runtime";
    private static final String[] BOOTSTRAP_PLUGINS = new String[]{"org.eclipse.core.boot"};
    private static final String CFG = "config";
    private static final String CFG_BOOT_PLUGIN = "bootstrap";
    private static final String CFG_SITE = "site";
    private static final String CFG_URL = "url";
    private static final String CFG_POLICY = "policy";
    private static final String[] CFG_POLICY_TYPE = new String[]{"USER-INCLUDE", "USER-EXCLUDE"};
    private static final String CFG_POLICY_TYPE_UNKNOWN = "UNKNOWN";
    private static final String CFG_LIST = "list";
    private static final String CFG_STAMP = "stamp";
    private static final String CFG_FEATURE_STAMP = "stamp.features";
    private static final String CFG_PLUGIN_STAMP = "stamp.plugins";
    private static final String CFG_UPDATEABLE = "updateable";
    private static final String CFG_LINK_FILE = "linkfile";
    private static final String CFG_FEATURE_ENTRY = "feature";
    private static final String CFG_FEATURE_ENTRY_DEFAULT = "feature.default.id";
    private static final String CFG_FEATURE_ENTRY_ID = "id";
    private static final String CFG_FEATURE_ENTRY_PRIMARY = "primary";
    private static final String CFG_FEATURE_ENTRY_VERSION = "version";
    private static final String CFG_FEATURE_ENTRY_PLUGIN_VERSION = "plugin-version";
    private static final String CFG_FEATURE_ENTRY_PLUGIN_IDENTIFIER = "plugin-identifier";
    private static final String CFG_FEATURE_ENTRY_APPLICATION = "application";
    private static final String CFG_FEATURE_ENTRY_ROOT = "root";
    private static final String INIT_DEFAULT_FEATURE_ID = "feature.default.id";
    private static final String INIT_DEFAULT_PLUGIN_ID = "feature.default.plugin.id";
    private static final String INIT_DEFAULT_FEATURE_APPLICATION = "feature.default.application";
    private static final String DEFAULT_FEATURE_ID = "org.eclipse.platform";
    private static final String DEFAULT_FEATURE_APPLICATION = "org.eclipse.ui.ide.workbench";
    private static final String CFG_VERSION = "version";
    private static final String CFG_TRANSIENT = "transient";
    private static final String VERSION = "2.1";
    private static final String EOF = "eof";
    private static final int CFG_LIST_LENGTH = 10;
    private static final int DEFAULT_POLICY_TYPE = 1;
    private static final String[] DEFAULT_POLICY_LIST = new String[0];
    private static final String LINK_PATH = "path";
    private static final String LINK_READ = "r";
    private static final String LINK_READ_WRITE = "rw";
    private static final String CMD_FEATURE = "-feature";
    private static final String CMD_APPLICATION = "-application";
    private static final String CMD_PLUGINS = "-plugins";
    private static final String CMD_UPDATE = "-update";
    private static final String CMD_INITIALIZE = "-initialize";
    private static final String CMD_FIRSTUSE = "-firstuse";
    private static final String CMD_NO_UPDATE = "-noupdate";
    private static final String CMD_NEW_UPDATES = "-newUpdates";
    private static final String CMD_DEV = "-dev";
    public static final String RECONCILER_APP = "org.eclipse.update.core.reconciler";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static URL installURL;

    private PlatformConfiguration(String configPath) throws IOException {
        this.initializeCurrent(configPath);
        this.loadInitializationAttributes();
        this.configureExternalLinks();
        this.validateSites();
        this.computeChangeStamp();
    }

    PlatformConfiguration(URL url) throws IOException {
        this.initialize(url);
    }

    public IPlatformConfiguration.ISiteEntry createSiteEntry(URL url, IPlatformConfiguration.ISitePolicy policy) {
        return new SiteEntry(url, policy, this);
    }

    public IPlatformConfiguration.ISitePolicy createSitePolicy(int type, String[] list) {
        return new SitePolicy(type, list);
    }

    public IPlatformConfiguration.IFeatureEntry createFeatureEntry(String id, String version, String pluginVersion, boolean primary, String application, URL[] root) {
        return new FeatureEntry(id, version, pluginVersion, primary, application, root);
    }

    public IPlatformConfiguration.IFeatureEntry createFeatureEntry(String id, String version, String pluginIdentifier, String pluginVersion, boolean primary, String application, URL[] root) {
        return new FeatureEntry(id, version, pluginIdentifier, pluginVersion, primary, application, root);
    }

    public void configureSite(IPlatformConfiguration.ISiteEntry entry) {
        this.configureSite(entry, false);
    }

    public synchronized void configureSite(IPlatformConfiguration.ISiteEntry entry, boolean replace) {
        if (entry == null) {
            return;
        }
        URL url = entry.getURL();
        if (url == null) {
            return;
        }
        String key = url.toExternalForm();
        if (this.sites.containsKey(key) && !replace) {
            return;
        }
        this.sites.put(key, entry);
    }

    public synchronized void unconfigureSite(IPlatformConfiguration.ISiteEntry entry) {
        if (entry == null) {
            return;
        }
        URL url = entry.getURL();
        if (url == null) {
            return;
        }
        String key = url.toExternalForm();
        this.sites.remove(key);
    }

    public IPlatformConfiguration.ISiteEntry[] getConfiguredSites() {
        if (this.sites.size() == 0) {
            return new IPlatformConfiguration.ISiteEntry[0];
        }
        return this.sites.values().toArray(new IPlatformConfiguration.ISiteEntry[0]);
    }

    public IPlatformConfiguration.ISiteEntry findConfiguredSite(URL url) {
        if (url == null) {
            return null;
        }
        String key = url.toExternalForm();
        IPlatformConfiguration.ISiteEntry result = (IPlatformConfiguration.ISiteEntry)this.sites.get(key);
        try {
            key = URLDecoder.decode(key, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        if (result == null) {
            result = (IPlatformConfiguration.ISiteEntry)this.sites.get(key);
        }
        return result;
    }

    public synchronized void configureFeatureEntry(IPlatformConfiguration.IFeatureEntry entry) {
        if (entry == null) {
            return;
        }
        String key = entry.getFeatureIdentifier();
        if (key == null) {
            return;
        }
        this.cfgdFeatures.put(key, entry);
    }

    public synchronized void unconfigureFeatureEntry(IPlatformConfiguration.IFeatureEntry entry) {
        if (entry == null) {
            return;
        }
        String key = entry.getFeatureIdentifier();
        if (key == null) {
            return;
        }
        this.cfgdFeatures.remove(key);
    }

    public IPlatformConfiguration.IFeatureEntry[] getConfiguredFeatureEntries() {
        if (this.cfgdFeatures.size() == 0) {
            return new IPlatformConfiguration.IFeatureEntry[0];
        }
        return this.cfgdFeatures.values().toArray(new IPlatformConfiguration.IFeatureEntry[0]);
    }

    public IPlatformConfiguration.IFeatureEntry findConfiguredFeatureEntry(String id) {
        if (id == null) {
            return null;
        }
        return (IPlatformConfiguration.IFeatureEntry)this.cfgdFeatures.get(id);
    }

    public URL getConfigurationLocation() {
        return this.configLocation;
    }

    public long getChangeStamp() {
        if (!this.changeStampIsValid) {
            this.computeChangeStamp();
        }
        return this.changeStamp;
    }

    public long getFeaturesChangeStamp() {
        if (!this.featuresChangeStampIsValid) {
            this.computeFeaturesChangeStamp();
        }
        return this.featuresChangeStamp;
    }

    public long getPluginsChangeStamp() {
        if (!this.pluginsChangeStampIsValid) {
            this.computePluginsChangeStamp();
        }
        return this.pluginsChangeStamp;
    }

    public String getApplicationIdentifier() {
        if (cmdInitialize) {
            return RECONCILER_APP;
        }
        if (this.featuresChangeStamp != this.lastFeaturesChangeStamp) {
            boolean update;
            boolean bl = update = !cmdNoUpdate || cmdUpdate;
            if (update) {
                return RECONCILER_APP;
            }
        }
        return this.getApplicationIdentifierInternal();
    }

    private String getApplicationIdentifierInternal() {
        IPlatformConfiguration.IFeatureEntry fe;
        if (cmdApplication != null) {
            return cmdApplication;
        }
        String feature = cmdFeature;
        if (feature == null) {
            feature = this.defaultFeature;
        }
        if (feature != null && (fe = this.findConfiguredFeatureEntry(feature)) != null && fe.getFeatureApplication() != null) {
            return fe.getFeatureApplication();
        }
        return DEFAULT_FEATURE_APPLICATION;
    }

    public String getPrimaryFeatureIdentifier() {
        String primaryFeatureId = null;
        primaryFeatureId = cmdFeature != null ? cmdFeature : (this.defaultFeature != null ? this.defaultFeature : DEFAULT_FEATURE_ID);
        if (this.findConfiguredFeatureEntry(primaryFeatureId) == null) {
            return null;
        }
        return primaryFeatureId;
    }

    public URL[] getPluginPath() {
        ArrayList<URL> path = new ArrayList<URL>();
        Utils.debug("computed plug-in path:");
        IPlatformConfiguration.ISiteEntry[] sites = this.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            String[] plugins = sites[i].getPlugins();
            int j = 0;
            while (j < plugins.length) {
                try {
                    URL pathURL = new URL(((SiteEntry)sites[i]).getResolvedURL(), plugins[j]);
                    path.add(pathURL);
                    Utils.debug("   " + pathURL.toString());
                }
                catch (MalformedURLException e) {
                    Utils.debug("   bad URL: " + e);
                }
                ++j;
            }
            ++i;
        }
        return path.toArray(new URL[0]);
    }

    public String[] getBootstrapPluginIdentifiers() {
        return BOOTSTRAP_PLUGINS;
    }

    public void setBootstrapPluginLocation(String id, URL location) {
        String[] ids = this.getBootstrapPluginIdentifiers();
        int i = 0;
        while (i < ids.length) {
            if (ids[i].equals(id)) {
                this.bootPlugins.put(id, location.toExternalForm());
                break;
            }
            ++i;
        }
    }

    public boolean isUpdateable() {
        return true;
    }

    public boolean isTransient() {
        return this.transientConfig;
    }

    public void isTransient(boolean value) {
    }

    public synchronized void refresh() {
        IPlatformConfiguration.ISiteEntry[] sites = this.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            ((SiteEntry)sites[i]).refresh();
            ++i;
        }
        this.lastFeaturesChangeStamp = this.featuresChangeStamp;
        this.lastPluginsChangeStamp = this.pluginsChangeStamp;
        this.changeStampIsValid = false;
        this.featuresChangeStampIsValid = false;
        this.pluginsChangeStampIsValid = false;
    }

    public void save() throws IOException {
        if (this.isUpdateable()) {
            this.save(this.configLocation);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void save(URL url) throws IOException {
        boolean ok;
        if (url == null) {
            throw new IOException(Messages.getString("cfig.unableToSave.noURL"));
        }
        PrintWriter w = null;
        OutputStream os = null;
        if (!url.getProtocol().equals("file")) {
            URLConnection uc = url.openConnection();
            uc.setDoOutput(true);
            os = uc.getOutputStream();
            w = new PrintWriter(os);
            try {
                this.write(w);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                w.close();
                throw throwable;
            }
            {
                Object var5_9 = null;
                w.close();
                return;
            }
        }
        File cfigFile = new File(url.getFile().replace('/', File.separatorChar));
        File cfigDir = cfigFile.getParentFile();
        if (cfigDir != null) {
            cfigDir.mkdirs();
        }
        this.writeConfigIni(cfigDir);
        File cfigTmp = new File(String.valueOf(cfigFile.getAbsolutePath()) + CONFIG_FILE_TEMP_SUFFIX);
        os = new FileOutputStream(cfigTmp);
        w = new PrintWriter(os);
        try {
            this.write(w);
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            w.close();
            throw throwable;
        }
        {
            Object var7_14 = null;
            w.close();
        }
        FileInputStream is = new FileInputStream(cfigTmp);
        Properties tmpProps = new Properties();
        try {
            tmpProps.load(is);
            if (!EOF.equals(tmpProps.getProperty(EOF))) {
                throw new IOException(Messages.getString("cfig.unableToSave", cfigTmp.getAbsolutePath()));
            }
        }
        catch (Throwable throwable) {
            Object var9_17 = null;
            ((InputStream)is).close();
            throw throwable;
        }
        {
            Object var9_18 = null;
        }
        ((InputStream)is).close();
        File cfigBak = new File(String.valueOf(cfigFile.getAbsolutePath()) + CONFIG_FILE_BAK_SUFFIX);
        cfigBak.delete();
        if (cfigFile.exists()) {
            cfigFile.renameTo(cfigBak);
        }
        if (!(ok = cfigTmp.renameTo(cfigFile))) throw new IOException(Messages.getString("cfig.unableToSave", cfigTmp.getAbsolutePath()));
        cfigBak.delete();
    }

    private void writeConfigIni(File configDir) {
        try {
            File configIni = new File(configDir, CONFIG_INI);
            if (!configIni.exists()) {
                URL configIniURL = ConfigurationActivator.getBundleContext().getBundle().getEntry(CONFIG_INI);
                File sourceConfigIni = new File(configIniURL.getFile());
                this.copy(sourceConfigIni, configIni);
            }
        }
        catch (Exception exception) {
            System.out.println(Messages.getString("cfg.unableToCreateConfig.ini"));
        }
    }

    public BootDescriptor getPluginBootDescriptor(String id) {
        if (RUNTIME_PLUGIN_ID.equals(id)) {
            return this.runtimeDescriptor;
        }
        return null;
    }

    public static PlatformConfiguration getCurrent() {
        return currentPlatformConfiguration;
    }

    public static synchronized String[] startup(String[] cmdArgs, String r10app, URL installURL, String configPath) throws Exception {
        PlatformConfiguration.installURL = installURL;
        cmdApplication = r10app;
        String[] passthruArgs = PlatformConfiguration.processCommandLine(cmdArgs);
        if (cmdDev) {
            cmdNoUpdate = true;
        }
        if (currentPlatformConfiguration == null) {
            currentPlatformConfiguration = new PlatformConfiguration(configPath);
        }
        passthruArgs = PlatformConfiguration.checkForFeatureChanges(passthruArgs, currentPlatformConfiguration);
        passthruArgs = PlatformConfiguration.checkForNewUpdates(currentPlatformConfiguration, passthruArgs);
        return passthruArgs;
    }

    public static synchronized void shutdown() throws IOException {
        PlatformConfiguration config = PlatformConfiguration.getCurrent();
        if (config != null) {
            try {
                config.save();
            }
            catch (IOException e) {
                Utils.debug("Unable to save configuration " + e.toString());
            }
            config.clearConfigurationLock();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void initializeCurrent(String configPath) throws IOException {
        if (cmdInitialize) {
            URL url = new URL(PlatformConfiguration.getInstallURL(), CONFIG_FILE);
            this.getConfigurationLock(url);
            this.resetInitializationConfiguration(url);
            this.configureSite(this.getRootSite());
            Utils.debug("Initializing configuration " + url.toString());
            this.configLocation = url;
            PlatformConfiguration.verifyPath(this.configLocation);
            return;
        }
        URL configDirURL = new URL("file", "", configPath);
        URL configFileURL = new URL("file", "", String.valueOf(configPath) + "/" + CONFIG_NAME);
        try {
            this.getConfigurationLock(configFileURL);
            try {
                this.load(configFileURL);
                Utils.debug("Using configuration " + configFileURL.toString());
            }
            catch (IOException iOException) {
                try {
                    URL sharedConfigDirURL = new URL(PlatformConfiguration.getInstallURL(), CONFIG_DIR);
                    URL sharedConfigFileURL = new URL(PlatformConfiguration.getInstallURL(), CONFIG_FILE);
                    this.load(sharedConfigFileURL);
                    if (!sharedConfigDirURL.equals(configDirURL)) {
                        this.copyInitializedState(sharedConfigDirURL, configPath);
                        Utils.debug("Configuration initialized from    " + sharedConfigDirURL.toString());
                    }
                    Object var6_7 = null;
                    this.configLocation = configFileURL;
                }
                catch (IOException iOException2) {
                    cmdFirstUse = true;
                    this.configureSite(this.getRootSite());
                }
                PlatformConfiguration.verifyPath(this.configLocation);
                Utils.debug("Creating configuration " + configFileURL.toString());
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.configLocation = configFileURL;
            PlatformConfiguration.verifyPath(this.configLocation);
            Utils.debug("Creating configuration " + configFileURL.toString());
            throw throwable;
        }
        {
            Object var6_9 = null;
            this.configLocation = configFileURL;
        }
        PlatformConfiguration.verifyPath(this.configLocation);
        Utils.debug("Creating configuration " + configFileURL.toString());
    }

    private synchronized void initialize(URL url) throws IOException {
        if (url == null) {
            Utils.debug("Creating empty configuration object");
            return;
        }
        this.load(url);
        this.configLocation = url;
        Utils.debug("Using configuration " + this.configLocation.toString());
    }

    private IPlatformConfiguration.ISiteEntry getRootSite() {
        IPlatformConfiguration.ISitePolicy defaultPolicy = this.createSitePolicy(1, DEFAULT_POLICY_LIST);
        URL siteURL = null;
        try {
            siteURL = new URL("platform:/base/");
        }
        catch (MalformedURLException malformedURLException) {
            siteURL = PlatformConfiguration.getInstallURL();
        }
        IPlatformConfiguration.ISiteEntry defaultSite = this.createSiteEntry(siteURL, defaultPolicy);
        return defaultSite;
    }

    private void resetInitializationConfiguration(URL url) throws IOException {
        if (!PlatformConfiguration.supportsDetection(url)) {
            return;
        }
        URL resolved = PlatformConfiguration.resolvePlatformURL(url);
        File initCfg = new File(resolved.getFile().replace('/', File.separatorChar));
        File initDir = initCfg.getParentFile();
        this.resetInitializationLocation(initDir);
    }

    private void resetInitializationLocation(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] list = dir.listFiles();
        int i = 0;
        while (i < list.length) {
            if (list[i].isDirectory()) {
                this.resetInitializationLocation(list[i]);
            }
            list[i].delete();
            ++i;
        }
    }

    private boolean getConfigurationLock(URL url) {
        return false;
    }

    private void clearConfigurationLock() {
        try {
            if (this.cfgLockFileRAF != null) {
                this.cfgLockFileRAF.close();
                this.cfgLockFileRAF = null;
            }
        }
        catch (IOException iOException) {}
        if (this.cfgLockFile != null) {
            this.cfgLockFile.delete();
            this.cfgLockFile = null;
        }
    }

    private void computeChangeStamp() {
        this.computeFeaturesChangeStamp();
        this.computePluginsChangeStamp();
        this.changeStamp = this.featuresChangeStamp ^ this.pluginsChangeStamp;
        this.changeStampIsValid = true;
    }

    private void computeFeaturesChangeStamp() {
        if (this.featuresChangeStampIsValid) {
            return;
        }
        long result = 0L;
        IPlatformConfiguration.ISiteEntry[] sites = this.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            result ^= sites[i].getFeaturesChangeStamp();
            ++i;
        }
        this.featuresChangeStamp = result;
        this.featuresChangeStampIsValid = true;
    }

    private void computePluginsChangeStamp() {
        if (this.pluginsChangeStampIsValid) {
            return;
        }
        long result = 0L;
        IPlatformConfiguration.ISiteEntry[] sites = this.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            result ^= sites[i].getPluginsChangeStamp();
            ++i;
        }
        this.pluginsChangeStamp = result;
        this.pluginsChangeStampIsValid = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void configureExternalLinks() {
        URL linkURL = PlatformConfiguration.getInstallURL();
        if (!PlatformConfiguration.supportsDetection(linkURL)) {
            return;
        }
        try {
            linkURL = new URL(linkURL, "links/");
        }
        catch (MalformedURLException malformedURLException) {
            Utils.debug("Unable to obtain link URL");
            return;
        }
        File linkDir = new File(linkURL.getFile());
        File[] links = linkDir.listFiles();
        if (links == null || links.length == 0) {
            Utils.debug("No links detected in " + linkURL.toExternalForm());
            return;
        }
        int i = 0;
        while (true) {
            block16: {
                Object var8_8;
                if (i >= links.length) {
                    return;
                }
                if (links[i].isDirectory()) break block16;
                Utils.debug("Link file " + links[i].getAbsolutePath());
                Properties props = new Properties();
                FileInputStream is = null;
                try {
                    try {
                        is = new FileInputStream(links[i]);
                        props.load(is);
                        this.configureExternalLinkSites(links[i], props);
                    }
                    catch (IOException e) {
                        Utils.debug("   unable to load link file " + e);
                        var8_8 = null;
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    var8_8 = null;
                    if (is == null) throw throwable;
                    try {}
                    catch (IOException iOException) {}
                    is.close();
                    throw throwable;
                    throw throwable;
                }
                {
                    var8_8 = null;
                    if (is == null) break block16;
                }
                try {}
                catch (IOException iOException) {}
                is.close();
            }
            ++i;
        }
    }

    private void configureExternalLinkSites(File linkFile, Properties props) {
        URL siteURL;
        String link;
        String path = props.getProperty(LINK_PATH);
        if (path == null) {
            Utils.debug("   no path definition");
            return;
        }
        boolean updateable = true;
        IPlatformConfiguration.ISitePolicy linkSitePolicy = this.createSitePolicy(1, DEFAULT_POLICY_LIST);
        if (path.startsWith("r ")) {
            updateable = false;
            link = path.substring(2).trim();
        } else {
            link = path.startsWith("rw ") ? path.substring(3).trim() : path;
        }
        try {
            File target;
            if (!link.endsWith(File.separator)) {
                link = String.valueOf(link) + File.separator;
            }
            if (!(link = "file:" + (target = new File(String.valueOf(link) + ECLIPSE)).getAbsolutePath().replace(File.separatorChar, '/')).endsWith("/")) {
                link = String.valueOf(link) + "/";
            }
            siteURL = new URL(link);
        }
        catch (MalformedURLException e) {
            Utils.debug("  bad URL " + e);
            return;
        }
        SiteEntry linkSite = (SiteEntry)this.externalLinkSites.get(siteURL);
        if (linkSite == null) {
            linkSite = (SiteEntry)this.createSiteEntry(siteURL, linkSitePolicy);
        }
        linkSite.setUpdateable(updateable);
        linkSite.setLinkFileName(linkFile.getAbsolutePath());
        this.configureSite(linkSite);
        Utils.debug("   " + (updateable ? "R/W -> " : "R/O -> ") + siteURL.toString());
    }

    private void validateSites() {
        SiteEntry[] list = this.sites.values().toArray(new SiteEntry[0]);
        int i = 0;
        while (i < list.length) {
            File siteRoot;
            URL siteURL = list[i].getResolvedURL();
            if (PlatformConfiguration.supportsDetection(siteURL) && !(siteRoot = new File(siteURL.getFile().replace('/', File.separatorChar))).exists()) {
                this.unconfigureSite(list[i]);
                Utils.debug("Site " + siteURL + " does not exist ... removing from configuration");
            }
            ++i;
        }
    }

    private void copyInitializedState(URL source, String target) {
        try {
            if (!source.getProtocol().equals("file")) {
                return;
            }
            this.copy(new File(source.getFile()), new File(target));
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copy(File src, File tgt) throws IOException {
        FileOutputStream os;
        block18: {
            if (src.isDirectory()) {
                tgt.mkdir();
                File[] list = src.listFiles();
                if (list == null) {
                    return;
                }
                int i = 0;
                while (true) {
                    if (i >= list.length) {
                        return;
                    }
                    this.copy(list[i], new File(tgt, list[i].getName()));
                    ++i;
                }
            }
            FileInputStream is = null;
            os = null;
            try {
                try {
                    is = new FileInputStream(src);
                    os = new FileOutputStream(tgt);
                    byte[] buff = new byte[1024];
                    int count = is.read(buff);
                    while (count != -1) {
                        os.write(buff, 0, count);
                        count = is.read(buff);
                    }
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                if (os == null) throw throwable;
                try {
                    os.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var7_11 = null;
                if (is == null) break block18;
            }
            try {}
            catch (IOException iOException) {}
            is.close();
        }
        if (os == null) return;
        try {}
        catch (IOException iOException) {
            return;
        }
        os.close();
    }

    private void load(URL url) throws IOException {
        String stamp;
        if (url == null) {
            throw new IOException(Messages.getString("cfig.unableToLoad.noURL"));
        }
        Properties props = null;
        IOException originalException = null;
        try {
            props = this.loadProperties(url, null);
        }
        catch (IOException e1) {
            originalException = e1;
            try {
                props = this.loadProperties(url, CONFIG_FILE_TEMP_SUFFIX);
            }
            catch (IOException iOException) {
                try {
                    props = this.loadProperties(url, CONFIG_FILE_BAK_SUFFIX);
                }
                catch (IOException iOException2) {
                    throw originalException;
                }
            }
        }
        String v = props.getProperty("version");
        if (!VERSION.equals(v)) {
            this.resetUpdateManagerState(url);
            throw new IOException(Messages.getString("cfig.badVersion", v));
        }
        this.defaultFeature = this.loadAttribute(props, "feature.default.id", null);
        String flag = this.loadAttribute(props, CFG_TRANSIENT, null);
        if (flag != null) {
            this.transientConfig = flag.equals("true");
        }
        if ((stamp = this.loadAttribute(props, CFG_FEATURE_STAMP, null)) != null) {
            try {
                this.lastFeaturesChangeStamp = Long.parseLong(stamp);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((stamp = this.loadAttribute(props, CFG_PLUGIN_STAMP, null)) != null) {
            try {
                this.lastPluginsChangeStamp = Long.parseLong(stamp);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String[] ids = this.getBootstrapPluginIdentifiers();
        int i = 0;
        while (i < ids.length) {
            this.bootPlugins.put(ids[i], this.loadAttribute(props, "bootstrap." + ids[i], null));
            ++i;
        }
        IPlatformConfiguration.IFeatureEntry fe = this.loadFeatureEntry(props, "feature.0", null);
        int i2 = 1;
        while (fe != null) {
            this.configureFeatureEntry(fe);
            fe = this.loadFeatureEntry(props, "feature." + i2, null);
            ++i2;
        }
        SiteEntry root = (SiteEntry)this.getRootSite();
        String rootUrlString = root.getURL().toExternalForm();
        SiteEntry se = (SiteEntry)this.loadSite(props, "site.0", null);
        int i3 = 1;
        while (se != null) {
            if (cmdFirstUse && rootUrlString.equals(se.getURL().toExternalForm())) {
                se = root;
            }
            if (!se.isExternallyLinkedSite()) {
                this.configureSite(se);
            } else {
                this.externalLinkSites.put(se.getURL(), se);
            }
            se = (SiteEntry)this.loadSite(props, "site." + i3, null);
            ++i3;
        }
    }

    /*
     * Exception decompiling
     */
    private Properties loadProperties(URL url, String suffix) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 139->142)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IPlatformConfiguration.ISiteEntry loadSite(Properties props, String name, IPlatformConfiguration.ISiteEntry dflt) {
        String linkname;
        String flag;
        String[] policyList;
        int policyType;
        String urlString = this.loadAttribute(props, String.valueOf(name) + "." + CFG_URL, null);
        if (urlString == null) {
            return dflt;
        }
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            return dflt;
        }
        String typeString = this.loadAttribute(props, String.valueOf(name) + "." + CFG_POLICY, null);
        if (typeString == null) {
            policyType = 1;
            policyList = DEFAULT_POLICY_LIST;
        } else {
            int i = 0;
            while (i < CFG_POLICY_TYPE.length) {
                if (typeString.equals(CFG_POLICY_TYPE[i])) break;
                ++i;
            }
            if (i >= CFG_POLICY_TYPE.length) {
                policyType = 1;
                policyList = DEFAULT_POLICY_LIST;
            } else {
                policyType = i;
                policyList = this.loadListAttribute(props, String.valueOf(name) + "." + CFG_LIST, new String[0]);
            }
        }
        IPlatformConfiguration.ISitePolicy sp = this.createSitePolicy(policyType, policyList);
        SiteEntry site = (SiteEntry)this.createSiteEntry(url, sp);
        String stamp = this.loadAttribute(props, String.valueOf(name) + "." + CFG_FEATURE_STAMP, null);
        if (stamp != null) {
            try {
                site.setLastFeaturesChangeStamp(Long.parseLong(stamp));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((stamp = this.loadAttribute(props, String.valueOf(name) + "." + CFG_PLUGIN_STAMP, null)) != null) {
            try {
                site.setLastPluginsChangeStamp(Long.parseLong(stamp));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((flag = this.loadAttribute(props, String.valueOf(name) + "." + CFG_UPDATEABLE, null)) != null) {
            if (flag.equals("true")) {
                site.setUpdateable(true);
            } else {
                site.setUpdateable(false);
            }
        }
        if ((linkname = this.loadAttribute(props, String.valueOf(name) + "." + CFG_LINK_FILE, null)) != null && !linkname.equals("")) {
            site.setLinkFileName(linkname.replace('/', File.separatorChar));
        }
        return site;
    }

    private IPlatformConfiguration.IFeatureEntry loadFeatureEntry(Properties props, String name, IPlatformConfiguration.IFeatureEntry dflt) {
        String pluginIdentifier;
        String id = this.loadAttribute(props, String.valueOf(name) + "." + CFG_FEATURE_ENTRY_ID, null);
        if (id == null) {
            return dflt;
        }
        String version = this.loadAttribute(props, String.valueOf(name) + "." + "version", null);
        String pluginVersion = this.loadAttribute(props, String.valueOf(name) + "." + CFG_FEATURE_ENTRY_PLUGIN_VERSION, null);
        if (pluginVersion == null) {
            pluginVersion = version;
        }
        if ((pluginIdentifier = this.loadAttribute(props, String.valueOf(name) + "." + CFG_FEATURE_ENTRY_PLUGIN_IDENTIFIER, null)) == null) {
            pluginIdentifier = id;
        }
        String application = this.loadAttribute(props, String.valueOf(name) + "." + CFG_FEATURE_ENTRY_APPLICATION, null);
        ArrayList<URL> rootList = new ArrayList<URL>();
        String rootString = this.loadAttribute(props, String.valueOf(name) + "." + CFG_FEATURE_ENTRY_ROOT + ".0", null);
        int i = 1;
        while (rootString != null) {
            try {
                URL rootEntry = new URL(rootString);
                rootList.add(rootEntry);
            }
            catch (MalformedURLException malformedURLException) {}
            rootString = this.loadAttribute(props, String.valueOf(name) + "." + CFG_FEATURE_ENTRY_ROOT + "." + i, null);
            ++i;
        }
        URL[] roots = rootList.toArray(new URL[0]);
        boolean primary = false;
        String flag = this.loadAttribute(props, String.valueOf(name) + "." + CFG_FEATURE_ENTRY_PRIMARY, null);
        if (flag != null && flag.equals("true")) {
            primary = true;
        }
        return this.createFeatureEntry(id, version, pluginIdentifier, pluginVersion, primary, application, roots);
    }

    private String[] loadListAttribute(Properties props, String name, String[] dflt) {
        ArrayList list = new ArrayList();
        String value = this.loadAttribute(props, String.valueOf(name) + ".0", null);
        if (value == null) {
            return dflt;
        }
        int i = 1;
        while (value != null) {
            this.loadListAttributeSegment(list, value);
            value = this.loadAttribute(props, String.valueOf(name) + "." + i, null);
            ++i;
        }
        return list.toArray(new String[0]);
    }

    private void loadListAttributeSegment(ArrayList list, String value) {
        if (value == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(value, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.add(token);
        }
    }

    private String loadAttribute(Properties props, String name, String dflt) {
        String prop = props.getProperty(name);
        if (prop == null) {
            return dflt;
        }
        return prop.trim();
    }

    /*
     * Exception decompiling
     */
    private void loadInitializationAttributes() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 93->96)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void write(PrintWriter w) {
        w.println("# " + new Date().toString());
        this.writeAttribute(w, "version", VERSION);
        if (this.transientConfig) {
            this.writeAttribute(w, CFG_TRANSIENT, "true");
        }
        w.println("");
        this.writeAttribute(w, CFG_STAMP, Long.toString(this.getChangeStamp()));
        this.writeAttribute(w, CFG_FEATURE_STAMP, Long.toString(this.getFeaturesChangeStamp()));
        this.writeAttribute(w, CFG_PLUGIN_STAMP, Long.toString(this.getPluginsChangeStamp()));
        String[] ids = this.getBootstrapPluginIdentifiers();
        int i = 0;
        while (i < ids.length) {
            String location = (String)this.bootPlugins.get(ids[i]);
            if (location != null) {
                this.writeAttribute(w, "bootstrap." + ids[i], location);
            }
            ++i;
        }
        w.println("");
        this.writeAttribute(w, "feature.default.id", this.defaultFeature);
        IPlatformConfiguration.IFeatureEntry[] feats = this.getConfiguredFeatureEntries();
        int i2 = 0;
        while (i2 < feats.length) {
            this.writeFeatureEntry(w, "feature." + Integer.toString(i2), feats[i2]);
            ++i2;
        }
        SiteEntry[] list = this.sites.values().toArray(new SiteEntry[0]);
        int i3 = 0;
        while (i3 < list.length) {
            this.writeSite(w, "site." + Integer.toString(i3), list[i3]);
            ++i3;
        }
        this.writeAttribute(w, EOF, EOF);
    }

    private void writeSite(PrintWriter w, String id, SiteEntry entry) {
        w.println("");
        this.writeAttribute(w, String.valueOf(id) + "." + CFG_URL, entry.getURL().toString());
        this.writeAttribute(w, String.valueOf(id) + "." + CFG_STAMP, Long.toString(entry.getChangeStamp()));
        this.writeAttribute(w, String.valueOf(id) + "." + CFG_FEATURE_STAMP, Long.toString(entry.getFeaturesChangeStamp()));
        this.writeAttribute(w, String.valueOf(id) + "." + CFG_PLUGIN_STAMP, Long.toString(entry.getPluginsChangeStamp()));
        this.writeAttribute(w, String.valueOf(id) + "." + CFG_UPDATEABLE, entry.isUpdateable() ? "true" : "false");
        if (entry.isExternallyLinkedSite()) {
            this.writeAttribute(w, String.valueOf(id) + "." + CFG_LINK_FILE, entry.getLinkFileName().trim().replace(File.separatorChar, '/'));
        }
        int type = entry.getSitePolicy().getType();
        String typeString = CFG_POLICY_TYPE_UNKNOWN;
        try {
            typeString = CFG_POLICY_TYPE[type];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        this.writeAttribute(w, String.valueOf(id) + "." + CFG_POLICY, typeString);
        this.writeListAttribute(w, String.valueOf(id) + "." + CFG_LIST, entry.getSitePolicy().getList());
    }

    private void writeFeatureEntry(PrintWriter w, String id, IPlatformConfiguration.IFeatureEntry entry) {
        w.println("");
        this.writeAttribute(w, String.valueOf(id) + "." + CFG_FEATURE_ENTRY_ID, entry.getFeatureIdentifier());
        if (entry.canBePrimary()) {
            this.writeAttribute(w, String.valueOf(id) + "." + CFG_FEATURE_ENTRY_PRIMARY, "true");
        }
        this.writeAttribute(w, String.valueOf(id) + "." + "version", entry.getFeatureVersion());
        if (entry.getFeatureVersion() != null && !entry.getFeatureVersion().equals(entry.getFeaturePluginVersion())) {
            this.writeAttribute(w, String.valueOf(id) + "." + CFG_FEATURE_ENTRY_PLUGIN_VERSION, entry.getFeaturePluginVersion());
        }
        if (entry.getFeatureIdentifier() != null && !entry.getFeatureIdentifier().equals(entry.getFeaturePluginIdentifier())) {
            this.writeAttribute(w, String.valueOf(id) + "." + CFG_FEATURE_ENTRY_PLUGIN_IDENTIFIER, entry.getFeaturePluginIdentifier());
        }
        this.writeAttribute(w, String.valueOf(id) + "." + CFG_FEATURE_ENTRY_APPLICATION, entry.getFeatureApplication());
        URL[] roots = entry.getFeatureRootURLs();
        int i = 0;
        while (i < roots.length) {
            this.writeAttribute(w, String.valueOf(id) + "." + CFG_FEATURE_ENTRY_ROOT + "." + i, roots[i].toExternalForm());
            ++i;
        }
    }

    private void writeListAttribute(PrintWriter w, String id, String[] list) {
        if (list == null || list.length == 0) {
            return;
        }
        String value = "";
        int listLen = 0;
        int listIndex = 0;
        int i = 0;
        while (i < list.length) {
            value = listLen != 0 ? String.valueOf(value) + "," : "";
            value = String.valueOf(value) + list[i];
            if (++listLen >= 10) {
                this.writeAttribute(w, String.valueOf(id) + "." + Integer.toString(listIndex++), value);
                listLen = 0;
            }
            ++i;
        }
        if (listLen != 0) {
            this.writeAttribute(w, String.valueOf(id) + "." + Integer.toString(listIndex), value);
        }
    }

    private void writeAttribute(PrintWriter w, String id, String value) {
        if (value == null || value.trim().equals("")) {
            return;
        }
        w.println(String.valueOf(id) + "=" + this.escapedValue(value));
    }

    private String escapedValue(String value) {
        StringBuffer buf = new StringBuffer(value.length() * 2);
        int i = 0;
        while (i < value.length()) {
            char character = value.charAt(i);
            if (character == '\\' || character == '\t' || character == '\r' || character == '\n' || character == '\f') {
                buf.append('\\');
                buf.append(character);
            } else if (character < ' ' || character > '~') {
                buf.append('\\');
                buf.append('u');
                buf.append(HEX[character >> 12 & 0xF]);
                buf.append(HEX[character >> 8 & 0xF]);
                buf.append(HEX[character >> 4 & 0xF]);
                buf.append(HEX[character & 0xF]);
            } else {
                buf.append(character);
            }
            ++i;
        }
        return buf.toString();
    }

    private static String[] checkForFeatureChanges(String[] args, PlatformConfiguration cfg) {
        String actual;
        String original = cfg.getApplicationIdentifierInternal();
        if (original.equals(actual = cfg.getApplicationIdentifier())) {
            return args;
        }
        int newArgCnt = cmdFirstUse ? 3 : 2;
        String[] newArgs = new String[args.length + newArgCnt];
        newArgs[0] = CMD_APPLICATION;
        newArgs[1] = original;
        if (cmdFirstUse) {
            newArgs[2] = CMD_FIRSTUSE;
        }
        System.arraycopy(args, 0, newArgs, newArgCnt, args.length);
        Utils.debug("triggering reconciliation ...");
        return newArgs;
    }

    private static String[] checkForNewUpdates(IPlatformConfiguration cfg, String[] args) {
        try {
            URL markerURL = new URL(cfg.getConfigurationLocation(), CHANGES_MARKER);
            File marker = new File(markerURL.getFile());
            if (!marker.exists()) {
                return args;
            }
            marker.delete();
            String[] newArgs = new String[args.length + 1];
            newArgs[0] = CMD_NEW_UPDATES;
            System.arraycopy(args, 0, newArgs, 1, args.length);
            return newArgs;
        }
        catch (MalformedURLException malformedURLException) {
            return args;
        }
    }

    private static String[] processCommandLine(String[] args) throws Exception {
        int[] configArgs = new int[100];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i = 0;
        while (i < args.length) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(CMD_FIRSTUSE)) {
                cmdFirstUse = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(CMD_UPDATE)) {
                cmdUpdate = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(CMD_NO_UPDATE)) {
                cmdNoUpdate = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(CMD_INITIALIZE)) {
                cmdInitialize = true;
            } else if (args[i].equalsIgnoreCase(CMD_DEV)) {
                cmdDev = true;
            } else if (found) {
                configArgs[configArgIndex++] = i;
            } else if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase(CMD_FEATURE)) {
                    found = true;
                    cmdFeature = arg;
                }
                if (args[i - 1].equalsIgnoreCase(CMD_APPLICATION)) {
                    found = true;
                    if (cmdApplication == null) {
                        cmdApplication = arg;
                    }
                }
                if (found) {
                    configArgs[configArgIndex++] = i - 1;
                    configArgs[configArgIndex++] = i;
                }
            }
            ++i;
        }
        if (configArgIndex == 0) {
            return args;
        }
        String[] passThruArgs = new String[args.length - configArgIndex];
        configArgIndex = 0;
        int j = 0;
        int i2 = 0;
        while (i2 < args.length) {
            if (i2 == configArgs[configArgIndex]) {
                ++configArgIndex;
            } else {
                passThruArgs[j++] = args[i2];
            }
            ++i2;
        }
        return passThruArgs;
    }

    public static boolean supportsDetection(URL url) {
        String protocol = url.getProtocol();
        if (protocol.equals("file")) {
            return true;
        }
        if (protocol.equals("platform")) {
            URL resolved = null;
            try {
                resolved = PlatformConfiguration.resolvePlatformURL(url);
            }
            catch (IOException iOException) {
                return false;
            }
            return resolved.getProtocol().equals("file");
        }
        return false;
    }

    private static void verifyPath(URL url) {
        File dir;
        String protocol = url.getProtocol();
        String path = null;
        if (protocol.equals("file")) {
            path = url.getFile();
        } else if (protocol.equals("platform")) {
            URL resolved = null;
            try {
                resolved = PlatformConfiguration.resolvePlatformURL(url);
                if (resolved.getProtocol().equals("file")) {
                    path = resolved.getFile();
                }
            }
            catch (IOException iOException) {}
        }
        if (path != null && (dir = new File(path).getParentFile()) != null) {
            dir.mkdirs();
        }
    }

    public static URL resolvePlatformURL(URL url) throws IOException {
        if (url.getProtocol().equals("platform")) {
            URLConnection connection = url.openConnection();
            url = connection instanceof PlatformURLConnection ? ((PlatformURLConnection)connection).getResolvedURL() : PlatformConfiguration.getInstallURL();
        }
        return url;
    }

    private void resetUpdateManagerState(URL url) throws IOException {
        if (!PlatformConfiguration.supportsDetection(url)) {
            return;
        }
        URL resolved = PlatformConfiguration.resolvePlatformURL(url);
        File initCfg = new File(resolved.getFile().replace('/', File.separatorChar));
        File initDir = initCfg.getParentFile();
        if (initDir == null || !initDir.exists() || !initDir.isDirectory()) {
            return;
        }
        String temp = String.valueOf(initCfg.getName()) + ".metadata";
        File UMDir = new File(initDir, String.valueOf(temp) + '/');
        if (UMDir == null || !UMDir.exists() || !UMDir.isDirectory()) {
            return;
        }
        Date now = new Date();
        boolean renamed = UMDir.renameTo(new File(initDir, String.valueOf(temp) + now.getTime() + '/'));
        if (!renamed) {
            this.resetInitializationLocation(UMDir);
        }
    }

    private static URL getInstallURL() {
        return installURL;
    }

    public void invalidateFeaturesChangeStamp() {
        this.changeStampIsValid = false;
        this.featuresChangeStampIsValid = false;
    }

    public void invalidatePluginsChangeStamp() {
        this.changeStampIsValid = false;
        this.pluginsChangeStampIsValid = false;
    }

    private void saveAsXML(File platformXML) {
        try {
            DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            doc.appendChild(doc.createProcessingInstruction("date", "\"" + new Date().toString() + "\""));
            Element configElement = doc.createElement(CFG);
            doc.appendChild(configElement);
            configElement.setAttribute("version", VERSION);
            if (this.transientConfig) {
                configElement.setAttribute(CFG_TRANSIENT, "true");
            }
            configElement.setAttribute(CFG_STAMP, Long.toString(this.getChangeStamp()));
            configElement.setAttribute(CFG_FEATURE_STAMP, Long.toString(this.getFeaturesChangeStamp()));
            configElement.setAttribute(CFG_PLUGIN_STAMP, Long.toString(this.getPluginsChangeStamp()));
            String[] ids = this.getBootstrapPluginIdentifiers();
            int i = 0;
            while (i < ids.length) {
                String location = (String)this.bootPlugins.get(ids[i]);
                if (location != null) {
                    Element bootPlugin = doc.createElement(CFG_BOOT_PLUGIN);
                    bootPlugin.setNodeValue(location);
                    configElement.appendChild(bootPlugin);
                }
                ++i;
            }
            configElement.setAttribute("feature.default.id", this.defaultFeature);
            IPlatformConfiguration.IFeatureEntry[] feats = this.getConfiguredFeatureEntries();
            int i2 = 0;
            while (i2 < feats.length) {
                this.saveFeatureAsXML(feats[i2], configElement);
                ++i2;
            }
            SiteEntry[] list = this.sites.values().toArray(new SiteEntry[0]);
            int i3 = 0;
            while (i3 < list.length) {
                this.saveSiteAsXML(list[i3], configElement);
                ++i3;
            }
            FileOutputStream stream = new FileOutputStream(platformXML);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
            stream.close();
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveSiteAsXML(SiteEntry site, Element parent) {
        Document doc = parent.getOwnerDocument();
        Element siteElement = doc.createElement(CFG_SITE);
        parent.appendChild(siteElement);
        siteElement.setAttribute(CFG_URL, site.getURL().toString());
        siteElement.setAttribute(CFG_STAMP, Long.toString(site.getChangeStamp()));
        siteElement.setAttribute(CFG_FEATURE_STAMP, Long.toString(site.getFeaturesChangeStamp()));
        siteElement.setAttribute(CFG_PLUGIN_STAMP, Long.toString(site.getPluginsChangeStamp()));
        siteElement.setAttribute(CFG_UPDATEABLE, site.isUpdateable() ? "true" : "false");
        if (site.isExternallyLinkedSite()) {
            siteElement.setAttribute(CFG_LINK_FILE, site.getLinkFileName().trim().replace(File.separatorChar, '/'));
        }
        int type = site.getSitePolicy().getType();
        String typeString = CFG_POLICY_TYPE_UNKNOWN;
        try {
            typeString = CFG_POLICY_TYPE[type];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        siteElement.setAttribute(CFG_POLICY, typeString);
        String[] list = site.getSitePolicy().getList();
        int i = 0;
        while (i < list.length) {
            Element listElement = doc.createElement(CFG_LIST);
            listElement.setNodeValue(list[i]);
            siteElement.appendChild(listElement);
            ++i;
        }
    }

    private void saveFeatureAsXML(IPlatformConfiguration.IFeatureEntry feature, Element parent) {
        Document doc = parent.getOwnerDocument();
        Element featureElement = doc.createElement(CFG_FEATURE_ENTRY);
        parent.appendChild(featureElement);
        if (feature.getFeatureIdentifier() != null) {
            featureElement.setAttribute(CFG_FEATURE_ENTRY_ID, feature.getFeatureIdentifier());
        }
        if (feature.canBePrimary()) {
            featureElement.setAttribute(CFG_FEATURE_ENTRY_PRIMARY, "true");
        }
        if (feature.getFeatureVersion() != null) {
            featureElement.setAttribute("version", feature.getFeatureVersion());
        }
        if (feature.getFeatureVersion() != null && !feature.getFeatureVersion().equals(feature.getFeaturePluginVersion())) {
            featureElement.setAttribute(CFG_FEATURE_ENTRY_PLUGIN_VERSION, feature.getFeaturePluginVersion());
        }
        if (feature.getFeatureIdentifier() != null && !feature.getFeatureIdentifier().equals(feature.getFeaturePluginIdentifier())) {
            featureElement.setAttribute(CFG_FEATURE_ENTRY_PLUGIN_IDENTIFIER, feature.getFeaturePluginIdentifier());
        }
        if (feature.getFeatureApplication() != null) {
            featureElement.setAttribute(CFG_FEATURE_ENTRY_APPLICATION, feature.getFeatureApplication());
        }
        URL[] roots = feature.getFeatureRootURLs();
        int i = 0;
        while (i < roots.length) {
            Element rootElement = doc.createElement(CFG_FEATURE_ENTRY_ROOT);
            rootElement.setNodeValue(roots[i].toExternalForm());
            featureElement.appendChild(rootElement);
            ++i;
        }
    }
}

