/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.internal.configurator.FeatureParser;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.PluginParser;
import org.eclipse.update.internal.configurator.SiteEntry;
import org.eclipse.update.internal.configurator.Utils;
import org.xml.sax.SAXException;

public class InstalledSiteParser {
    private SiteEntry site;
    private static FeatureParser featureParser = new FeatureParser();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IPlatformConfiguration.ISiteEntry parse(URL url) throws CoreException {
        InputStream siteStream = null;
        try {
            String path = url.getFile();
            File siteLocation = new File(path);
            if (!siteLocation.isDirectory()) throw Utils.newCoreException(Messages.getString("InstalledSiteParser.DirectoryDoesNotExist", siteLocation.getAbsolutePath()), null);
            if (!siteLocation.exists()) {
                throw Utils.newCoreException(Messages.getString("InstalledSiteParser.DirectoryDoesNotExist", siteLocation.getAbsolutePath()), null);
            }
            this.site = this.parseSite(siteLocation);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (siteStream == null) throw throwable;
                siteStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException iOException) {
            return this.site;
        }
        if (siteStream == null) return this.site;
        siteStream.close();
        return this.site;
    }

    private SiteEntry parseSite(File directory) throws CoreException {
        this.site = new SiteEntry();
        this.parseInstalledFeatures(directory);
        this.parseInstalledPlugins(directory);
        return this.site;
    }

    private void parseInstalledFeatures(File directory) throws CoreException {
        File featuresDir = new File(directory, "features");
        if (featuresDir.exists()) {
            File[] dirs = featuresDir.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    boolean valid;
                    boolean bl = valid = f.isDirectory() && new File(f, "feature.xml").exists();
                    if (!valid) {
                        System.out.println("Unable to find feature.xml in directory:" + f.getAbsolutePath());
                    }
                    return valid;
                }
            });
            try {
                int index = 0;
                while (index < dirs.length) {
                    File featureXML = new File(dirs[index], "feature.xml");
                    URL featureURL = featureXML.toURL();
                    IPlatformConfiguration.IFeatureEntry featureEntry = featureParser.parse(featureURL);
                    this.site.addFeatureEntry(featureEntry);
                    ++index;
                }
            }
            catch (MalformedURLException e) {
                throw Utils.newCoreException(Messages.getString("InstalledSiteParser.UnableToCreateURLForFile", featuresDir.getAbsolutePath()), e);
            }
        }
    }

    private void parseInstalledPlugins(File directory) throws CoreException {
        File pluginPath = new File(directory, "plugins");
        File pluginFile = null;
        try {
            if (pluginPath.exists()) {
                File[] files = pluginPath.listFiles();
                PluginParser parser = new PluginParser();
                int i = 0;
                while (i < files.length) {
                    if (files[i].isDirectory()) {
                        pluginFile = new File(files[i], "plugin.xml");
                        if (!pluginFile.exists()) {
                            pluginFile = new File(files[i], "fragment.xml");
                        }
                        if (pluginFile != null && pluginFile.exists() && !pluginFile.isDirectory()) {
                            PluginEntry entry = parser.parse(new FileInputStream(pluginFile));
                            this.site.addPluginEntry(entry);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            String pluginFileString = pluginFile == null ? null : pluginFile.getAbsolutePath();
            throw Utils.newCoreException(Messages.getString("InstalledSiteParser.ErrorAccessing", pluginFileString), e);
        }
        catch (SAXException e) {
            String pluginFileString = pluginFile == null ? null : pluginFile.getAbsolutePath();
            throw Utils.newCoreException(Messages.getString("InstalledSiteParser.ErrorParsingFile", pluginFileString), e);
        }
    }
}

