/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FeatureParser
extends DefaultHandler {
    private SAXParser parser;
    private FeatureEntry feature;
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    public FeatureParser() {
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            System.out.println(e);
        }
        catch (SAXException e) {
            System.out.println(e);
        }
    }

    public IPlatformConfiguration.IFeatureEntry parse(URL featureURL) {
        try {
            InputStream in = featureURL.openStream();
            this.parser.parse(new InputSource(in), (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return this.feature;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Utils.debug("Start Element: uri:" + uri + " local Name:" + localName + " qName:" + qName);
        if ("feature".equals(localName)) {
            this.processFeature(attributes);
            throw new SAXException("");
        }
    }

    private void processFeature(Attributes attributes) {
        String id = attributes.getValue("id");
        String ver = attributes.getValue("version");
        if (id == null || id.trim().equals("") || ver == null || ver.trim().equals("")) {
            System.out.println(Messages.getString("FeatureParser.IdOrVersionInvalid", new String[]{id, ver}));
        } else {
            String primary = attributes.getValue("primary");
            boolean isPrimary = "true".equals(primary);
            String application = attributes.getValue("application");
            String plugin = attributes.getValue("plugin");
            this.feature = new FeatureEntry(id, ver, plugin, "", isPrimary, application, null);
            Utils.debug("End process DefaultFeature tag: id:" + id + " ver:" + ver);
        }
    }
}

