/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPlatform;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.PlatformConfigurationFactory;
import org.eclipse.update.internal.configurator.Utils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigurationActivator
implements BundleActivator {
    public static String PI_CONFIGURATOR = "org.eclipse.update.configurator";
    public static String OPTION_DEBUG = String.valueOf(PI_CONFIGURATOR) + "/debug";
    public static boolean DEBUG = false;
    private static boolean isWindows = System.getProperty("os.name").startsWith("Win");
    private static BundleContext context;
    private ServiceTracker platformTracker;
    private ServiceRegistration configurationFactorySR;
    private String[] allArgs;
    private Set ignore;
    private BundleListener reconcilerListener;
    private IPlatform platform;
    private PlatformConfiguration configuration;
    private String configArea;
    private long lastTimeStamp;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public void start(BundleContext ctx) throws Exception {
        context = ctx;
        this.obtainArgs();
        this.initialize();
        String application = this.configuration.getApplicationIdentifier();
        if ("org.eclipse.ui.workbench".equals(System.getProperties().get("eclipse.application"))) {
            System.setProperty("eclipse.application", "org.eclipse.ui.ide.workbench");
        }
        if (this.lastTimeStamp == this.configuration.getChangeStamp() && !application.equals("org.eclipse.update.core.reconciler") && System.getProperties().get("osgi.dev") == null) {
            Utils.debug("Same last time stamp *****");
            if (System.getProperty("eclipse.application") == null) {
                Utils.debug("no eclipse.application, setting it and returning");
                System.setProperty("eclipse.application", application);
                return;
            }
        }
        this.loadOptions();
        if (DEBUG) {
            System.out.println("Starting update configurator...");
        }
        this.computeIgnoredBundles();
        this.installBundles();
    }

    private void initialize() throws Exception {
        this.platform = this.acquirePlatform();
        if (this.platform == null) {
            throw new Exception("Can not start");
        }
        URL installURL = this.platform.getInstallURL();
        this.configArea = this.platform.getConfigurationMetadataLocation().toOSString();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.update.configurator.IPlatformConfigurationFactory;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.configurationFactorySR = context.registerService(clazz.getName(), (Object)new PlatformConfigurationFactory(), null);
        this.configuration = this.getPlatformConfiguration(this.allArgs, installURL, this.configArea);
        try {
            DataInputStream stream = new DataInputStream(new FileInputStream(String.valueOf(this.configArea) + "/last.config.stamp"));
            this.lastTimeStamp = stream.readLong();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.lastTimeStamp = this.configuration.getChangeStamp() - 1L;
        }
        catch (IOException iOException) {
            this.lastTimeStamp = this.configuration.getChangeStamp() - 1L;
        }
    }

    private void computeIgnoredBundles() {
        String ignoreList = System.getProperty("eclipse.ignore", "org.eclipse.osgi,org.eclipse.core.boot,org.eclipse.core.runtime.adaptor");
        this.ignore = new HashSet();
        StringTokenizer tokenizer = new StringTokenizer(ignoreList, ",");
        while (tokenizer.hasMoreTokens()) {
            this.ignore.add(tokenizer.nextToken().trim());
        }
    }

    private void obtainArgs() {
        ServiceReference envInfoSR;
        EnvironmentInfo envInfo = null;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.osgi.service.environment.EnvironmentInfo;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((envInfoSR = context.getServiceReference(clazz.getName())) != null) {
            envInfo = (EnvironmentInfo)context.getService(envInfoSR);
        }
        if (envInfo == null) {
            throw new IllegalStateException();
        }
        this.allArgs = envInfo.getAllArgs();
        context.ungetService(envInfoSR);
    }

    public void stop(BundleContext ctx) throws Exception {
        try {
            PlatformConfiguration.shutdown();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.platform = null;
        this.releasePlatform();
        this.configurationFactorySR.unregister();
    }

    private void writePlatformConfigurationTimeStamp() {
        try {
            DataOutputStream stream = new DataOutputStream(new FileOutputStream(String.valueOf(this.configArea) + "/last.config.stamp"));
            stream.writeLong(this.configuration.getChangeStamp());
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getLocalizedMessage());
        }
        catch (IOException e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    private void releasePlatform() {
        if (this.platformTracker == null) {
            return;
        }
        this.platformTracker.close();
        this.platformTracker = null;
    }

    private IPlatform acquirePlatform() {
        if (this.platformTracker == null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("[Lorg.eclipse.core.runtime.IPlatform;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.platformTracker = new ServiceTracker(context, clazz.getName(), null);
            this.platformTracker.open();
        }
        IPlatform result = (IPlatform)this.platformTracker.getService();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void installBundles() {
        Utils.debug("Installing bundles...");
        Class<?> clazz = class$3;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("[Lorg.osgi.service.startlevel.StartLevel;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$3 = clazz2;
        }
        ServiceReference reference = context.getServiceReference(clazz.getName());
        StartLevel start = null;
        if (reference != null) {
            start = (StartLevel)context.getService(reference);
        }
        try {
            try {
                Bundle[] cachedBundles = context.getBundles();
                URL[] plugins = this.configuration.getPluginPath();
                Bundle[] bundlesToUninstall = this.getBundlesToUninstall(cachedBundles, plugins);
                int i = 0;
                while (true) {
                    if (i >= bundlesToUninstall.length) break;
                    try {
                        if (DEBUG) {
                            Utils.debug("Uninstalling " + bundlesToUninstall[i].getLocation());
                        }
                        bundlesToUninstall[i].uninstall();
                    }
                    catch (Exception exception) {
                        System.err.println("Could not uninstall unused bundle " + bundlesToUninstall[i].getLocation());
                    }
                    ++i;
                }
                ArrayList<Bundle> installed = new ArrayList<Bundle>(plugins.length);
                int i2 = 0;
                while (true) {
                    block19: {
                        block20: {
                            if (i2 < plugins.length) break block20;
                            context.ungetService(reference);
                            this.refreshPackages(installed.toArray(new Bundle[installed.size()]));
                            if (System.getProperty("eclipse.application") == null || System.getProperty("eclipse.application").equals("org.eclipse.update.core.reconciler")) {
                                System.setProperty("eclipse.application", this.configuration.getApplicationIdentifier());
                            }
                            break;
                        }
                        String location = plugins[i2].toExternalForm();
                        try {
                            location = "reference:" + location.substring(0, location.lastIndexOf(47));
                            if (this.isInstalled(location)) break block19;
                            if (DEBUG) {
                                Utils.debug("Installing " + location);
                            }
                            Bundle target = context.installBundle(location);
                            installed.add(target);
                            if (start != null) {
                                start.setBundleStartLevel(target, 4);
                            }
                        }
                        catch (Exception e) {
                            if (location.indexOf("org.eclipse.core.boot") != -1 || location.indexOf("org.eclipse.osgi") != -1) break block19;
                            System.err.println("Ignoring bundle at: " + location);
                            System.err.println(e.getMessage());
                        }
                    }
                    ++i2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            this.releasePlatform();
            this.writePlatformConfigurationTimeStamp();
            throw throwable;
        }
        {
            Object var10_15 = null;
            this.releasePlatform();
            this.writePlatformConfigurationTimeStamp();
            return;
        }
    }

    private Bundle[] getBundlesToUninstall(Bundle[] cachedBundles, URL[] newPlugins) {
        ArrayList<Bundle> bundlesToUninstall = new ArrayList<Bundle>();
        int i = 0;
        while (i < cachedBundles.length) {
            if (cachedBundles[i].getBundleId() != 0L) {
                String location1 = cachedBundles[i].getLocation();
                boolean found = false;
                int j = 0;
                while (!found && j < newPlugins.length) {
                    String location2 = newPlugins[j].toExternalForm();
                    location2 = "reference:" + location2.substring(0, location2.lastIndexOf(47));
                    if (isWindows) {
                        if (location2.equalsIgnoreCase(location1)) {
                            found = true;
                        } else if ((String.valueOf(location2) + '/').equalsIgnoreCase(location1)) {
                            found = true;
                        }
                    } else if (location2.equals(location1)) {
                        found = true;
                    } else if ((String.valueOf(location2) + '/').equals(location1)) {
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    bundlesToUninstall.add(cachedBundles[i]);
                }
            }
            ++i;
        }
        return bundlesToUninstall.toArray(new Bundle[bundlesToUninstall.size()]);
    }

    private BundleListener reconcilerListener() {
        return new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                String buid = event.getBundle().getGlobalName();
                if (event.getType() == 4 && buid != null && buid.equals("org.eclipse.update.core")) {
                    ConfigurationActivator.this.runPostReconciler();
                }
            }
        };
    }

    private void runPostReconciler() {
        Runnable postReconciler = new Runnable(){

            public void run() {
                try {
                    Bundle apprunner = context.getBundles("org.eclipse.core.applicationrunner")[0];
                    apprunner.stop();
                    context.removeBundleListener(ConfigurationActivator.this.reconcilerListener);
                    try {
                        PlatformConfiguration.shutdown();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ConfigurationActivator.this.installBundles();
                    apprunner.start();
                }
                catch (BundleException be) {
                    be.printStackTrace();
                }
            }
        };
        new Thread(postReconciler, "Post reconciler").start();
    }

    private PlatformConfiguration getPlatformConfiguration(String[] args, URL installURL, String configPath) {
        block3: {
            try {
                PlatformConfiguration.startup(args, null, installURL, configPath);
            }
            catch (Exception e) {
                if (this.platformTracker == null) break block3;
                String message = e.getMessage();
                if (message == null) {
                    message = "";
                }
                Status status = new Status(4, "org.eclipse.core.runtime", 0, message, (Throwable)e);
                ((IPlatform)this.platformTracker.getService()).getLog(context.getBundle()).log((IStatus)status);
            }
        }
        return PlatformConfiguration.getCurrent();
    }

    private void refreshPackages(Bundle[] bundles) {
        if (bundles.length == 0) {
            return;
        }
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("[Lorg.osgi.service.packageadmin.PackageAdmin;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference packageAdminRef = context.getServiceReference(clazz.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminRef != null && (packageAdmin = (PackageAdmin)context.getService(packageAdminRef)) == null) {
            return;
        }
        final Object semaphore = new Object();
        FrameworkListener listener = new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 4) {
                    Object object = semaphore;
                    synchronized (object) {
                        semaphore.notifyAll();
                    }
                }
            }
        };
        context.addFrameworkListener(listener);
        packageAdmin.refreshPackages(bundles);
        Object object = semaphore;
        synchronized (object) {
            try {
                semaphore.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        context.removeFrameworkListener(listener);
        context.ungetService(packageAdminRef);
    }

    private boolean isInstalled(String location) {
        Bundle[] installed = context.getBundles();
        int i = 0;
        while (i < installed.length) {
            Bundle bundle = installed[i];
            String bundleLocation = bundle.getLocation();
            if (isWindows) {
                if (location.equalsIgnoreCase(bundleLocation)) {
                    return true;
                }
                if ((String.valueOf(location) + '/').equalsIgnoreCase(bundleLocation)) {
                    return true;
                }
            } else {
                if (location.equals(bundleLocation)) {
                    return true;
                }
                if ((String.valueOf(location) + '/').equals(bundleLocation)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadOptions() {
        ServiceReference reference;
        DebugOptions service = null;
        Class<?> clazz = class$5;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("[Lorg.eclipse.osgi.service.debug.DebugOptions;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$5 = clazz2;
        }
        if ((reference = context.getServiceReference(clazz.getName())) != null) {
            service = (DebugOptions)context.getService(reference);
        }
        if (service == null) {
            return;
        }
        try {
            DEBUG = service.getBooleanOption(OPTION_DEBUG, false);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            context.ungetService(reference);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        context.ungetService(reference);
    }

    public static BundleContext getBundleContext() {
        return context;
    }
}

