/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.configurator;

import org.eclipse.core.runtime.Platform;
import org.eclipse.update.internal.configurator.ConfigurationActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class FragmentEntry {
    private static FragmentEntry[] noFragments = new FragmentEntry[0];
    private String pluginId;
    private String pluginVersion;
    private String name;
    private String location;
    private boolean isFragment = false;

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPluginIdentifier() {
        return this.pluginId;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public boolean isFragment() {
        return this.isFragment;
    }

    void setPluginIdentifier(String pluginId) {
        this.pluginId = pluginId;
    }

    void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public void isFragment(boolean isFragment) {
        this.isFragment = isFragment;
    }

    public String toString() {
        String msg = this.getPluginIdentifier() != null ? this.getPluginIdentifier().toString() : "";
        msg = String.valueOf(msg) + (this.getPluginVersion() != null ? " " + this.getPluginVersion().toString() : "");
        msg = String.valueOf(msg) + (this.isFragment() ? " fragment" : " plugin");
        return msg;
    }

    public static FragmentEntry[] getFragments(String id) {
        BundleContext context = ConfigurationActivator.getBundleContext();
        Bundle[] bundles = context.getBundles(id);
        if (bundles != null && bundles.length > 0) {
            Bundle[] fragmentBundles = bundles[0].getFragments();
            if (fragmentBundles != null) {
                FragmentEntry[] fragments = new FragmentEntry[fragmentBundles.length];
                int i = 0;
                while (i < fragments.length) {
                    fragments[i] = new FragmentEntry();
                    fragments[i].isFragment = true;
                    fragments[i].location = fragmentBundles[i].getLocation();
                    fragments[i].pluginId = (String)fragmentBundles[i].getHeaders().get("Bundle-GlobalName");
                    fragments[i].pluginVersion = (String)fragmentBundles[i].getHeaders().get("Bundle-Version");
                    fragments[i].name = Platform.getResourceString((Bundle)fragmentBundles[i], (String)((String)fragmentBundles[i].getHeaders().get("Bundle-Version")));
                    ++i;
                }
                return fragments;
            }
            return noFragments;
        }
        return noFragments;
    }
}

