/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Vector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;

public class BooleanQuery
extends Query {
    private static int maxClauseCount = 1024;
    private Vector clauses = new Vector();

    public static int getMaxClauseCount() {
        return maxClauseCount;
    }

    public static void setMaxClauseCount(int maxClauseCount) {
        BooleanQuery.maxClauseCount = maxClauseCount;
    }

    public void add(Query query, boolean required, boolean prohibited) {
        this.add(new BooleanClause(query, required, prohibited));
    }

    public void add(BooleanClause clause) {
        if (this.clauses.size() >= maxClauseCount) {
            throw new TooManyClauses();
        }
        this.clauses.addElement(clause);
    }

    public BooleanClause[] getClauses() {
        return this.clauses.toArray(new BooleanClause[0]);
    }

    protected Weight createWeight(Searcher searcher) {
        return new BooleanWeight(searcher);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.clauses.size() == 1) {
            BooleanClause c = (BooleanClause)this.clauses.elementAt(0);
            if (!c.prohibited) {
                Query query = c.query;
                if (this.getBoost() != 1.0f) {
                    query = (Query)query.clone();
                    query.setBoost(this.getBoost() * query.getBoost());
                }
                return query;
            }
        }
        BooleanQuery clone = null;
        for (int i = 0; i < this.clauses.size(); ++i) {
            BooleanClause c = (BooleanClause)this.clauses.elementAt(i);
            Query query = c.query.rewrite(reader);
            if (query == c.query) continue;
            if (clone == null) {
                clone = (BooleanQuery)this.clone();
            }
            clone.clauses.setElementAt(new BooleanClause(query, c.required, c.prohibited), i);
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    public Object clone() {
        BooleanQuery clone = (BooleanQuery)super.clone();
        clone.clauses = (Vector)this.clauses.clone();
        return clone;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if ((double)this.getBoost() != 1.0) {
            buffer.append("(");
        }
        for (int i = 0; i < this.clauses.size(); ++i) {
            BooleanClause c = (BooleanClause)this.clauses.elementAt(i);
            if (c.prohibited) {
                buffer.append("-");
            } else if (c.required) {
                buffer.append("+");
            }
            Query subQuery = c.query;
            if (subQuery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(c.query.toString(field));
                buffer.append(")");
            } else {
                buffer.append(c.query.toString(field));
            }
            if (i == this.clauses.size() - 1) continue;
            buffer.append(" ");
        }
        if ((double)this.getBoost() != 1.0) {
            buffer.append(")^");
            buffer.append(this.getBoost());
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BooleanQuery)) {
            return false;
        }
        BooleanQuery other = (BooleanQuery)o;
        return this.getBoost() == other.getBoost() && this.clauses.equals(other.clauses);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.clauses.hashCode();
    }

    private class BooleanWeight
    implements Weight {
        private Searcher searcher;
        private float norm;
        private Vector weights = new Vector();

        public BooleanWeight(Searcher searcher) {
            this.searcher = searcher;
            for (int i = 0; i < BooleanQuery.this.clauses.size(); ++i) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                this.weights.add(c.query.createWeight(searcher));
            }
        }

        public Query getQuery() {
            return BooleanQuery.this;
        }

        public float getValue() {
            return BooleanQuery.this.getBoost();
        }

        public float sumOfSquaredWeights() throws IOException {
            float sum = 0.0f;
            for (int i = 0; i < this.weights.size(); ++i) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                Weight w = (Weight)this.weights.elementAt(i);
                if (c.prohibited) continue;
                sum += w.sumOfSquaredWeights();
            }
            return sum *= BooleanQuery.this.getBoost() * BooleanQuery.this.getBoost();
        }

        public void normalize(float norm) {
            norm *= BooleanQuery.this.getBoost();
            for (int i = 0; i < this.weights.size(); ++i) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                Weight w = (Weight)this.weights.elementAt(i);
                if (c.prohibited) continue;
                w.normalize(norm);
            }
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            BooleanScorer result = new BooleanScorer(this.searcher.getSimilarity());
            for (int i = 0; i < this.weights.size(); ++i) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                Weight w = (Weight)this.weights.elementAt(i);
                Scorer subScorer = w.scorer(reader);
                if (subScorer != null) {
                    result.add(subScorer, c.required, c.prohibited);
                    continue;
                }
                if (!c.required) continue;
                return null;
            }
            return result;
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            float coordFactor;
            Explanation sumExpl = new Explanation();
            sumExpl.setDescription("sum of:");
            int coord = 0;
            int maxCoord = 0;
            float sum = 0.0f;
            for (int i = 0; i < this.weights.size(); ++i) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                Weight w = (Weight)this.weights.elementAt(i);
                Explanation e = w.explain(reader, doc);
                if (!c.prohibited) {
                    ++maxCoord;
                }
                if (e.getValue() > 0.0f) {
                    if (!c.prohibited) {
                        sumExpl.addDetail(e);
                        sum += e.getValue();
                        ++coord;
                        continue;
                    }
                    return new Explanation(0.0f, "match prohibited");
                }
                if (!c.required) continue;
                return new Explanation(0.0f, "match required");
            }
            sumExpl.setValue(sum);
            if (coord == 1) {
                sumExpl = sumExpl.getDetails()[0];
            }
            if ((coordFactor = this.searcher.getSimilarity().coord(coord, maxCoord)) == 1.0f) {
                return sumExpl;
            }
            Explanation result = new Explanation();
            result.setDescription("product of:");
            result.addDetail(sumExpl);
            result.addDetail(new Explanation(coordFactor, "coord(" + coord + "/" + maxCoord + ")"));
            result.setValue(sum * coordFactor);
            return result;
        }
    }

    public static class TooManyClauses
    extends RuntimeException {
    }
}

