/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DocumentWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.OutputStream;
import org.apache.lucene.store.RAMDirectory;

public class IndexWriter {
    public static long WRITE_LOCK_TIMEOUT = 1000L;
    public static long COMMIT_LOCK_TIMEOUT = 10000L;
    public static final String WRITE_LOCK_NAME = "write.lock";
    public static final String COMMIT_LOCK_NAME = "commit.lock";
    private Directory directory;
    private Analyzer analyzer;
    private Similarity similarity = Similarity.getDefault();
    private SegmentInfos segmentInfos = new SegmentInfos();
    private final Directory ramDirectory = new RAMDirectory();
    private Lock writeLock;
    private boolean useCompoundFile = false;
    public int maxFieldLength = 10000;
    public int mergeFactor = 10;
    public int maxMergeDocs = Integer.MAX_VALUE;
    public PrintStream infoStream = null;

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public void setUseCompoundFile(boolean value) {
        this.useCompoundFile = value;
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public IndexWriter(String path, Analyzer a, boolean create) throws IOException {
        this(FSDirectory.getDirectory(path, create), a, create);
    }

    public IndexWriter(File path, Analyzer a, boolean create) throws IOException {
        this(FSDirectory.getDirectory(path, create), a, create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexWriter(Directory d, Analyzer a, final boolean create) throws IOException {
        this.directory = d;
        this.analyzer = a;
        Lock writeLock = this.directory.makeLock(WRITE_LOCK_NAME);
        if (!writeLock.obtain(WRITE_LOCK_TIMEOUT)) {
            throw new IOException("Index locked for write: " + writeLock);
        }
        this.writeLock = writeLock;
        Directory directory = this.directory;
        synchronized (directory) {
            new Lock.With(this.directory.makeLock(COMMIT_LOCK_NAME), COMMIT_LOCK_TIMEOUT){

                public Object doBody() throws IOException {
                    if (create) {
                        IndexWriter.this.segmentInfos.write(IndexWriter.this.directory);
                    } else {
                        IndexWriter.this.segmentInfos.read(IndexWriter.this.directory);
                    }
                    return null;
                }
            }.run();
        }
    }

    public synchronized void close() throws IOException {
        this.flushRamSegments();
        this.ramDirectory.close();
        this.writeLock.release();
        this.writeLock = null;
        this.directory.close();
    }

    protected void finalize() throws IOException {
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public synchronized int docCount() {
        int count = 0;
        for (int i = 0; i < this.segmentInfos.size(); ++i) {
            SegmentInfo si = this.segmentInfos.info(i);
            count += si.docCount;
        }
        return count;
    }

    public void addDocument(Document doc) throws IOException {
        this.addDocument(doc, this.analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(Document doc, Analyzer analyzer) throws IOException {
        DocumentWriter dw = new DocumentWriter(this.ramDirectory, analyzer, this.similarity, this.maxFieldLength);
        String segmentName = this.newSegmentName();
        dw.addDocument(segmentName, doc);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.segmentInfos.addElement(new SegmentInfo(segmentName, 1, this.ramDirectory));
            this.maybeMergeSegments();
        }
    }

    private final synchronized String newSegmentName() {
        return "_" + Integer.toString(this.segmentInfos.counter++, 36);
    }

    public synchronized void optimize() throws IOException {
        this.flushRamSegments();
        while (this.segmentInfos.size() > 1 || this.segmentInfos.size() == 1 && (SegmentReader.hasDeletions(this.segmentInfos.info(0)) || this.useCompoundFile && !SegmentReader.usesCompoundFile(this.segmentInfos.info(0)) || this.segmentInfos.info((int)0).dir != this.directory)) {
            int minSegment = this.segmentInfos.size() - this.mergeFactor;
            this.mergeSegments(minSegment < 0 ? 0 : minSegment);
        }
    }

    public synchronized void addIndexes(Directory[] dirs) throws IOException {
        this.optimize();
        for (int i = 0; i < dirs.length; ++i) {
            SegmentInfos sis = new SegmentInfos();
            sis.read(dirs[i]);
            for (int j = 0; j < sis.size(); ++j) {
                this.segmentInfos.addElement(sis.info(j));
            }
        }
        this.optimize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addIndexes(IndexReader[] readers) throws IOException {
        this.optimize();
        String mergedName = this.newSegmentName();
        SegmentMerger merger = new SegmentMerger(this.directory, mergedName, false);
        if (this.segmentInfos.size() == 1) {
            merger.add(new SegmentReader(this.segmentInfos.info(0)));
        }
        for (int i = 0; i < readers.length; ++i) {
            merger.add(readers[i]);
        }
        int docCount = merger.merge();
        this.segmentInfos.setSize(0);
        this.segmentInfos.addElement(new SegmentInfo(mergedName, docCount, this.directory));
        Directory directory = this.directory;
        synchronized (directory) {
            new Lock.With(this.directory.makeLock(COMMIT_LOCK_NAME)){

                public Object doBody() throws IOException {
                    IndexWriter.this.segmentInfos.write(IndexWriter.this.directory);
                    return null;
                }
            }.run();
        }
    }

    private final void flushRamSegments() throws IOException {
        int minSegment;
        int docCount = 0;
        for (minSegment = this.segmentInfos.size() - 1; minSegment >= 0 && this.segmentInfos.info((int)minSegment).dir == this.ramDirectory; --minSegment) {
            docCount += this.segmentInfos.info((int)minSegment).docCount;
        }
        if (minSegment < 0 || docCount + this.segmentInfos.info((int)minSegment).docCount > this.mergeFactor || this.segmentInfos.info((int)(this.segmentInfos.size() - 1)).dir != this.ramDirectory) {
            ++minSegment;
        }
        if (minSegment >= this.segmentInfos.size()) {
            return;
        }
        this.mergeSegments(minSegment);
    }

    private final void maybeMergeSegments() throws IOException {
        for (long targetMergeDocs = (long)this.mergeFactor; targetMergeDocs <= (long)this.maxMergeDocs; targetMergeDocs *= (long)this.mergeFactor) {
            int minSegment = this.segmentInfos.size();
            int mergeDocs = 0;
            while (--minSegment >= 0) {
                SegmentInfo si = this.segmentInfos.info(minSegment);
                if ((long)si.docCount >= targetMergeDocs) break;
                mergeDocs += si.docCount;
            }
            if ((long)mergeDocs < targetMergeDocs) break;
            this.mergeSegments(minSegment + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeSegments(int minSegment) throws IOException {
        String mergedName = this.newSegmentName();
        int mergedDocCount = 0;
        if (this.infoStream != null) {
            this.infoStream.print("merging segments");
        }
        SegmentMerger merger = new SegmentMerger(this.directory, mergedName, this.useCompoundFile);
        final Vector<SegmentReader> segmentsToDelete = new Vector<SegmentReader>();
        for (int i = minSegment; i < this.segmentInfos.size(); ++i) {
            SegmentInfo si = this.segmentInfos.info(i);
            if (this.infoStream != null) {
                this.infoStream.print(" " + si.name + " (" + si.docCount + " docs)");
            }
            SegmentReader reader = new SegmentReader(si);
            merger.add(reader);
            if (reader.directory() == this.directory || reader.directory() == this.ramDirectory) {
                segmentsToDelete.addElement(reader);
            }
            mergedDocCount += ((IndexReader)reader).numDocs();
        }
        if (this.infoStream != null) {
            this.infoStream.println();
            this.infoStream.println(" into " + mergedName + " (" + mergedDocCount + " docs)");
        }
        merger.merge();
        this.segmentInfos.setSize(minSegment);
        this.segmentInfos.addElement(new SegmentInfo(mergedName, mergedDocCount, this.directory));
        Directory directory = this.directory;
        synchronized (directory) {
            new Lock.With(this.directory.makeLock(COMMIT_LOCK_NAME), COMMIT_LOCK_TIMEOUT){

                public Object doBody() throws IOException {
                    IndexWriter.this.segmentInfos.write(IndexWriter.this.directory);
                    IndexWriter.this.deleteSegments(segmentsToDelete);
                    return null;
                }
            }.run();
        }
    }

    private final void deleteSegments(Vector segments) throws IOException {
        Vector deletable = new Vector();
        this.deleteFiles(this.readDeleteableFiles(), deletable);
        for (int i = 0; i < segments.size(); ++i) {
            SegmentReader reader = (SegmentReader)segments.elementAt(i);
            if (reader.directory() == this.directory) {
                this.deleteFiles(reader.files(), deletable);
                continue;
            }
            this.deleteFiles(reader.files(), reader.directory());
        }
        this.writeDeleteableFiles(deletable);
    }

    private final void deleteFiles(Vector files, Directory directory) throws IOException {
        for (int i = 0; i < files.size(); ++i) {
            directory.deleteFile((String)files.elementAt(i));
        }
    }

    private final void deleteFiles(Vector files, Vector deletable) throws IOException {
        for (int i = 0; i < files.size(); ++i) {
            String file = (String)files.elementAt(i);
            try {
                this.directory.deleteFile(file);
                continue;
            }
            catch (IOException e) {
                if (!this.directory.fileExists(file)) continue;
                if (this.infoStream != null) {
                    this.infoStream.println(e.getMessage() + "; Will re-try later.");
                }
                deletable.addElement(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Vector readDeleteableFiles() throws IOException {
        Vector<String> result = new Vector<String>();
        if (!this.directory.fileExists("deletable")) {
            return result;
        }
        InputStream input = this.directory.openFile("deletable");
        try {
            for (int i = input.readInt(); i > 0; --i) {
                result.addElement(input.readString());
            }
        }
        finally {
            input.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeDeleteableFiles(Vector files) throws IOException {
        OutputStream output = this.directory.createFile("deleteable.new");
        try {
            output.writeInt(files.size());
            for (int i = 0; i < files.size(); ++i) {
                output.writeString((String)files.elementAt(i));
            }
        }
        finally {
            output.close();
        }
        this.directory.renameFile("deleteable.new", "deletable");
    }
}

