/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.scheduler.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.update.internal.scheduler.UpdateScheduler;

public class AutomaticUpdatesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button enabledCheck;
    private Button onStartupRadio;
    private Button onScheduleRadio;
    private Combo dayCombo;
    private Combo hourCombo;
    private Button searchOnlyRadio;
    private Button searchAndDownloadRadio;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        this.enabledCheck = new Button(container, 32);
        this.enabledCheck.setText("Automatically &find new updates and notify me");
        this.createSpacer(container, 1);
        Group group = new Group(container, 0);
        group.setText("Update &Schedule");
        layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        this.onStartupRadio = new Button((Composite)group, 16);
        this.onStartupRadio.setText("Look for updates each time platform is started");
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.onStartupRadio.setLayoutData((Object)gd);
        this.onStartupRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        });
        this.onScheduleRadio = new Button((Composite)group, 16);
        this.onScheduleRadio.setText("Look for updates on the following schedule:");
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.onScheduleRadio.setLayoutData((Object)gd);
        this.onScheduleRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        });
        this.dayCombo = new Combo((Composite)group, 8);
        this.dayCombo.setItems(UpdateScheduler.DAYS);
        gd = new GridData();
        gd.widthHint = 200;
        gd.horizontalIndent = 30;
        this.dayCombo.setLayoutData((Object)gd);
        Label label = new Label((Composite)group, 0);
        label.setText("at");
        this.hourCombo = new Combo((Composite)group, 8);
        this.hourCombo.setItems(UpdateScheduler.HOURS);
        gd = new GridData();
        gd.widthHint = 100;
        this.hourCombo.setLayoutData((Object)gd);
        this.createSpacer(container, 1);
        group = new Group(container, 0);
        group.setText("&Download Options");
        layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        gd = new GridData(768);
        group.setLayoutData((Object)gd);
        this.searchOnlyRadio = new Button((Composite)group, 16);
        this.searchOnlyRadio.setText("Search for updates and notify me when they are available");
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.searchOnlyRadio.setLayoutData((Object)gd);
        this.searchOnlyRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        });
        this.searchAndDownloadRadio = new Button((Composite)group, 16);
        this.searchAndDownloadRadio.setText("Download new updates automatically and notify me when ready to install them");
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.searchAndDownloadRadio.setLayoutData((Object)gd);
        this.searchAndDownloadRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        });
        this.initialize();
        this.enabledCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        });
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    private void initialize() {
        Preferences pref = UpdateScheduler.getDefault().getPluginPreferences();
        this.enabledCheck.setSelection(pref.getBoolean("enabled"));
        this.setSchedule(pref.getString("schedule"));
        this.dayCombo.setText(UpdateScheduler.DAYS[this.getDay(pref)]);
        this.hourCombo.setText(UpdateScheduler.HOURS[this.getHour(pref)]);
        this.searchOnlyRadio.setSelection(!pref.getBoolean("download"));
        this.searchAndDownloadRadio.setSelection(pref.getBoolean("download"));
        this.pageChanged();
    }

    private void setSchedule(String value) {
        if (value.equals("on-startup")) {
            this.onStartupRadio.setSelection(true);
        } else {
            this.onScheduleRadio.setSelection(true);
        }
    }

    private void pageChanged() {
        boolean master = this.enabledCheck.getSelection();
        this.onStartupRadio.setEnabled(master);
        this.onScheduleRadio.setEnabled(master);
        this.dayCombo.setEnabled(master && this.onScheduleRadio.getSelection());
        this.hourCombo.setEnabled(master && this.onScheduleRadio.getSelection());
        this.searchOnlyRadio.setEnabled(master);
        this.searchAndDownloadRadio.setEnabled(master);
    }

    protected void performDefaults() {
        super.performDefaults();
        Preferences pref = UpdateScheduler.getDefault().getPluginPreferences();
        this.enabledCheck.setSelection(pref.getDefaultBoolean("enabled"));
    }

    public boolean performOk() {
        Preferences pref = UpdateScheduler.getDefault().getPluginPreferences();
        pref.setValue("enabled", this.enabledCheck.getSelection());
        if (this.onStartupRadio.getSelection()) {
            pref.setValue("schedule", "on-startup");
        } else {
            pref.setValue("schedule", "on-schedule");
        }
        pref.setValue("day", this.dayCombo.getText());
        pref.setValue("hour", this.hourCombo.getText());
        pref.setValue("download", this.searchAndDownloadRadio.getSelection());
        UpdateScheduler.getDefault().savePluginPreferences();
        UpdateScheduler.getDefault().scheduleUpdateJob();
        return true;
    }

    private int getDay(Preferences pref) {
        String day = pref.getString("day");
        int i = 0;
        while (i < UpdateScheduler.DAYS.length) {
            if (UpdateScheduler.DAYS[i].equals(day)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private int getHour(Preferences pref) {
        String hour = pref.getString("hour");
        int i = 0;
        while (i < UpdateScheduler.HOURS.length) {
            if (UpdateScheduler.HOURS[i].equals(hour)) {
                return i;
            }
            ++i;
        }
        return 0;
    }
}

