/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.scheduler;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.update.internal.scheduler.AutomaticUpdatesJob;

public class UpdateScheduler
extends AbstractUIPlugin
implements IStartup {
    public static final String P_ENABLED = "enabled";
    public static final String P_SCHEDULE = "schedule";
    public static final String VALUE_ON_STARTUP = "on-startup";
    public static final String VALUE_ON_SCHEDULE = "on-schedule";
    public static final String P_DOWNLOAD = "download";
    public static final String P_DAY = "day";
    public static final String P_HOUR = "hour";
    private static UpdateScheduler plugin;
    private ResourceBundle resourceBundle;
    private Job job;
    private UpdateJobChangeAdapter jobListener;
    public static final String[] DAYS;
    public static final String[] HOURS;

    static {
        DAYS = new String[]{"Every day", "Every Monday", "Every Tuesday", "Every Wednesday", "Every Thursday", "Every Friday", "Every Saturday", "Every Sunday"};
        HOURS = new String[]{"1:00 AM", "2:00 AM", "3:00 AM", "4:00 AM", "5:00 AM", "6:00 AM", "7:00 AM", "8:00 AM", "9:00 AM", "10:00 AM", "11:00 AM", "12:00 PM", "1:00 PM", "2:00 PM", "3:00 PM", "4:00 PM", "5:00 PM", "6:00 PM", "7:00 PM", "8:00 PM", "9:00 PM", "10:00 PM", "11:00 PM", "12:00 AM"};
    }

    public UpdateScheduler(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.update.internal.scheduler.UpdateSchedulerResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        this.jobListener = new UpdateJobChangeAdapter();
        Platform.getJobManager().addJobChangeListener((IJobChangeListener)this.jobListener);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static UpdateScheduler getDefault() {
        return plugin;
    }

    public static String getString(String key) {
        ResourceBundle bundle = UpdateScheduler.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getFormattedMessage(String key, String[] args) {
        String text = UpdateScheduler.getString(key);
        return MessageFormat.format(text, args);
    }

    public static String getFormattedMessage(String key, String arg) {
        String text = UpdateScheduler.getString(key);
        return MessageFormat.format(text, arg);
    }

    public static String getPluginId() {
        return UpdateScheduler.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static void logException(Throwable e) {
        UpdateScheduler.logException(e, true);
    }

    public static void logException(Throwable e, boolean showErrorDialog) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, UpdateScheduler.getPluginId(), 0, message, e);
        }
        UpdateScheduler.log(status, showErrorDialog);
    }

    public static void log(IStatus status, boolean showErrorDialog) {
        if (status.getSeverity() != 1) {
            if (showErrorDialog) {
                ErrorDialog.openError((Shell)UpdateScheduler.getActiveWorkbenchShell(), null, null, (IStatus)status);
            }
            Platform.getPlugin((String)"org.eclipse.core.runtime").getLog().log(status);
        } else {
            MessageDialog.openInformation((Shell)UpdateScheduler.getActiveWorkbenchShell(), null, (String)status.getMessage());
        }
    }

    public static IWorkbenchPage getActivePage() {
        UpdateScheduler plugin = UpdateScheduler.getDefault();
        IWorkbenchWindow window = plugin.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = UpdateScheduler.getActiveWorkbenchWindow();
        return window != null ? window.getShell() : null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return UpdateScheduler.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public void startup() throws CoreException {
        super.startup();
        this.initializeDefaultPreferences();
    }

    private void initializeDefaultPreferences() {
        Preferences pref = this.getPluginPreferences();
        pref.setDefault(P_ENABLED, false);
        pref.setDefault(P_SCHEDULE, VALUE_ON_STARTUP);
        pref.setDefault(P_DOWNLOAD, false);
    }

    public void shutdown() throws CoreException {
        super.shutdown();
    }

    public void earlyStartup() {
        this.scheduleUpdateJob();
    }

    public void scheduleUpdateJob() {
        Preferences pref = this.getPluginPreferences();
        if (!pref.getBoolean(P_ENABLED)) {
            return;
        }
        String schedule = pref.getString(P_SCHEDULE);
        long delay = -1L;
        delay = schedule.equals(VALUE_ON_STARTUP) ? (this.job == null ? 0L : -1L) : this.computeDelay(pref);
        if (delay == -1L) {
            return;
        }
        this.startSearch(delay);
    }

    private int getDay(Preferences pref) {
        String day = pref.getString(P_DAY);
        int d = 0;
        while (d < DAYS.length) {
            if (DAYS[d].equals(day)) {
                switch (d) {
                    case 0: {
                        return -1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 5;
                    }
                    case 5: {
                        return 6;
                    }
                    case 6: {
                        return 7;
                    }
                    case 7: {
                        return 1;
                    }
                }
            }
            ++d;
        }
        return -1;
    }

    private int getHour(Preferences pref) {
        String hour = pref.getString(P_HOUR);
        int h = 0;
        while (h < HOURS.length) {
            if (HOURS[h].equals(hour)) {
                return h + 1;
            }
            ++h;
        }
        return 1;
    }

    private long computeDelay(Preferences pref) {
        int target_d = this.getDay(pref);
        int target_h = this.getHour(pref);
        Calendar calendar = Calendar.getInstance();
        int current_d = calendar.get(7);
        int current_h = calendar.get(11);
        int current_m = calendar.get(12);
        int current_s = calendar.get(13);
        int current_ms = calendar.get(14);
        long delay = 0L;
        if (target_d == -1) {
            if (target_h == current_h && current_m == 0 && current_s == 0) {
                return delay;
            }
            int delta_h = target_h - current_h;
            if (target_h <= current_h) {
                delta_h += 24;
            }
            delay = ((delta_h * 60 - current_m) * 60 - current_s) * 1000 - current_ms;
            return delay;
        }
        if (target_d == current_d && target_h == current_h && current_m == 0 && current_s == 0) {
            return delay;
        }
        int delta_d = target_d - current_d;
        if (target_d < current_d || target_d == current_d && (target_h < current_h || target_h == current_h && current_m > 0)) {
            delta_d += 7;
        }
        delay = (((delta_d * 24 + target_h - current_h) * 60 - current_m) * 60 - current_s) * 1000 - current_ms;
        return delay;
    }

    private void startSearch(long delay) {
        if (this.job != null) {
            Platform.getJobManager().removeJobChangeListener((IJobChangeListener)this.jobListener);
            Platform.getJobManager().cancel(AutomaticUpdatesJob.family);
            Platform.getJobManager().addJobChangeListener((IJobChangeListener)this.jobListener);
        }
        this.job = new AutomaticUpdatesJob();
        this.job.schedule(delay);
    }

    private class UpdateJobChangeAdapter
    extends JobChangeAdapter {
        UpdateJobChangeAdapter() {
        }

        public void done(Job job, IStatus result) {
            if (job == UpdateScheduler.this.job) {
                UpdateScheduler.this.scheduleUpdateJob();
            }
        }
    }
}

