/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ReferenceCounter;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class WorkbenchPart
implements IWorkbenchPart,
IExecutableExtension {
    private String title;
    private ImageDescriptor imageDescriptor;
    private Image titleImage;
    private String toolTip;
    private IConfigurationElement configElement;
    private IWorkbenchPartSite partSite;
    private ListenerList propChangeListeners = new ListenerList(2);
    static /* synthetic */ Class class$0;

    protected WorkbenchPart() {
    }

    public void addPropertyListener(IPropertyListener l) {
        this.propChangeListeners.add((Object)l);
    }

    public abstract void createPartControl(Composite var1);

    public void dispose() {
        int count;
        ReferenceCounter imageCache = WorkbenchImages.getImageCache();
        Image image = (Image)imageCache.get(this.imageDescriptor);
        if (image != null && (count = imageCache.removeRef(this.imageDescriptor)) <= 0) {
            image.dispose();
        }
        if (!this.propChangeListeners.isEmpty()) {
            this.propChangeListeners = new ListenerList(1);
        }
    }

    protected void firePropertyChange(final int propertyId) {
        Object[] array = this.propChangeListeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            final IPropertyListener l = (IPropertyListener)array[nX];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.propertyChanged(WorkbenchPart.this, propertyId);
                }

                public void handleException(Throwable e) {
                    super.handleException(e);
                    WorkbenchPart.this.propChangeListeners.remove((Object)l);
                }
            });
            ++nX;
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.jobs.IJobChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.getJobChangeListener();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    protected Image getDefaultImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW");
    }

    public IWorkbenchPartSite getSite() {
        return this.partSite;
    }

    public String getTitle() {
        return this.title;
    }

    public Image getTitleImage() {
        if (this.titleImage != null) {
            return this.titleImage;
        }
        return this.getDefaultImage();
    }

    public String getTitleToolTip() {
        return this.toolTip;
    }

    public void removePropertyListener(IPropertyListener l) {
        this.propChangeListeners.remove((Object)l);
    }

    public abstract void setFocus();

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        String strIcon;
        this.configElement = cfig;
        this.title = cfig.getAttribute("name");
        if (this.title == null) {
            this.title = "Unknown";
        }
        if ((strIcon = cfig.getAttribute("icon")) != null) {
            IExtension extension = this.configElement.getDeclaringExtension();
            String extendingPluginId = extension.getDeclaringPluginDescriptor().getUniqueIdentifier();
            this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(extendingPluginId, strIcon);
            ReferenceCounter imageCache = WorkbenchImages.getImageCache();
            Image image = (Image)imageCache.get(this.imageDescriptor);
            if (image != null) {
                imageCache.addRef(this.imageDescriptor);
            } else {
                image = this.imageDescriptor.createImage();
                imageCache.put(this.imageDescriptor, image);
            }
            this.titleImage = image;
        }
    }

    protected void setSite(IWorkbenchPartSite site) {
        this.partSite = site;
    }

    protected void setTitle(String title) {
        this.title = title;
        this.firePropertyChange(1);
    }

    protected void setTitleImage(Image titleImage) {
        this.titleImage = titleImage;
        this.firePropertyChange(1);
    }

    protected void setTitleToolTip(String text) {
        this.toolTip = text;
        this.firePropertyChange(1);
    }

    public IJobChangeListener getJobChangeListener() {
        return null;
    }
}

