/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.keys;

import org.eclipse.ui.internal.keys.CompactKeyFormatter;
import org.eclipse.ui.internal.keys.EmacsKeyFormatter;
import org.eclipse.ui.internal.keys.FormalKeyFormatter;
import org.eclipse.ui.internal.keys.NativeKeyFormatter;
import org.eclipse.ui.keys.IKeyFormatter;

public final class KeyFormatterFactory {
    private static final IKeyFormatter COMPACT_FORMATTER = new CompactKeyFormatter();
    private static final IKeyFormatter FORMAL_FORMATTER = new FormalKeyFormatter();
    private static final IKeyFormatter NATIVE_FORMATTER = new NativeKeyFormatter();
    private static final IKeyFormatter EMACS_FORMATTER = new EmacsKeyFormatter();
    private static IKeyFormatter defaultFormatter = NATIVE_FORMATTER;

    public static final IKeyFormatter getCompactKeyFormatter() {
        return COMPACT_FORMATTER;
    }

    public static IKeyFormatter getDefault() {
        return defaultFormatter;
    }

    public static IKeyFormatter getEmacsKeyFormatter() {
        return EMACS_FORMATTER;
    }

    public static IKeyFormatter getFormalKeyFormatter() {
        return FORMAL_FORMATTER;
    }

    public static IKeyFormatter getNativeKeyFormatter() {
        return NATIVE_FORMATTER;
    }

    public static void setDefault(IKeyFormatter formatter) {
        defaultFormatter = formatter == null ? NATIVE_FORMATTER : formatter;
    }

    private KeyFormatterFactory() {
    }
}

