/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IMemento;

public final class ConfigurationElementMemento
implements IMemento {
    private IConfigurationElement configurationElement;

    public ConfigurationElementMemento(IConfigurationElement configurationElement) {
        if (configurationElement == null) {
            throw new NullPointerException();
        }
        this.configurationElement = configurationElement;
    }

    public IMemento createChild(String type) {
        return null;
    }

    public IMemento createChild(String type, String id) {
        return null;
    }

    public IMemento getChild(String type) {
        IConfigurationElement[] configurationElements = this.configurationElement.getChildren(type);
        if (configurationElements != null && configurationElements.length >= 1) {
            return new ConfigurationElementMemento(configurationElements[0]);
        }
        return null;
    }

    public IMemento[] getChildren(String type) {
        IConfigurationElement[] configurationElements = this.configurationElement.getChildren(type);
        if (configurationElements != null && configurationElements.length >= 1) {
            IMemento[] mementos = new ConfigurationElementMemento[configurationElements.length];
            int i = 0;
            while (i < configurationElements.length) {
                mementos[i] = new ConfigurationElementMemento(configurationElements[i]);
                ++i;
            }
            return mementos;
        }
        return new IMemento[0];
    }

    public Float getFloat(String key) {
        String string = this.configurationElement.getAttribute(key);
        if (string != null) {
            try {
                return new Float(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getID() {
        return this.configurationElement.getAttribute("IMemento.internal.id");
    }

    public Integer getInteger(String key) {
        String string = this.configurationElement.getAttribute(key);
        if (string != null) {
            try {
                return new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getString(String key) {
        return this.configurationElement.getAttribute(key);
    }

    public String getTextData() {
        return this.configurationElement.getValue();
    }

    public void putFloat(String key, float value) {
    }

    public void putInteger(String key, int value) {
    }

    public void putMemento(IMemento memento) {
    }

    public void putString(String key, String value) {
    }

    public void putTextData(String data) {
    }
}

