/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.PageLayout;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;

public class PerspectiveExtensionReader
extends RegistryReader {
    private String targetID;
    private PageLayout pageLayout;
    private Set includeOnlyTags = null;
    public static final String TAG_EXTENSION = "perspectiveExtension";
    public static final String TAG_ACTION_SET = "actionSet";
    public static final String TAG_WIZARD_SHORTCUT = "newWizardShortcut";
    public static final String TAG_VIEW_SHORTCUT = "viewShortcut";
    public static final String TAG_PERSP_SHORTCUT = "perspectiveShortcut";
    public static final String TAG_VIEW = "view";
    public static final String TAG_SHOW_IN_PART = "showInPart";
    private static final String ATT_ID = "id";
    private static final String ATT_TARGET_ID = "targetID";
    private static final String ATT_RELATIVE = "relative";
    private static final String ATT_RELATIONSHIP = "relationship";
    private static final String ATT_RATIO = "ratio";
    private static final String ATT_VISIBLE = "visible";
    private static final String VAL_LEFT = "left";
    private static final String VAL_RIGHT = "right";
    private static final String VAL_TOP = "top";
    private static final String VAL_BOTTOM = "bottom";
    private static final String VAL_STACK = "stack";
    private static final String VAL_FAST = "fast";
    private static final String VAL_FALSE = "false";

    public void extendLayout(String id, PageLayout out) {
        this.targetID = id;
        this.pageLayout = out;
        this.readRegistry(Platform.getPluginRegistry(), "org.eclipse.ui", "perspectiveExtensions");
    }

    private boolean includeTag(String tag) {
        return this.includeOnlyTags == null || this.includeOnlyTags.contains(tag);
    }

    private boolean processActionSet(IConfigurationElement element) {
        String id = element.getAttribute(ATT_ID);
        if (id != null) {
            this.pageLayout.addActionSet(id);
        }
        return true;
    }

    private boolean processExtension(IConfigurationElement element) {
        IConfigurationElement[] children = element.getChildren();
        int nX = 0;
        while (nX < children.length) {
            IConfigurationElement child = children[nX];
            String type = child.getName();
            if (this.includeTag(type)) {
                boolean result = false;
                if (type.equals(TAG_ACTION_SET)) {
                    result = this.processActionSet(child);
                } else if (type.equals(TAG_VIEW)) {
                    result = this.processView(child);
                } else if (type.equals(TAG_VIEW_SHORTCUT)) {
                    result = this.processViewShortcut(child);
                } else if (type.equals(TAG_WIZARD_SHORTCUT)) {
                    result = this.processWizardShortcut(child);
                } else if (type.equals(TAG_PERSP_SHORTCUT)) {
                    result = this.processPerspectiveShortcut(child);
                } else if (type.equals(TAG_SHOW_IN_PART)) {
                    result = this.processShowInPart(child);
                }
                if (!result) {
                    WorkbenchPlugin.log("Unable to process element: " + type + " in perspective extension: " + element.getDeclaringExtension().getUniqueIdentifier());
                }
            }
            ++nX;
        }
        return true;
    }

    private boolean processPerspectiveShortcut(IConfigurationElement element) {
        String id = element.getAttribute(ATT_ID);
        if (id != null) {
            this.pageLayout.addPerspectiveShortcut(id);
        }
        return true;
    }

    private boolean processShowInPart(IConfigurationElement element) {
        String id = element.getAttribute(ATT_ID);
        if (id != null) {
            this.pageLayout.addShowInPart(id);
        }
        return true;
    }

    private boolean processView(IConfigurationElement element) {
        boolean visible;
        float ratio;
        String id = element.getAttribute(ATT_ID);
        String relative = element.getAttribute(ATT_RELATIVE);
        String relationship = element.getAttribute(ATT_RELATIONSHIP);
        String ratioString = element.getAttribute(ATT_RATIO);
        if (id == null || relative == null || relationship == null) {
            return false;
        }
        if (ratioString == null) {
            ratio = -2.0f;
        } else {
            try {
                ratio = new Float(ratioString).floatValue();
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (ratio < 0.05f || ratio > 0.95f) {
                ratio = -1.0f;
            }
        }
        boolean stack = false;
        boolean fast = false;
        int intRelation = 0;
        if (relationship.equals(VAL_LEFT)) {
            intRelation = 1;
        } else if (relationship.equals(VAL_RIGHT)) {
            intRelation = 2;
        } else if (relationship.equals(VAL_TOP)) {
            intRelation = 3;
        } else if (relationship.equals(VAL_BOTTOM)) {
            intRelation = 4;
        } else if (relationship.equals(VAL_STACK)) {
            stack = true;
        } else if (relationship.equals(VAL_FAST)) {
            fast = true;
        } else {
            return false;
        }
        boolean bl = visible = !VAL_FALSE.equals(element.getAttribute(ATT_VISIBLE));
        if (stack) {
            if (visible) {
                this.pageLayout.stackView(id, relative);
            } else {
                this.pageLayout.stackPlaceholder(id, relative);
            }
            return true;
        }
        if (fast) {
            if (ratio == -2.0f) {
                this.pageLayout.addFastView(id);
            } else {
                this.pageLayout.addFastView(id, ratio);
            }
            return true;
        }
        if (ratio == -2.0f || ratio == -1.0f) {
            ratio = 0.5f;
        }
        if (visible) {
            this.pageLayout.addView(id, intRelation, ratio, relative);
        } else {
            this.pageLayout.addPlaceholder(id, intRelation, ratio, relative);
        }
        return true;
    }

    private boolean processViewShortcut(IConfigurationElement element) {
        String id = element.getAttribute(ATT_ID);
        if (id != null) {
            this.pageLayout.addShowViewShortcut(id);
        }
        return true;
    }

    private boolean processWizardShortcut(IConfigurationElement element) {
        String id = element.getAttribute(ATT_ID);
        if (id != null) {
            this.pageLayout.addNewWizardShortcut(id);
        }
        return true;
    }

    protected boolean readElement(IConfigurationElement element) {
        String type = element.getName();
        if (type.equals(TAG_EXTENSION)) {
            String id = element.getAttribute(ATT_TARGET_ID);
            if (this.targetID.equals(id)) {
                return this.processExtension(element);
            }
            return true;
        }
        return false;
    }

    public void setIncludeOnlyTags(String[] tags) {
        this.includeOnlyTags = new HashSet();
        int i = 0;
        while (i < tags.length) {
            this.includeOnlyTags.add(tags[i]);
            ++i;
        }
    }
}

