/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.editorsupport.ComponentSupport;
import org.eclipse.ui.internal.misc.ExternalProgramImageDescriptor;
import org.eclipse.ui.internal.misc.ProgramImageDescriptor;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistryReader;
import org.eclipse.ui.internal.registry.FileEditorMapping;

public class EditorRegistry
implements IEditorRegistry {
    private Map extensionImages = new HashMap();
    private List sortedEditorsFromPlugins = new ArrayList();
    private Map mapIDtoEditor = this.initialIdToEditorMap(10);
    private EditorMap typeEditorMappings;
    private ListenerList propChangeListeners = new ListenerList();
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object arg0, Object arg1) {
            String s1 = ((IEditorDescriptor)arg0).getLabel();
            String s2 = ((IEditorDescriptor)arg1).getLabel();
            return this.collator.compare(s1, s2);
        }
    };

    public EditorRegistry() {
        this.initializeFromStorage();
    }

    public void addEditorFromPlugin(EditorDescriptor editor, List extensions, List filenames, boolean bDefault) {
        FileEditorMapping mapping;
        this.sortedEditorsFromPlugins.add(editor);
        Iterator iterator = extensions.iterator();
        while (iterator.hasNext()) {
            String fileExtension = (String)iterator.next();
            if (fileExtension == null || fileExtension.length() <= 0) continue;
            mapping = this.getMappingFor("*." + fileExtension);
            if (mapping == null) {
                mapping = new FileEditorMapping(fileExtension);
                this.typeEditorMappings.putDefault(this.mappingKeyFor(mapping), mapping);
            }
            mapping.addEditor(editor);
            if (!bDefault) continue;
            mapping.setDefaultEditor(editor);
        }
        iterator = filenames.iterator();
        while (iterator.hasNext()) {
            String filename = (String)iterator.next();
            if (filename == null || filename.length() <= 0) continue;
            mapping = this.getMappingFor(filename);
            if (mapping == null) {
                String extension;
                String name;
                int index = filename.indexOf(46);
                if (index < 0) {
                    name = filename;
                    extension = "";
                } else {
                    name = filename.substring(0, index);
                    extension = filename.substring(index + 1);
                }
                mapping = new FileEditorMapping(name, extension);
                this.typeEditorMappings.putDefault(this.mappingKeyFor(mapping), mapping);
            }
            mapping.addEditor(editor);
            if (!bDefault) continue;
            mapping.setDefaultEditor(editor);
        }
        this.mapIDtoEditor.put(editor.getId(), editor);
    }

    private void addExternalEditorsToEditorMap() {
        IEditorDescriptor desc = null;
        FileEditorMapping[] maps = this.typeEditorMappings.allMappings();
        int i = 0;
        while (i < maps.length) {
            FileEditorMapping map = maps[i];
            IEditorDescriptor[] descArray = map.getEditors();
            int n = 0;
            while (n < descArray.length) {
                desc = descArray[n];
                this.mapIDtoEditor.put(desc.getId(), desc);
                ++n;
            }
            ++i;
        }
    }

    public void addPropertyListener(IPropertyListener l) {
        this.propChangeListeners.add((Object)l);
    }

    public IEditorDescriptor findEditor(String id) {
        return (IEditorDescriptor)this.mapIDtoEditor.get(id);
    }

    private void firePropertyChange(final int type) {
        Object[] array = this.propChangeListeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            final IPropertyListener l = (IPropertyListener)array[nX];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.propertyChanged(EditorRegistry.this, type);
                }

                public void handleException(Throwable e) {
                    super.handleException(e);
                    EditorRegistry.this.propChangeListeners.remove((Object)l);
                }
            });
            ++nX;
        }
    }

    public IEditorDescriptor getDefaultEditor() {
        return this.findEditor("org.eclipse.ui.systemExternalEditor");
    }

    public IEditorDescriptor getDefaultEditor(String filename) {
        FileEditorMapping[] mapping = this.getMappingForFilename(filename);
        IEditorDescriptor desc = null;
        if (mapping[0] != null) {
            desc = mapping[0].getDefaultEditor();
        }
        if (desc == null && mapping[1] != null) {
            desc = mapping[1].getDefaultEditor();
        }
        if (WorkbenchActivityHelper.filterItem(desc)) {
            return null;
        }
        return desc;
    }

    private ImageDescriptor getDefaultImage() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_FILE");
    }

    public IEditorDescriptor[] getEditors(String filename) {
        IEditorDescriptor[] editors;
        IEditorDescriptor[] filenameEditors = editors = new IEditorDescriptor[0];
        IEditorDescriptor[] extensionEditors = editors;
        FileEditorMapping[] mapping = this.getMappingForFilename(filename);
        if (mapping[0] != null && (editors = mapping[0].getEditors()) != null) {
            filenameEditors = editors;
        }
        if (mapping[1] != null && (editors = mapping[1].getEditors()) != null) {
            extensionEditors = editors;
        }
        editors = new IEditorDescriptor[filenameEditors.length + extensionEditors.length];
        System.arraycopy(filenameEditors, 0, editors, 0, filenameEditors.length);
        System.arraycopy(extensionEditors, 0, editors, filenameEditors.length, extensionEditors.length);
        ArrayList<IEditorDescriptor> list = new ArrayList<IEditorDescriptor>(Arrays.asList(editors));
        ArrayList<IEditorDescriptor> filtered = new ArrayList<IEditorDescriptor>();
        Iterator<IEditorDescriptor> i = list.iterator();
        while (i.hasNext()) {
            IEditorDescriptor next = i.next();
            if (WorkbenchActivityHelper.filterItem(next)) continue;
            filtered.add(next);
        }
        editors = filtered.toArray(new IEditorDescriptor[filtered.size()]);
        return editors;
    }

    public IFileEditorMapping[] getFileEditorMappings() {
        IFileEditorMapping[] array = this.typeEditorMappings.allMappings();
        final Collator collator = Collator.getInstance();
        Arrays.sort(array, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((FileEditorMapping)o1).getLabel();
                String s2 = ((FileEditorMapping)o2).getLabel();
                return collator.compare(s1, s2);
            }
        });
        return array;
    }

    public ImageDescriptor getImageDescriptor(String filename) {
        if (filename == null) {
            return this.getDefaultImage();
        }
        String key = this.mappingKeyFor(filename);
        ImageDescriptor anImage = (ImageDescriptor)this.extensionImages.get(key);
        if (anImage != null) {
            return anImage;
        }
        FileEditorMapping[] mapping = this.getMappingForFilename(filename);
        int i = 0;
        while (i < 2) {
            if (mapping[i] != null) {
                String mappingKey = this.mappingKeyFor(mapping[i]);
                ImageDescriptor mappingImage = (ImageDescriptor)this.extensionImages.get(key);
                if (mappingImage != null) {
                    return mappingImage;
                }
                IEditorDescriptor editor = mapping[i].getDefaultEditor();
                if (editor != null) {
                    mappingImage = editor.getImageDescriptor();
                    this.extensionImages.put(mappingKey, mappingImage);
                    return mappingImage;
                }
            }
            ++i;
        }
        anImage = this.getSystemExternalEditorImageDescriptor(filename);
        if (anImage == null) {
            anImage = this.getDefaultImage();
        }
        this.extensionImages.put(key, anImage);
        return anImage;
    }

    private FileEditorMapping getMappingFor(String type) {
        if (type == null) {
            return null;
        }
        String key = this.mappingKeyFor(type);
        return this.typeEditorMappings.get(key);
    }

    private FileEditorMapping[] getMappingForFilename(String filename) {
        FileEditorMapping[] mapping = new FileEditorMapping[2];
        mapping[0] = this.getMappingFor(filename);
        int index = filename.lastIndexOf(46);
        if (index > -1) {
            String extension = filename.substring(index);
            mapping[1] = this.getMappingFor("*" + extension);
        }
        return mapping;
    }

    public IEditorDescriptor[] getSortedEditorsFromOS() {
        ArrayList<EditorDescriptor> externalEditors = new ArrayList<EditorDescriptor>();
        Program[] programs = Program.getPrograms();
        int i = 0;
        while (i < programs.length) {
            EditorDescriptor editor = new EditorDescriptor();
            editor.setOpenMode(4);
            editor.setProgram(programs[i]);
            ExternalProgramImageDescriptor desc = new ExternalProgramImageDescriptor(programs[i]);
            editor.setImageDescriptor(desc);
            externalEditors.add(editor);
            ++i;
        }
        Object[] tempArray = this.sortEditors(externalEditors);
        IEditorDescriptor[] array = new IEditorDescriptor[externalEditors.size()];
        int i2 = 0;
        while (i2 < tempArray.length) {
            array[i2] = (IEditorDescriptor)tempArray[i2];
            ++i2;
        }
        return array;
    }

    public IEditorDescriptor[] getSortedEditorsFromPlugins() {
        IEditorDescriptor[] array = new IEditorDescriptor[this.sortedEditorsFromPlugins.size()];
        this.sortedEditorsFromPlugins.toArray(array);
        return array;
    }

    private HashMap initialIdToEditorMap(int initialSize) {
        HashMap map = new HashMap(initialSize);
        this.addSystemEditors(map);
        return map;
    }

    private void addSystemEditors(HashMap map) {
        EditorDescriptor editor = new EditorDescriptor();
        editor.setID("org.eclipse.ui.systemExternalEditor");
        editor.setName(WorkbenchMessages.getString("SystemEditorDescription.name"));
        editor.setOpenMode(4);
        map.put("org.eclipse.ui.systemExternalEditor", editor);
        if (ComponentSupport.inPlaceEditorSupported()) {
            editor = new EditorDescriptor();
            editor.setID("org.eclipse.ui.systemInPlaceEditor");
            editor.setName(WorkbenchMessages.getString("SystemInPlaceDescription.name"));
            editor.setOpenMode(2);
            map.put("org.eclipse.ui.systemInPlaceEditor", editor);
        }
    }

    private void initializeFromStorage() {
        this.typeEditorMappings = new EditorMap();
        this.extensionImages = new HashMap();
        EditorRegistryReader registryReader = new EditorRegistryReader();
        registryReader.addEditors(true, this);
        this.sortInternalEditors();
        this.rebuildInternalEditorMap();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IPreferenceStore store = workbench.getPreferenceStore();
        String defaultEditors = store.getString("defaultEditors");
        String chachedDefaultEditors = store.getString("defaultEditorsCache");
        if (defaultEditors == null || defaultEditors.equals(chachedDefaultEditors)) {
            this.setProductDefaults(defaultEditors);
            this.loadAssociations();
        } else {
            this.loadAssociations();
            this.setProductDefaults(defaultEditors);
            store.putValue("defaultEditorsCache", defaultEditors);
        }
        this.addExternalEditorsToEditorMap();
    }

    private void setProductDefaults(String defaultEditors) {
        if (defaultEditors == null || defaultEditors.length() == 0) {
            return;
        }
        StringTokenizer extEditors = new StringTokenizer(defaultEditors, new Character(';').toString());
        while (extEditors.hasMoreTokens()) {
            String extEditor = extEditors.nextToken().trim();
            int index = extEditor.indexOf(58);
            if (extEditor.length() < 3 || index <= 0 || index >= extEditor.length() - 1) {
                WorkbenchPlugin.log("Error setting default editor. Could not parse '" + extEditor + "'. Default editors should be specified as '*.ext1:editorId1;*.ext2:editorId2'");
                return;
            }
            String ext = extEditor.substring(0, index).trim();
            String editorId = extEditor.substring(index + 1).trim();
            FileEditorMapping mapping = this.getMappingFor(ext);
            if (mapping == null) {
                WorkbenchPlugin.log("Error setting default editor. Could not find mapping for '" + ext + "'.");
                continue;
            }
            EditorDescriptor editor = (EditorDescriptor)this.findEditor(editorId);
            if (editor == null) {
                WorkbenchPlugin.log("Error setting default editor. Could not find editor: '" + editorId + "'.");
                continue;
            }
            mapping.setDefaultEditor(editor);
        }
    }

    private boolean loadAssociations() {
        XMLMemento memento2;
        FileInputStream stream;
        String xmlString;
        WorkbenchPlugin workbenchPlugin = WorkbenchPlugin.getDefault();
        IPath workbenchStatePath = workbenchPlugin.getStateLocation();
        HashMap<String, EditorDescriptor> editorTable = new HashMap<String, EditorDescriptor>();
        Reader reader = null;
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        try {
            xmlString = store.getString("editors");
            if (xmlString == null || xmlString.length() == 0) {
                stream = new FileInputStream(workbenchStatePath.append("editors.xml").toOSString());
                reader = new BufferedReader(new InputStreamReader((InputStream)stream, "utf-8"));
            } else {
                reader = new StringReader(xmlString);
            }
            memento2 = XMLMemento.createReadRoot(reader);
            IMemento[] edMementos = memento2.getChildren("descriptor");
            int i = 0;
            while (i < edMementos.length) {
                EditorDescriptor editor = new EditorDescriptor();
                editor.loadValues(edMementos[i]);
                if (editor.getPluginID() != null) {
                    EditorDescriptor validEditorDescritor = (EditorDescriptor)this.mapIDtoEditor.get(editor.getId());
                    if (validEditorDescritor != null) {
                        editorTable.put(validEditorDescritor.getId(), validEditorDescritor);
                    }
                } else {
                    ImageDescriptor descriptor = editor.getProgram() == null ? new ProgramImageDescriptor(editor.getFileName(), 0) : new ExternalProgramImageDescriptor(editor.getProgram());
                    editor.setImageDescriptor(descriptor);
                    editorTable.put(editor.getId(), editor);
                }
                ++i;
            }
        }
        catch (IOException e) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException memento2) {
                // empty catch block
            }
            return false;
        }
        catch (WorkbenchException e) {
            ErrorDialog.openError(null, (String)WorkbenchMessages.getString("EditorRegistry.errorTitle"), (String)WorkbenchMessages.getString("EditorRegistry.errorMessage"), (IStatus)e.getStatus());
            return false;
        }
        reader = null;
        try {
            xmlString = store.getString("resourcetypes");
            if (xmlString == null || xmlString.length() == 0) {
                stream = new FileInputStream(workbenchStatePath.append("resourcetypes.xml").toOSString());
                reader = new BufferedReader(new InputStreamReader((InputStream)stream, "utf-8"));
            } else {
                reader = new StringReader(xmlString);
            }
            memento2 = XMLMemento.createReadRoot(reader);
            IMemento[] extMementos = memento2.getChildren("info");
            int i = 0;
            while (i < extMementos.length) {
                String name = extMementos[i].getString("name");
                if (name == null) {
                    name = "*";
                }
                String extension = extMementos[i].getString("extension");
                IMemento[] idMementos = extMementos[i].getChildren("editor");
                String[] editorIDs = new String[idMementos.length];
                int j = 0;
                while (j < idMementos.length) {
                    editorIDs[j] = idMementos[j].getString("id");
                    ++j;
                }
                idMementos = extMementos[i].getChildren("deletedEditor");
                String[] deletedEditorIDs = new String[idMementos.length];
                int j2 = 0;
                while (j2 < idMementos.length) {
                    deletedEditorIDs[j2] = idMementos[j2].getString("id");
                    ++j2;
                }
                FileEditorMapping mapping = this.getMappingFor(String.valueOf(name) + "." + extension);
                if (mapping == null) {
                    mapping = new FileEditorMapping(name, extension);
                }
                ArrayList<IEditorDescriptor> editors = new ArrayList<IEditorDescriptor>();
                int j3 = 0;
                while (j3 < editorIDs.length) {
                    EditorDescriptor editor;
                    if (editorIDs[j3] != null && (editor = (EditorDescriptor)editorTable.get(editorIDs[j3])) != null) {
                        editors.add(editor);
                    }
                    ++j3;
                }
                ArrayList<EditorDescriptor> deletedEditors = new ArrayList<EditorDescriptor>();
                int j4 = 0;
                while (j4 < deletedEditorIDs.length) {
                    EditorDescriptor editor;
                    if (deletedEditorIDs[j4] != null && (editor = (EditorDescriptor)editorTable.get(deletedEditorIDs[j4])) != null) {
                        deletedEditors.add(editor);
                    }
                    ++j4;
                }
                IEditorDescriptor[] editorsArray = mapping.getEditors();
                int j5 = 0;
                while (j5 < editorsArray.length) {
                    if (!editors.contains(editorsArray[j5]) && !deletedEditors.contains(editorsArray[j5])) {
                        editors.add(editorsArray[j5]);
                    }
                    ++j5;
                }
                mapping.setEditorsList(editors);
                mapping.setDeletedEditorsList(deletedEditors);
                this.typeEditorMappings.put(this.mappingKeyFor(mapping), mapping);
                ++i;
            }
        }
        catch (IOException e) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            MessageDialog.openError(null, (String)WorkbenchMessages.getString("EditorRegistry.errorTitle"), (String)WorkbenchMessages.getString("EditorRegistry.errorMessage"));
            return false;
        }
        catch (WorkbenchException e) {
            ErrorDialog.openError(null, (String)WorkbenchMessages.getString("EditorRegistry.errorTitle"), (String)WorkbenchMessages.getString("EditorRegistry.errorMessage"), (IStatus)e.getStatus());
            return false;
        }
        return true;
    }

    private String mappingKeyFor(String type) {
        return type.toLowerCase();
    }

    private String mappingKeyFor(FileEditorMapping mapping) {
        return this.mappingKeyFor(String.valueOf(mapping.getName()) + (mapping.getExtension().length() == 0 ? "" : "." + mapping.getExtension()));
    }

    private void rebuildEditorMap() {
        this.rebuildInternalEditorMap();
        this.addExternalEditorsToEditorMap();
    }

    private void rebuildInternalEditorMap() {
        Iterator iterator = null;
        IEditorDescriptor desc = null;
        this.mapIDtoEditor = this.initialIdToEditorMap(this.mapIDtoEditor.size());
        iterator = this.sortedEditorsFromPlugins.iterator();
        while (iterator.hasNext()) {
            desc = (IEditorDescriptor)iterator.next();
            this.mapIDtoEditor.put(desc.getId(), desc);
        }
    }

    public void removePropertyListener(IPropertyListener l) {
        this.propChangeListeners.remove((Object)l);
    }

    public void saveAssociations() {
        ArrayList<EditorDescriptor> editors = new ArrayList<EditorDescriptor>();
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        XMLMemento memento = XMLMemento.createWriteRoot("editors");
        FileEditorMapping[] maps = this.typeEditorMappings.userMappings();
        int mapsIndex = 0;
        while (mapsIndex < maps.length) {
            IMemento idMemento;
            EditorDescriptor editor;
            FileEditorMapping type = maps[mapsIndex];
            IMemento editorMemento = memento.createChild("info");
            editorMemento.putString("name", type.getName());
            editorMemento.putString("extension", type.getExtension());
            IEditorDescriptor[] editorArray = type.getEditors();
            int i = 0;
            while (i < editorArray.length) {
                editor = (EditorDescriptor)editorArray[i];
                if (!editors.contains(editor)) {
                    editors.add(editor);
                }
                idMemento = editorMemento.createChild("editor");
                idMemento.putString("id", editorArray[i].getId());
                ++i;
            }
            editorArray = type.getDeletedEditors();
            i = 0;
            while (i < editorArray.length) {
                editor = (EditorDescriptor)editorArray[i];
                if (!editors.contains(editor)) {
                    editors.add(editor);
                }
                idMemento = editorMemento.createChild("deletedEditor");
                idMemento.putString("id", editorArray[i].getId());
                ++i;
            }
            ++mapsIndex;
        }
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            memento.save(writer);
            ((Writer)writer).close();
            store.setValue("resourcetypes", ((Object)writer).toString());
        }
        catch (IOException e) {
            try {
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
            catch (IOException editorMemento) {
                // empty catch block
            }
            MessageDialog.openError(null, (String)"Saving Problems", (String)"Unable to save resource associations.");
            return;
        }
        memento = XMLMemento.createWriteRoot("editors");
        Iterator iterator = editors.iterator();
        while (iterator.hasNext()) {
            EditorDescriptor editor = (EditorDescriptor)iterator.next();
            IMemento editorMemento = memento.createChild("descriptor");
            editor.saveValues(editorMemento);
        }
        writer = null;
        try {
            writer = new StringWriter();
            memento.save(writer);
            ((Writer)writer).close();
            store.setValue("editors", ((Object)writer).toString());
        }
        catch (IOException e) {
            try {
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            MessageDialog.openError(null, (String)"Error", (String)"Unable to save resource associations.");
            return;
        }
    }

    public void setFileEditorMappings(FileEditorMapping[] newResourceTypes) {
        this.typeEditorMappings = new EditorMap();
        int i = 0;
        while (i < newResourceTypes.length) {
            FileEditorMapping mapping = newResourceTypes[i];
            this.typeEditorMappings.put(this.mappingKeyFor(mapping), mapping);
            ++i;
        }
        this.extensionImages = new HashMap();
        this.rebuildEditorMap();
        this.firePropertyChange(1);
    }

    public void setDefaultEditor(String fileName, String editorId) {
        EditorDescriptor desc = (EditorDescriptor)this.findEditor(editorId);
        FileEditorMapping[] mapping = this.getMappingForFilename(fileName);
        if (mapping[0] != null) {
            mapping[0].setDefaultEditor(desc);
        }
        if (mapping[1] != null) {
            mapping[1].setDefaultEditor(desc);
        }
    }

    private Object[] sortEditors(List unsortedList) {
        Object[] array = new Object[unsortedList.size()];
        unsortedList.toArray(array);
        Collections.sort(Arrays.asList(array), comparer);
        return array;
    }

    private void sortInternalEditors() {
        Object[] array = this.sortEditors(this.sortedEditorsFromPlugins);
        this.sortedEditorsFromPlugins = new ArrayList();
        int i = 0;
        while (i < array.length) {
            this.sortedEditorsFromPlugins.add(array[i]);
            ++i;
        }
    }

    public boolean isSystemInPlaceEditorAvailable(String filename) {
        return ComponentSupport.inPlaceEditorAvailable(filename);
    }

    public boolean isSystemExternalEditorAvailable(String filename) {
        int nDot = filename.lastIndexOf(46);
        if (nDot >= 0) {
            String strName = filename.substring(nDot);
            return Program.findProgram((String)strName) != null;
        }
        return false;
    }

    public ImageDescriptor getSystemExternalEditorImageDescriptor(String filename) {
        Program externalProgram = null;
        int extensionIndex = filename.lastIndexOf(46);
        if (extensionIndex >= 0) {
            externalProgram = Program.findProgram((String)filename.substring(extensionIndex));
        }
        if (externalProgram == null) {
            return null;
        }
        return new ExternalProgramImageDescriptor(externalProgram);
    }

    private static class EditorMap {
        HashMap defaultMap = new HashMap();
        HashMap map = new HashMap();

        EditorMap() {
        }

        public void putDefault(String key, FileEditorMapping value) {
            this.defaultMap.put(key, value);
        }

        public void put(String key, FileEditorMapping value) {
            Object result = this.defaultMap.get(key);
            if (value.equals(result)) {
                this.map.remove(key);
            } else {
                this.map.put(key, value);
            }
        }

        public FileEditorMapping get(String key) {
            Object result = this.map.get(key);
            if (result == null) {
                result = this.defaultMap.get(key);
            }
            return (FileEditorMapping)result;
        }

        public FileEditorMapping[] allMappings() {
            HashMap merge = (HashMap)this.defaultMap.clone();
            merge.putAll(this.map);
            Collection values = merge.values();
            FileEditorMapping[] result = new FileEditorMapping[values.size()];
            return values.toArray(result);
        }

        public FileEditorMapping[] userMappings() {
            Collection values = this.map.values();
            FileEditorMapping[] result = new FileEditorMapping[values.size()];
            return values.toArray(result);
        }
    }
}

