/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.SubTaskInfo;

public class TaskInfo
extends SubTaskInfo {
    double preWork = 0.0;
    int totalWork = 0;

    TaskInfo(JobInfo parentJobInfo, String infoName, int total) {
        super(parentJobInfo, infoName);
        this.totalWork = total;
    }

    void addWork(double workIncrement) {
        this.preWork += workIncrement;
    }

    String getDisplayString() {
        int done = (int)(this.preWork * 100.0 / (double)this.totalWork);
        if (this.taskName == null) {
            Object[] messageValues = new String[]{this.jobInfo.getJob().getName(), String.valueOf(done)};
            return ProgressMessages.format("JobInfo.NoTaskNameDoneMessage", messageValues);
        }
        Object[] messageValues = new String[]{this.jobInfo.getJob().getName(), this.taskName, String.valueOf(done)};
        return ProgressMessages.format("JobInfo.DoneMessage", messageValues);
    }
}

