/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.Iterator;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.progress.JobInfo;

class ProgressTreeViewer
extends TreeViewer {
    protected void doUpdateItem(Item item, Object element) {
        super.doUpdateItem(item, element);
        if (element instanceof JobInfo && item != null && item instanceof TreeItem) {
            this.updateColors((TreeItem)item, (JobInfo)element);
        }
    }

    private void updateColors(TreeItem treeItem, JobInfo info) {
        if (info.getErrorStatus() != null) {
            treeItem.setForeground(JFaceColors.getErrorText((Display)treeItem.getDisplay()));
            return;
        }
        if (info.getJob().getState() != 4) {
            treeItem.setForeground(JFaceColors.getActiveHyperlinkText((Display)treeItem.getDisplay()));
            return;
        }
        treeItem.setForeground(treeItem.getDisplay().getSystemColor(24));
    }

    public ProgressTreeViewer(Composite parent, int style) {
        super(parent, style);
    }

    protected void createChildren(Widget widget) {
        super.createChildren(widget);
        this.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ISelection selection;
                if (e.keyCode == 127 && (selection = ProgressTreeViewer.this.getSelection()) instanceof IStructuredSelection) {
                    IStructuredSelection structured = (IStructuredSelection)selection;
                    Iterator elements = structured.iterator();
                    while (elements.hasNext()) {
                        Object next = elements.next();
                        if (!(next instanceof JobInfo)) continue;
                        ((JobInfo)next).cancel();
                    }
                }
            }
        });
    }
}

