/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import org.eclipse.ui.internal.progress.IJobProgressManagerListener;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressFeedbackManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.internal.progress.WorkbenchMonitorProvider;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class ProgressManager
extends ProgressProvider
implements IProgressService {
    private static ProgressManager singleton;
    private Map jobs = Collections.synchronizedMap(new HashMap());
    private Collection listeners = Collections.synchronizedList(new ArrayList());
    Object listenerKey = new Object();
    private WorkbenchMonitorProvider monitorProvider;
    private ProgressFeedbackManager feedbackManager = new ProgressFeedbackManager();
    IJobChangeListener changeListener;
    static final String PROGRESS_VIEW_NAME = "org.eclipse.ui.views.ProgressView";
    static final String PROGRESS_FOLDER = "icons/full/progress/";
    private static final String PROGRESS_20 = "progress20.gif";
    private static final String PROGRESS_40 = "progress40.gif";
    private static final String PROGRESS_60 = "progress60.gif";
    private static final String PROGRESS_80 = "progress80.gif";
    private static final String PROGRESS_100 = "progress100.gif";
    private static final String SLEEPING_JOB = "sleeping.gif";
    private static final String WAITING_JOB = "waiting.gif";
    private static final String ERROR_JOB = "errorstate.gif";
    private static final String BLOCKED_JOB = "lockedstate.gif";
    private static final String PROGRESS_20_KEY = "PROGRESS_20";
    private static final String PROGRESS_40_KEY = "PROGRESS_40";
    private static final String PROGRESS_60_KEY = "PROGRESS_60";
    private static final String PROGRESS_80_KEY = "PROGRESS_80";
    private static final String PROGRESS_100_KEY = "PROGRESS_100";
    private static final String SLEEPING_JOB_KEY = "SLEEPING_JOB";
    private static final String WAITING_JOB_KEY = "WAITING_JOB";
    private static final String ERROR_JOB_KEY = "ERROR_JOB";
    private static final String BLOCKED_JOB_KEY = "LOCKED_JOB";
    static String[] keys;
    Hashtable runnableMonitors = new Hashtable();

    static {
        keys = new String[]{PROGRESS_20_KEY, PROGRESS_40_KEY, PROGRESS_60_KEY, PROGRESS_80_KEY, PROGRESS_100_KEY};
    }

    public static ProgressManager getInstance() {
        if (singleton == null) {
            singleton = new ProgressManager();
        }
        return singleton;
    }

    ProgressManager() {
        Platform.getJobManager().setProgressProvider((ProgressProvider)this);
        this.createChangeListener();
        Platform.getJobManager().addJobChangeListener(this.changeListener);
        this.monitorProvider = new WorkbenchMonitorProvider();
        URL iconsRoot = Platform.getPlugin((String)"org.eclipse.ui").find((IPath)new Path(PROGRESS_FOLDER));
        try {
            this.setUpImage(iconsRoot, PROGRESS_20, PROGRESS_20_KEY);
            this.setUpImage(iconsRoot, PROGRESS_40, PROGRESS_40_KEY);
            this.setUpImage(iconsRoot, PROGRESS_60, PROGRESS_60_KEY);
            this.setUpImage(iconsRoot, PROGRESS_80, PROGRESS_80_KEY);
            this.setUpImage(iconsRoot, PROGRESS_100, PROGRESS_100_KEY);
            this.setUpImage(iconsRoot, SLEEPING_JOB, SLEEPING_JOB_KEY);
            this.setUpImage(iconsRoot, WAITING_JOB, WAITING_JOB_KEY);
            this.setUpImage(iconsRoot, ERROR_JOB, ERROR_JOB_KEY);
            this.setUpImage(iconsRoot, BLOCKED_JOB, BLOCKED_JOB_KEY);
        }
        catch (MalformedURLException e) {
            ProgressManagerUtil.logException(e);
        }
    }

    private void createChangeListener() {
        this.changeListener = new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                JobInfo info = ProgressManager.this.getJobInfo(event.getJob());
                ProgressManager.this.refresh(info);
            }

            public void done(IJobChangeEvent event) {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                JobInfo info = ProgressManager.this.getJobInfo(event.getJob());
                if (event.getResult().getSeverity() == 4) {
                    info.setError(event.getResult());
                    WorkbenchJob job = new WorkbenchJob(this, ProgressMessages.getString("JobProgressManager.OpenProgressJob")){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            IWorkbench workbench = PlatformUI.getWorkbench();
                            if (workbench instanceof Workbench && ((Workbench)workbench).isClosing()) {
                                return Status.CANCEL_STATUS;
                            }
                            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                            if (window == null) {
                                return Status.CANCEL_STATUS;
                            }
                            ProgressManagerUtil.openProgressView(window);
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                    ProgressManager.this.refresh(info);
                } else {
                    ProgressManager.this.jobs.remove(event.getJob());
                    ProgressManager.this.remove(info);
                    if (ProgressManager.this.hasNoRegularJobInfos() && !ProgressManager.this.isNonDisplayableJob(event.getJob(), false)) {
                        ProgressManager.this.refreshAll();
                    }
                }
            }

            public void scheduled(IJobChangeEvent event) {
                if (ProgressManager.this.isNeverDisplayedJob(event.getJob())) {
                    return;
                }
                if (ProgressManager.this.jobs.containsKey(event.getJob())) {
                    ProgressManager.this.refresh(ProgressManager.this.getJobInfo(event.getJob()));
                } else {
                    JobInfo info = new JobInfo(event.getJob());
                    ProgressManager.this.jobs.put(event.getJob(), info);
                    ProgressManager.this.add(info);
                }
            }
        };
    }

    private void setUpImage(URL iconsRoot, String fileName, String key) throws MalformedURLException {
        JFaceResources.getImageRegistry().put(key, ImageDescriptor.createFromURL((URL)new URL(iconsRoot, fileName)));
    }

    public IProgressMonitor createMonitor(Job job) {
        return this.progressFor(job);
    }

    public IProgressMonitor getDefaultMonitor() {
        Display display;
        if (PlatformUI.isWorkbenchRunning() && (display = PlatformUI.getWorkbench().getDisplay()).getThread() == Thread.currentThread()) {
            return new DefaultMonitor();
        }
        return super.getDefaultMonitor();
    }

    private JobMonitor progressFor(Job job) {
        if (this.runnableMonitors.containsKey(job)) {
            return (JobMonitor)this.runnableMonitors.get(job);
        }
        return new JobMonitor(job);
    }

    void addListener(IJobProgressManagerListener listener) {
        Object object = this.listenerKey;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    void removeListener(IJobProgressManagerListener listener) {
        Object object = this.listenerKey;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    JobInfo getJobInfo(Job job) {
        JobInfo info = (JobInfo)this.jobs.get(job);
        if (info == null) {
            info = new JobInfo(job);
            this.jobs.put(job, info);
        }
        return info;
    }

    public void refresh(JobInfo info) {
        Object object = this.listenerKey;
        synchronized (object) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                IJobProgressManagerListener listener = (IJobProgressManagerListener)iterator.next();
                if (this.isNonDisplayableJob(info.getJob(), listener.showsDebug())) continue;
                listener.refresh(info);
            }
        }
    }

    public void refreshAll() {
        Object object = this.listenerKey;
        synchronized (object) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                IJobProgressManagerListener listener = (IJobProgressManagerListener)iterator.next();
                listener.refreshAll();
            }
        }
    }

    public void remove(JobInfo info) {
        Object object = this.listenerKey;
        synchronized (object) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                IJobProgressManagerListener listener = (IJobProgressManagerListener)iterator.next();
                if (this.isNonDisplayableJob(info.getJob(), listener.showsDebug())) continue;
                listener.remove(info);
            }
        }
    }

    public void add(JobInfo info) {
        Object object = this.listenerKey;
        synchronized (object) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                IJobProgressManagerListener listener = (IJobProgressManagerListener)iterator.next();
                if (this.isNonDisplayableJob(info.getJob(), listener.showsDebug())) continue;
                listener.add(info);
            }
        }
    }

    boolean isNonDisplayableJob(Job job, boolean debug) {
        if (this.isNeverDisplayedJob(job)) {
            return true;
        }
        if (debug) {
            return false;
        }
        return job.isSystem() || job.getState() == 1;
    }

    private boolean isNeverDisplayedJob(Job job) {
        return job == null;
    }

    public JobInfo[] getJobInfos(boolean debug) {
        Map map = this.jobs;
        synchronized (map) {
            Iterator iterator = this.jobs.keySet().iterator();
            ArrayList result = new ArrayList();
            while (iterator.hasNext()) {
                Job next = (Job)iterator.next();
                if (this.isNonDisplayableJob(next, debug)) continue;
                result.add(this.jobs.get(next));
            }
            JobInfo[] infos = new JobInfo[result.size()];
            result.toArray(infos);
            return infos;
        }
    }

    public boolean hasJobInfos() {
        Map map = this.jobs;
        synchronized (map) {
            block4: {
                Iterator iterator = this.jobs.keySet().iterator();
                if (!iterator.hasNext()) break block4;
                return true;
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasNoRegularJobInfos() {
        Map map = this.jobs;
        synchronized (map) {
            Job next;
            Iterator iterator = this.jobs.keySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (this.isNonDisplayableJob(next = (Job)iterator.next(), false));
            return false;
        }
    }

    void clearJob(Job job) {
        JobInfo info = (JobInfo)this.jobs.get(job);
        if (info != null && info.getErrorStatus() != null) {
            this.jobs.remove(job);
            this.remove(info);
        }
    }

    void clearAllErrors() {
        ArrayList jobsToDelete = new ArrayList();
        Map map = this.jobs;
        synchronized (map) {
            Iterator keySet = this.jobs.keySet().iterator();
            while (keySet.hasNext()) {
                Object job = keySet.next();
                JobInfo info = (JobInfo)this.jobs.get(job);
                if (info.getErrorStatus() == null) continue;
                jobsToDelete.add(job);
            }
        }
        Iterator deleteSet = jobsToDelete.iterator();
        while (deleteSet.hasNext()) {
            this.jobs.remove(deleteSet.next());
        }
        this.refreshAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasErrorsDisplayed() {
        Map map = this.jobs;
        synchronized (map) {
            Object job;
            JobInfo info;
            Iterator keySet = this.jobs.keySet().iterator();
            do {
                if (keySet.hasNext()) continue;
                return false;
            } while ((info = (JobInfo)this.jobs.get(job = keySet.next())).getErrorStatus() == null);
            return true;
        }
    }

    Image getImage(ImageData source) {
        ImageData mask = source.getTransparencyMask();
        return new Image(null, source, mask);
    }

    ImageData[] getImageData(URL fileSystemPath, ImageLoader loader) {
        try {
            InputStream stream = fileSystemPath.openStream();
            ImageData[] result = loader.load(stream);
            stream.close();
            return result;
        }
        catch (FileNotFoundException exception) {
            ProgressManagerUtil.logException(exception);
            return null;
        }
        catch (IOException exception) {
            ProgressManagerUtil.logException(exception);
            return null;
        }
    }

    Image getDisplayImage(JobTreeElement element) {
        if (element.isJobInfo()) {
            JobInfo info = (JobInfo)element;
            int done = info.getPercentDone();
            if (done > 0) {
                int index = Math.min(4, done / 20);
                return JFaceResources.getImage((String)keys[index]);
            }
            if (info.isBlocked()) {
                return JFaceResources.getImage((String)BLOCKED_JOB_KEY);
            }
            if (info.getErrorStatus() != null) {
                return JFaceResources.getImage((String)ERROR_JOB_KEY);
            }
            int state = info.getJob().getState();
            if (state == 1) {
                return JFaceResources.getImage((String)SLEEPING_JOB_KEY);
            }
            if (state == 2) {
                return JFaceResources.getImage((String)WAITING_JOB_KEY);
            }
            return JFaceResources.getImage((String)keys[0]);
        }
        return null;
    }

    public IStatus requestInUI(UIJob job, String message) {
        return this.feedbackManager.requestInUI(job, message);
    }

    ProgressFeedbackManager getFeedbackManager() {
        return this.feedbackManager;
    }

    public void busyCursorWhile(final IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        final ProgressMonitorJobsDialog dialog = new ProgressMonitorJobsDialog(null);
        dialog.setOpenOnRun(false);
        final boolean[] busy = new boolean[]{true};
        this.scheduleProgressMonitorJob(dialog, busy);
        final InvocationTargetException[] invokes = new InvocationTargetException[1];
        final InterruptedException[] interrupt = new InterruptedException[1];
        invokes[0] = null;
        interrupt[0] = null;
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null) {
            return;
        }
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    dialog.setOpenOnRun(false);
                    dialog.run(true, true, runnable);
                    if (!PlatformUI.isWorkbenchRunning()) return;
                    Display currentDisplay = PlatformUI.getWorkbench().getDisplay();
                    while (true) {
                        if (!busy[0]) {
                            return;
                        }
                        if (currentDisplay.readAndDispatch()) continue;
                        currentDisplay.sleep();
                    }
                }
                catch (InvocationTargetException e) {
                    invokes[0] = e;
                    return;
                }
                catch (InterruptedException e) {
                    interrupt[0] = e;
                }
            }
        });
        if (invokes[0] != null) {
            throw invokes[0];
        }
        if (interrupt[0] != null) {
            throw interrupt[0];
        }
    }

    private void scheduleProgressMonitorJob(final ProgressMonitorJobsDialog dialog, final boolean[] busy) {
        final boolean[] defer = new boolean[]{false};
        WorkbenchJob updateJob = new WorkbenchJob(ProgressMessages.getString("ProgressManager.openJobName")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Display currentDisplay = this.getDisplay();
                if (currentDisplay == null || currentDisplay.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                Shell[] shells = currentDisplay.getShells();
                int i = 0;
                while (i < shells.length) {
                    int style;
                    if (shells[i].isVisible() && ((style = shells[i].getStyle()) & 0x10000 | style & 0x20000 | style & 0x8000) > 0) {
                        defer[0] = true;
                        return Status.CANCEL_STATUS;
                    }
                    ++i;
                }
                busy[0] = false;
                dialog.open();
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            public void performDone(IJobChangeEvent event) {
                if (defer[0]) {
                    defer[0] = false;
                    this.schedule(5000L);
                }
            }
        };
        updateJob.schedule(5000L);
    }

    public void shutdown() {
        Object object = this.listenerKey;
        synchronized (object) {
            this.listeners.clear();
        }
        Platform.getJobManager().setProgressProvider(null);
        Platform.getJobManager().removeJobChangeListener(this.changeListener);
    }

    private class DefaultMonitor
    extends NullProgressMonitor
    implements IProgressMonitorWithBlocking {
        private ProgressMonitorJobsDialog dialog;
        private EventLoopProgressMonitor eventLoopMonitor;
        private String taskName = "";

        DefaultMonitor() {
        }

        public void beginTask(String name, int totalWork) {
            this.taskName = name == null ? "" : name;
        }

        public void clearBlocked() {
            this.eventLoopMonitor = null;
            if (this.dialog == null || this.dialog.getShell() == null || this.dialog.getShell().isDisposed()) {
                return;
            }
            this.dialog.close();
            this.dialog = null;
        }

        public boolean isCanceled() {
            if (this.eventLoopMonitor != null) {
                return this.eventLoopMonitor.isCanceled();
            }
            return false;
        }

        public void setBlocked(IStatus reason) {
            this.dialog = new ProgressMonitorJobsDialog(null);
            this.dialog.setBlockOnOpen(false);
            this.dialog.setCancelable(true);
            this.dialog.open();
            IProgressMonitor monitor = this.dialog.getProgressMonitor();
            this.eventLoopMonitor = new EventLoopProgressMonitor(monitor);
            monitor.beginTask(this.taskName, -1);
            if (monitor instanceof IProgressMonitorWithBlocking) {
                ((IProgressMonitorWithBlocking)monitor).setBlocked(reason);
            }
        }
    }

    private class JobMonitor
    implements IProgressMonitorWithBlocking {
        Job job;
        IProgressMonitor workbenchMonitor;
        String currentTaskName;

        JobMonitor(Job newJob) {
            this.job = newJob;
            this.workbenchMonitor = ProgressManager.this.monitorProvider.getMonitor(this.job);
        }

        public void beginTask(String taskName, int totalWork) {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            info.beginTask(taskName, totalWork);
            ProgressManager.this.refresh(info);
            this.currentTaskName = taskName;
            this.workbenchMonitor.beginTask(taskName, totalWork);
        }

        public void done() {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            info.clearTaskInfo();
            info.clearChildren();
            this.workbenchMonitor.done();
            ProgressManager.this.runnableMonitors.remove(this);
        }

        public void internalWorked(double work) {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            if (info.hasTaskInfo()) {
                info.addWork(work);
                ProgressManager.this.refresh(info);
            }
            this.workbenchMonitor.internalWorked(work);
        }

        public boolean isCanceled() {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            return info.isCanceled();
        }

        public void setCanceled(boolean value) {
            this.workbenchMonitor.setCanceled(value);
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            if (value && !info.isCanceled()) {
                info.cancel();
            }
        }

        public void setTaskName(String taskName) {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            if (!info.hasTaskInfo()) {
                this.beginTask(taskName, 100);
                return;
            }
            info.setTaskName(taskName);
            info.clearChildren();
            ProgressManager.this.refresh(info);
            this.currentTaskName = taskName;
            this.workbenchMonitor.setTaskName(taskName);
        }

        public void subTask(String name) {
            if (name.length() == 0) {
                return;
            }
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            info.clearChildren();
            info.addSubTask(name);
            ProgressManager.this.refresh(info);
            this.workbenchMonitor.subTask(name);
        }

        public void worked(int work) {
            this.internalWorked(work);
        }

        public void clearBlocked() {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            info.setBlockedStatus(null);
            ProgressManager.this.refresh(info);
        }

        public void setBlocked(IStatus reason) {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            info.setBlockedStatus(null);
            ProgressManager.this.refresh(info);
        }
    }
}

