/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.SubTaskInfo;
import org.eclipse.ui.internal.progress.TaskInfo;

class JobInfo
extends JobTreeElement {
    private ArrayList children = new ArrayList();
    private Job job;
    private TaskInfo taskInfo;
    private IStatus errorStatus;
    private IStatus blockedStatus;
    private boolean canceled = false;

    Job getJob() {
        return this.job;
    }

    IStatus getErrorStatus() {
        return this.errorStatus;
    }

    boolean hasTaskInfo() {
        return this.taskInfo != null;
    }

    void setTaskName(String name) {
        this.taskInfo.setTaskName(name);
    }

    JobInfo(Job enclosingJob) {
        this.job = enclosingJob;
    }

    String getDisplayString() {
        String name = this.getDisplayStringWithStatus();
        if (this.job.isSystem()) {
            return ProgressMessages.format("JobInfo.System", new Object[]{this.getJob().getName()});
        }
        return name;
    }

    private String getDisplayStringWithStatus() {
        if (this.isCanceled()) {
            return ProgressMessages.format("JobInfo.Cancelled", new Object[]{this.getJob().getName()});
        }
        if (this.isBlocked()) {
            return ProgressMessages.format("JobInfo.Blocked", new Object[]{this.getJob().getName(), this.blockedStatus.getMessage()});
        }
        if (this.errorStatus != null) {
            return ProgressMessages.format("JobInfo.Error", new Object[]{this.getJob().getName(), this.errorStatus.getMessage()});
        }
        if (this.getJob().getState() == 4) {
            if (this.taskInfo == null) {
                return this.getJob().getName();
            }
            return this.taskInfo.getDisplayString();
        }
        if (this.getJob().getState() == 1) {
            return ProgressMessages.format("JobInfo.Sleeping", new Object[]{this.getJob().getName()});
        }
        return ProgressMessages.format("JobInfo.Waiting", new Object[]{this.getJob().getName()});
    }

    Object[] getChildren() {
        return this.children.toArray();
    }

    boolean hasChildren() {
        return this.children.size() > 0;
    }

    void beginTask(String taskName, int work) {
        this.taskInfo = new TaskInfo(this, taskName, work);
    }

    void addSubTask(String subTaskName) {
        this.children.add(new SubTaskInfo(this, subTaskName));
    }

    void addWork(double workIncrement) {
        if (this.taskInfo != null) {
            this.taskInfo.addWork(workIncrement);
        }
    }

    void clearChildren() {
        this.children.clear();
    }

    Object getParent() {
        return null;
    }

    void setError(IStatus status) {
        this.errorStatus = status;
    }

    boolean isJobInfo() {
        return true;
    }

    void clearTaskInfo() {
        this.taskInfo = null;
    }

    public int compareTo(Object arg0) {
        JobInfo element = (JobInfo)arg0;
        if (element.getJob().getState() == this.getJob().getState()) {
            return this.getJob().getName().compareTo(this.getJob().getName());
        }
        if (this.getJob().getState() == 4) {
            return -1;
        }
        return 1;
    }

    int getPercentDone() {
        if (this.hasTaskInfo()) {
            return (int)this.taskInfo.preWork * 100 / this.taskInfo.totalWork;
        }
        return -1;
    }

    public IStatus getBlockedStatus() {
        return this.blockedStatus;
    }

    public void setBlockedStatus(IStatus blockedStatus) {
        this.blockedStatus = blockedStatus;
    }

    public boolean isBlocked() {
        return this.getBlockedStatus() != null;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancel() {
        this.canceled = true;
        this.job.cancel();
    }
}

