/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.AnimationItem;
import org.eclipse.ui.internal.progress.IJobProgressManagerListener;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.progress.UIJob;

class AnimationManager {
    private static final String RUNNING_ICON = "running.gif";
    private static final String BACKGROUND_ICON = "back.gif";
    private static final String ERROR_ICON = "error.gif";
    private static AnimationManager singleton;
    private ImageData[] animatedData;
    private ImageData[] disabledData;
    private ImageData[] errorData;
    private static String DISABLED_IMAGE_NAME;
    private static String ANIMATED_IMAGE_NAME;
    private static String ERROR_IMAGE_NAME;
    Color background;
    private ImageLoader runLoader = new ImageLoader();
    private ImageLoader errorLoader = new ImageLoader();
    boolean animated = false;
    Job animateJob;
    Job clearJob;
    boolean showingError = false;
    private IJobProgressManagerListener listener;
    List items = Collections.synchronizedList(new ArrayList());

    static {
        DISABLED_IMAGE_NAME = "ANIMATION_DISABLED_IMAGE";
        ANIMATED_IMAGE_NAME = "ANIMATION_ANIMATED_IMAGE";
        ERROR_IMAGE_NAME = "ANIMATION_ERROR_IMAGE";
    }

    static AnimationManager getInstance() {
        if (singleton == null) {
            singleton = new AnimationManager();
        }
        return singleton;
    }

    AnimationManager() {
        URL iconsRoot = Platform.getPlugin((String)"org.eclipse.ui").find((IPath)new Path("icons/full/progress/"));
        ProgressManager manager = ProgressManager.getInstance();
        try {
            URL runningRoot = new URL(iconsRoot, RUNNING_ICON);
            URL backRoot = new URL(iconsRoot, BACKGROUND_ICON);
            URL errorRoot = new URL(iconsRoot, ERROR_ICON);
            this.animatedData = manager.getImageData(runningRoot, this.runLoader);
            if (this.animatedData != null) {
                JFaceResources.getImageRegistry().put(ANIMATED_IMAGE_NAME, manager.getImage(this.animatedData[0]));
            }
            this.disabledData = manager.getImageData(backRoot, this.runLoader);
            if (this.disabledData != null) {
                JFaceResources.getImageRegistry().put(DISABLED_IMAGE_NAME, manager.getImage(this.disabledData[0]));
            }
            this.errorData = manager.getImageData(errorRoot, this.errorLoader);
            if (this.errorData != null) {
                JFaceResources.getImageRegistry().put(ERROR_IMAGE_NAME, manager.getImage(this.errorData[0]));
            }
            manager.getImageData(backRoot, this.errorLoader);
            this.listener = this.getProgressListener();
            ProgressManager.getInstance().addListener(this.listener);
        }
        catch (MalformedURLException exception) {
            ProgressManagerUtil.logException(exception);
        }
    }

    void addItem(final AnimationItem item) {
        this.items.add(item);
        if (this.background == null) {
            this.background = item.getControl().getDisplay().getSystemColor(22);
        }
        item.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AnimationManager.this.items.remove(item);
            }
        });
    }

    ImageData[] getImageData() {
        if (this.animated) {
            if (this.showingError) {
                return this.errorData;
            }
            return this.animatedData;
        }
        return this.disabledData;
    }

    Image getImage() {
        if (this.animated) {
            if (this.showingError) {
                return JFaceResources.getImageRegistry().get(ERROR_IMAGE_NAME);
            }
            return JFaceResources.getImageRegistry().get(ANIMATED_IMAGE_NAME);
        }
        return JFaceResources.getImageRegistry().get(DISABLED_IMAGE_NAME);
    }

    boolean isAnimated() {
        return this.animated;
    }

    void setAnimated(boolean bool) {
        this.animated = bool;
        if (bool) {
            ImageData[] imageDataArray = this.getImageData();
            if (this.isAnimated() && imageDataArray.length > 1) {
                this.getAnimateJob().schedule();
            }
        } else {
            this.showingError = false;
        }
    }

    void dispose() {
        this.setAnimated(false);
        ProgressManager.getInstance().removeListener(this.listener);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void animateLoop(IProgressMonitor monitor) {
        if (this.items.size() == 0) {
            return;
        }
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        animationItems = this.getAnimationItems();
        startErrorState = this.showingError;
        display = PlatformUI.getWorkbench().getDisplay();
        imageDataArray = this.getImageData();
        imageData = imageDataArray[0];
        image = ProgressManager.getInstance().getImage(imageData);
        imageDataIndex = 0;
        loader = this.getLoader();
        if (display.isDisposed()) {
            monitor.setCanceled(true);
            this.setAnimated(false);
            return;
        }
        offScreenImage = new Image((Device)display, loader.logicalScreenWidth, loader.logicalScreenHeight);
        offScreenImageGC = new GC((Drawable)offScreenImage);
        try {
            offScreenImageGC.setBackground(this.background);
            offScreenImageGC.fillRectangle(0, 0, loader.logicalScreenWidth, loader.logicalScreenHeight);
            offScreenImageGC.drawImage(image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
            if (loader.repeatCount > 0) {
                while (this.isAnimated() && !monitor.isCanceled() && startErrorState == this.showingError) {
                    block23: {
                        if (display.isDisposed()) {
                            monitor.setCanceled(true);
                            continue;
                        }
                        if (imageData.disposalMethod == 2) {
                            bgColor = null;
                            backgroundPixel = loader.backgroundPixel;
                            if (backgroundPixel != -1) {
                                backgroundRGB = imageData.palette.getRGB(backgroundPixel);
                                bgColor = new Color(null, backgroundRGB);
                            }
                            try {
                                offScreenImageGC.setBackground(bgColor != null ? bgColor : this.background);
                                offScreenImageGC.fillRectangle(imageData.x, imageData.y, imageData.width, imageData.height);
                            }
                            catch (Throwable var15_18) {
                                backgroundRGB = null;
                                if (bgColor == null) throw var15_18;
                                bgColor.dispose();
                                throw var15_18;
                            }
                            {
                                backgroundRGB = null;
                                if (bgColor != null) {
                                    bgColor.dispose();
                                }
                                break block23;
                            }
                        }
                        if (imageData.disposalMethod == 3) {
                            offScreenImageGC.drawImage(image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                        }
                    }
                    imageDataIndex = (imageDataIndex + 1) % imageDataArray.length;
                    imageData = imageDataArray[imageDataIndex];
                    image.dispose();
                    image = new Image((Device)display, imageData);
                    offScreenImageGC.drawImage(image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                    refreshItems = false;
                    i = 0;
                    while (true) {
                        if (i >= animationItems.length) {
                            if (refreshItems) {
                                animationItems = this.getAnimationItems();
                            }
                            ** try [egrp 3[TRYBLOCK] [2 : 528->547)] { 
lbl63:
                            // 1 sources

                            break;
                        }
                        item = animationItems[i];
                        if (item.imageCanvasGC.isDisposed()) {
                            refreshItems = true;
                        } else {
                            item.imageCanvasGC.drawImage(offScreenImage, 0, 0);
                        }
                        ++i;
                    }
                    {
                        Thread.sleep(this.visibleDelay(imageData.delayTime * 10));
                        continue;
                    }
lbl73:
                    // 1 sources

                    catch (InterruptedException var13_16) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable var17_19) {
            var16_20 = null;
            image.dispose();
            offScreenImage.dispose();
            offScreenImageGC.dispose();
            throw var17_19;
        }
        {
            var16_21 = null;
        }
        image.dispose();
        offScreenImage.dispose();
        offScreenImageGC.dispose();
    }

    AnimationItem[] getAnimationItems() {
        AnimationItem[] animationItems = new AnimationItem[this.items.size()];
        this.items.toArray(animationItems);
        return animationItems;
    }

    int visibleDelay(int ms) {
        if (ms < 20) {
            return ms + 30;
        }
        if (ms < 30) {
            return ms + 10;
        }
        return ms;
    }

    public Rectangle getImageBounds() {
        return JFaceResources.getImageRegistry().get(DISABLED_IMAGE_NAME).getBounds();
    }

    private IJobProgressManagerListener getProgressListener() {
        return new IJobProgressManagerListener(){
            HashSet jobs = new HashSet();

            public void add(JobInfo info) {
                this.incrementJobCount(info);
            }

            public void refresh(JobInfo info) {
                if (info.getErrorStatus() != null) {
                    AnimationManager.this.showingError = true;
                } else {
                    int state = info.getJob().getState();
                    if (state == 4) {
                        this.add(info);
                    } else {
                        this.remove(info);
                    }
                }
            }

            public void refreshAll() {
                ProgressManager manager = ProgressManager.getInstance();
                AnimationManager.this.showingError = manager.hasErrorsDisplayed();
                this.jobs.clear();
                AnimationManager.this.setAnimated(false);
                JobInfo[] currentInfos = manager.getJobInfos(this.showsDebug());
                int i = 0;
                while (i < currentInfos.length) {
                    JobInfo info = currentInfos[i];
                    if (!manager.isNonDisplayableJob(info.getJob(), this.showsDebug())) {
                        this.add(currentInfos[i]);
                    }
                    ++i;
                }
            }

            public void remove(JobInfo info) {
                if (this.jobs.contains(info.getJob())) {
                    this.decrementJobCount(info.getJob());
                }
            }

            public boolean showsDebug() {
                return false;
            }

            private void incrementJobCount(JobInfo info) {
                if (this.isNotTracked(info)) {
                    return;
                }
                if (this.jobs.isEmpty()) {
                    AnimationManager.this.setAnimated(true);
                }
                this.jobs.add(info.getJob());
            }

            private void decrementJobCount(Job job) {
                this.jobs.remove(job);
                if (this.jobs.isEmpty()) {
                    AnimationManager.this.setAnimated(false);
                }
            }

            private boolean isNotTracked(JobInfo info) {
                if (info.getErrorStatus() == null) {
                    Job job = info.getJob();
                    return job.getState() != 4 || job == AnimationManager.this.clearJob || job == AnimationManager.this.animateJob;
                }
                return false;
            }
        };
    }

    private Job getAnimateJob() {
        if (this.animateJob == null) {
            this.animateJob = new Job(ProgressMessages.getString("AnimateJob.JobName")){

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        AnimationManager.this.animateLoop(monitor);
                        return Status.OK_STATUS;
                    }
                    catch (SWTException exception) {
                        return ProgressManagerUtil.exceptionStatus(exception);
                    }
                }

                public boolean shouldSchedule() {
                    return PlatformUI.isWorkbenchRunning();
                }
            };
            this.animateJob.setSystem(true);
            this.animateJob.setPriority(50);
            this.animateJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (AnimationManager.this.isAnimated() && AnimationManager.this.items.size() > 0) {
                        AnimationManager.this.animateJob.schedule();
                    } else {
                        if (AnimationManager.this.clearJob == null) {
                            AnimationManager.this.createClearJob();
                        }
                        AnimationManager.this.clearJob.schedule();
                    }
                }
            });
        }
        return this.animateJob;
    }

    void createClearJob() {
        this.clearJob = new UIJob(ProgressMessages.getString("AnimationItem.RedrawJob")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                AnimationItem[] animationItems = AnimationManager.this.getAnimationItems();
                int i = 0;
                while (i < animationItems.length) {
                    if (!animationItems[i].getControl().isDisposed()) {
                        animationItems[i].getControl().redraw();
                    }
                    ++i;
                }
                return Status.OK_STATUS;
            }
        };
        this.clearJob.setSystem(true);
        this.clearJob.setPriority(50);
    }

    ImageLoader getLoader() {
        if (this.showingError) {
            return this.errorLoader;
        }
        return this.runLoader;
    }
}

