/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.internal.misc.WorkbookPage;

public class Workbook {
    private TabFolder tabFolder;
    private TabItem selectedTab;

    public Workbook(Composite parent, int style) {
        this.tabFolder = new TabFolder(parent, style);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WorkbookPage selectedPage;
                TabItem newSelectedTab = (TabItem)event.item;
                if (Workbook.this.selectedTab == newSelectedTab) {
                    return;
                }
                if (Workbook.this.selectedTab != null && !Workbook.this.selectedTab.isDisposed() && !(selectedPage = Workbook.this.getWorkbookPage(Workbook.this.selectedTab)).deactivate()) {
                    Workbook.this.tabFolder.setSelection(new TabItem[]{Workbook.this.selectedTab});
                    return;
                }
                Workbook.this.selectedTab = newSelectedTab;
                WorkbookPage newSelectedPage = Workbook.this.getWorkbookPage(newSelectedTab);
                newSelectedPage.activate();
            }
        });
    }

    public WorkbookPage getSelectedPage() {
        int index = this.tabFolder.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        TabItem selectedItem = this.tabFolder.getItem(index);
        return (WorkbookPage)selectedItem.getData();
    }

    public TabFolder getTabFolder() {
        return this.tabFolder;
    }

    protected WorkbookPage getWorkbookPage(TabItem item) {
        try {
            return (WorkbookPage)item.getData();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public WorkbookPage[] getWorkbookPages() {
        TabItem[] tabItems = this.tabFolder.getItems();
        int nItems = tabItems.length;
        WorkbookPage[] workbookPages = new WorkbookPage[nItems];
        int i = 0;
        while (i < nItems) {
            workbookPages[i] = this.getWorkbookPage(tabItems[i]);
            ++i;
        }
        return workbookPages;
    }

    public void setSelectedPage(WorkbookPage workbookPage) {
        TabItem newSelectedTab = workbookPage.getTabItem();
        if (this.selectedTab == newSelectedTab) {
            return;
        }
        this.selectedTab = newSelectedTab;
        workbookPage.activate();
        this.tabFolder.setSelection(new TabItem[]{newSelectedTab});
    }
}

