/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.misc.WorkInProgressMessages;

public class WorkInProgressPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int SLOW = 1;
    private static final int FAST = 5;
    private Slider slider;
    private Label displayLabel;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(WorkInProgressMessages.getString("WorkInProgressPreferencePage.0_label"));
        GridData data = new GridData();
        label.setLayoutData((Object)data);
        this.slider = new Slider(composite, 256);
        data = new GridData(768);
        this.slider.setLayoutData((Object)data);
        this.displayLabel = new Label(composite, 0);
        data = new GridData(64);
        data.widthHint = this.convertWidthInCharsToPixels(10);
        this.displayLabel.setLayoutData((Object)data);
        Label description = new Label(composite, 64);
        description.setText(WorkInProgressMessages.getString("WorkInProgressPreferencePage.SpeedExplanation"));
        GridData descriptionData = new GridData();
        descriptionData.horizontalSpan = 3;
        description.setLayoutData((Object)descriptionData);
        this.slider.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WorkInProgressPreferencePage.this.setLabelText(((Slider)e.widget).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.slider.setValues(this.getValue(), 1, 6, 1, 1, 1);
        int value = this.getValue();
        this.slider.setSelection(value);
        this.setLabelText(value);
        return composite;
    }

    protected void setLabelText(int value) {
        String string;
        switch (value) {
            case 1: {
                string = WorkInProgressMessages.getString("WorkInProgressPreferencePage.SlowTitle");
                break;
            }
            case 5: {
                string = WorkInProgressMessages.getString("WorkInProgressPreferencePage.FastTitle");
                break;
            }
            default: {
                string = WorkInProgressMessages.getString("WorkInProgressPreferencePage.MediumTitle");
            }
        }
        this.displayLabel.setText(string);
        this.displayLabel.redraw();
    }

    private int getValue() {
        int value = Platform.getPlugin((String)"org.eclipse.core.runtime").getPluginPreferences().getInt("runtime.performance");
        if (value < 1) {
            return 5;
        }
        return value;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        Platform.getPlugin((String)"org.eclipse.core.runtime").getPluginPreferences().setValue("runtime.performance", this.slider.getSelection());
        return super.performOk();
    }

    protected void performDefaults() {
        this.slider.setSelection(5);
        this.setLabelText(5);
    }
}

