/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import java.util.HashMap;
import java.util.Map;

public class Stopwatch {
    private long startTime;
    private long lastTime;
    private String name;
    private static Map registry;

    public Stopwatch(String name) {
        this.name = name;
        this.start();
    }

    public static Stopwatch getStopwatch(String name) {
        if (registry != null) {
            return (Stopwatch)registry.get(name);
        }
        return null;
    }

    public void printInterval(String hint) {
        long time = System.currentTimeMillis() - this.lastTime;
        System.out.println(String.valueOf(this.name) + " '" + hint + "' took " + time + " ms");
        this.lastTime = System.currentTimeMillis();
    }

    public void printTime() {
        long time = System.currentTimeMillis() - this.startTime;
        System.out.print(String.valueOf(this.name) + " is now " + time + " ms");
    }

    public void register() {
        if (registry == null) {
            registry = new HashMap(2);
        }
        registry.put(this.name, this);
    }

    public void resetInterval() {
        this.lastTime = System.currentTimeMillis();
    }

    public void start() {
        this.startTime = this.lastTime = System.currentTimeMillis();
        System.out.println(String.valueOf(this.name) + " started");
    }

    public void stop() {
        long time = System.currentTimeMillis() - this.startTime;
        System.out.println(String.valueOf(this.name) + " finished in " + time + " ms");
    }

    public void unregister() {
        if (registry != null) {
            registry.remove(this.name);
        }
    }
}

