/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.NotDefinedException;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.commands.CommandManager;
import org.eclipse.ui.internal.keys.KeyBindingState;
import org.eclipse.ui.internal.keys.OutOfOrderListener;
import org.eclipse.ui.internal.keys.OutOfOrderVerifyListener;
import org.eclipse.ui.internal.util.StatusLineContributionItem;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.ParseException;
import org.eclipse.ui.keys.SWTKeySupport;

public class WorkbenchKeyboard {
    private static final boolean DEBUG = false;
    private static final int MULTI_KEY_ASSIST_SHELL_MAX_HEIGHT = 175;
    private static final int MULTI_KEY_ASSIST_SHELL_MAX_WIDTH = 300;
    static final String OUT_OF_ORDER_KEYS = "OutOfOrderKeys";
    static KeySequence outOfOrderKeys;
    private static final ResourceBundle RESOURCE_BUNDLE;
    private final ICommandManager commandManager;
    private final Listener keyDownFilter = new Listener(){

        public void handleEvent(Event event) {
            WorkbenchKeyboard.this.filterKeySequenceBindings(event);
        }
    };
    private final WeakHashMap managedShells = new WeakHashMap();
    private Shell multiKeyAssistShell = null;
    private long startTime = Long.MAX_VALUE;
    private final KeyBindingState state;
    private final IWindowListener windowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
            WorkbenchKeyboard.this.checkActiveWindow(window);
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    };
    private final IWorkbench workbench;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.keys.WorkbenchKeyboard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RESOURCE_BUNDLE = ResourceBundle.getBundle(clazz.getName());
        WorkbenchKeyboard.initializeOutOfOrderKeys();
    }

    public static List generatePossibleKeyStrokes(Event event) {
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>();
        if (event.stateMask == 0 && event.keyCode == 0 && event.character == '\u0000') {
            return keyStrokes;
        }
        keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke(SWTKeySupport.convertEventToUnmodifiedAccelerator(event)));
        KeyStroke keyStroke = SWTKeySupport.convertAcceleratorToKeyStroke(SWTKeySupport.convertEventToUnshiftedModifiedAccelerator(event));
        if (!keyStrokes.contains(keyStroke)) {
            keyStrokes.add(keyStroke);
        }
        if (!keyStrokes.contains(keyStroke = SWTKeySupport.convertAcceleratorToKeyStroke(SWTKeySupport.convertEventToModifiedAccelerator(event)))) {
            keyStrokes.add(keyStroke);
        }
        return keyStrokes;
    }

    private static void initializeOutOfOrderKeys() {
        String keysText = WorkbenchMessages.getString(OUT_OF_ORDER_KEYS);
        outOfOrderKeys = KeySequence.getInstance();
        try {
            outOfOrderKeys = KeySequence.getInstance(keysText);
        }
        catch (ParseException e) {
            String message = "Could not parse out-of-order keys definition: '" + keysText + "'.  Continuing with no out-of-order keys.";
            WorkbenchPlugin.log(message, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, message, (Throwable)e));
        }
    }

    private static boolean isOutOfOrderKey(List keyStrokes) {
        Iterator keyStrokeItr = keyStrokes.iterator();
        while (keyStrokeItr.hasNext()) {
            if (!outOfOrderKeys.getKeyStrokes().contains(keyStrokeItr.next())) continue;
            return true;
        }
        return false;
    }

    public WorkbenchKeyboard(Workbench associatedWorkbench, ICommandManager associatedCommandManager) {
        this.workbench = associatedWorkbench;
        this.state = new KeyBindingState(associatedWorkbench);
        this.commandManager = associatedCommandManager;
        this.workbench.addWindowListener(this.windowListener);
    }

    private void checkActiveWindow(IWorkbenchWindow window) {
        if (!window.equals(this.state.getAssociatedWindow())) {
            this.resetState();
            this.state.setAssociatedWindow(window);
        }
    }

    private void closeMultiKeyAssistShell() {
        if (this.multiKeyAssistShell != null && !this.multiKeyAssistShell.isDisposed()) {
            this.deregister(this.multiKeyAssistShell);
            this.multiKeyAssistShell.close();
            this.multiKeyAssistShell = null;
        }
    }

    public void deregister(Shell shell) {
        this.managedShells.remove(shell);
    }

    private boolean executeCommand(String commandId, Event event) {
        this.resetState();
        Map actionsById = ((CommandManager)this.commandManager).getActionsById();
        IHandler action = (IHandler)actionsById.get(commandId);
        if (action != null && action.isEnabled()) {
            try {
                action.execute(event);
            }
            catch (Exception e) {
                String message = "Action for command '" + commandId + "' failed to execute properly.";
                WorkbenchPlugin.log(message, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, message, (Throwable)e));
            }
        }
        return action != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void filterKeySequenceBindings(Event event) {
        List keyStrokes;
        if ((event.keyCode & SWT.MODIFIER_MASK) != 0) {
            return;
        }
        boolean dialogOnly = false;
        if (event.widget instanceof Control) {
            Shell shell = ((Control)event.widget).getShell();
            Boolean dialog = (Boolean)this.managedShells.get(shell);
            if (dialog == null) {
                if (shell == null || shell.getParent() == null) return;
                dialogOnly = true;
            } else if (dialog.booleanValue()) {
                dialogOnly = true;
            }
        }
        if (WorkbenchKeyboard.isOutOfOrderKey(keyStrokes = WorkbenchKeyboard.generatePossibleKeyStrokes(event))) {
            if (event.type != 1) return;
            Widget widget = event.widget;
            if (widget instanceof StyledText) {
                ((StyledText)widget).addVerifyKeyListener((VerifyKeyListener)new OutOfOrderVerifyListener(new OutOfOrderListener(this, dialogOnly)));
                return;
            } else {
                widget.addListener(1, (Listener)new OutOfOrderListener(this, dialogOnly));
            }
            return;
        } else {
            this.processKeyEvent(keyStrokes, event, dialogOnly);
        }
    }

    public Listener getKeyDownFilter() {
        return this.keyDownFilter;
    }

    private String getPerfectMatch(KeySequence keySequence) {
        return this.commandManager.getPerfectMatch(keySequence);
    }

    private void incrementState(KeySequence sequence) {
        this.startTime = System.currentTimeMillis();
        this.state.setCurrentSequence(sequence);
        this.state.setAssociatedWindow(this.workbench.getActiveWorkbenchWindow());
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("MULTI_KEY_ASSIST")) {
            final Display display = this.workbench.getDisplay();
            display.timerExec(1000 * store.getInt("MULTI_KEY_ASSIST_TIME"), new Runnable(){

                public void run() {
                    if (System.currentTimeMillis() > WorkbenchKeyboard.this.startTime - 1000L) {
                        WorkbenchKeyboard.this.openMultiKeyAssistShell(display);
                    }
                }
            });
        }
    }

    private boolean isPartialMatch(KeySequence keySequence) {
        return this.commandManager.isPartialMatch(keySequence);
    }

    private boolean isPerfectMatch(KeySequence keySequence) {
        return this.commandManager.isPerfectMatch(keySequence);
    }

    private void openMultiKeyAssistShell(Display display) {
        StatusLineContributionItem statusLine = this.state.getStatusLine();
        if (statusLine == null) {
            return;
        }
        Point statusLineLocation = statusLine.getDisplayLocation();
        if (statusLineLocation == null) {
            return;
        }
        this.multiKeyAssistShell = new Shell(display, 8);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.multiKeyAssistShell.setLayout((Layout)layout);
        this.multiKeyAssistShell.setBackground(display.getSystemColor(29));
        TreeMap partialMatches = new TreeMap(new Comparator(){

            public int compare(Object a, Object b) {
                KeySequence sequenceA = (KeySequence)a;
                KeySequence sequenceB = (KeySequence)b;
                return sequenceA.format().compareTo(sequenceB.format());
            }
        });
        partialMatches.putAll(this.commandManager.getPartialMatches(this.state.getCurrentSequence()));
        Iterator partialMatchItr = partialMatches.entrySet().iterator();
        while (partialMatchItr.hasNext()) {
            Map.Entry entry = partialMatchItr.next();
            String commandId = (String)entry.getValue();
            ICommand command = this.commandManager.getCommand(commandId);
            if (command.isDefined() && command.isActive()) continue;
            partialMatchItr.remove();
        }
        if (partialMatches.isEmpty()) {
            Label noMatchesLabel = new Label((Composite)this.multiKeyAssistShell, 0);
            noMatchesLabel.setText(Util.translateString(RESOURCE_BUNDLE, "NoMatches.Message"));
            noMatchesLabel.setLayoutData((Object)new GridData(1808));
            noMatchesLabel.setBackground(this.multiKeyAssistShell.getBackground());
        } else {
            final Table completionsTable = new Table((Composite)this.multiKeyAssistShell, 4);
            completionsTable.setBackground(this.multiKeyAssistShell.getBackground());
            GridData gridData = new GridData(1808);
            completionsTable.setLayoutData((Object)gridData);
            final ArrayList<ICommand> commands = new ArrayList<ICommand>();
            TableColumn columnKeySequence = new TableColumn(completionsTable, 16384, 0);
            TableColumn columnCommandName = new TableColumn(completionsTable, 16384, 1);
            Iterator itemsItr = partialMatches.entrySet().iterator();
            while (itemsItr.hasNext()) {
                Map.Entry entry = itemsItr.next();
                KeySequence sequence = (KeySequence)entry.getKey();
                String commandId = (String)entry.getValue();
                ICommand command = this.commandManager.getCommand(commandId);
                try {
                    String[] text = new String[]{sequence.format(), command.getName()};
                    TableItem item = new TableItem(completionsTable, 0);
                    item.setText(text);
                    commands.add(command);
                }
                catch (NotDefinedException notDefinedException) {
                    // empty catch block
                }
            }
            columnKeySequence.pack();
            columnCommandName.pack();
            completionsTable.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    int selectionIndex = completionsTable.getSelectionIndex();
                    if (selectionIndex >= 0) {
                        ICommand command = (ICommand)commands.get(selectionIndex);
                        WorkbenchKeyboard.this.executeCommand(command.getId(), new Event());
                    }
                }

                public void widgetSelected(SelectionEvent e) {
                }
            });
        }
        this.multiKeyAssistShell.pack();
        Point assistShellSize = this.multiKeyAssistShell.getSize();
        if (assistShellSize.x > 300) {
            assistShellSize.x = 300;
        }
        if (assistShellSize.y > 175) {
            assistShellSize.y = 175;
        }
        this.multiKeyAssistShell.setSize(assistShellSize);
        Point assistShellLocation = new Point(statusLineLocation.x, statusLineLocation.y - assistShellSize.y);
        Rectangle displayBounds = display.getBounds();
        int displayRightEdge = displayBounds.x + displayBounds.width;
        if (assistShellLocation.x < displayBounds.x) {
            assistShellLocation.x = displayBounds.x;
        } else if (assistShellLocation.x + assistShellSize.x > displayRightEdge) {
            assistShellLocation.x = displayRightEdge - assistShellSize.x;
        }
        int displayBottomEdge = displayBounds.y + displayBounds.height;
        if (assistShellLocation.y < displayBounds.y) {
            assistShellLocation.y = displayBounds.y;
        } else if (assistShellLocation.y + assistShellSize.y > displayBottomEdge) {
            assistShellLocation.y = displayBottomEdge - assistShellSize.y;
        }
        this.multiKeyAssistShell.setLocation(assistShellLocation);
        this.multiKeyAssistShell.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                WorkbenchKeyboard.this.closeMultiKeyAssistShell();
            }
        });
        this.register(this.multiKeyAssistShell, false);
        this.multiKeyAssistShell.open();
    }

    public boolean press(List potentialKeyStrokes, Event event, boolean dialogOnly) {
        if (dialogOnly) {
            return false;
        }
        KeySequence sequenceBeforeKeyStroke = this.state.getCurrentSequence();
        Iterator iterator = potentialKeyStrokes.iterator();
        while (iterator.hasNext()) {
            KeySequence sequenceAfterKeyStroke = KeySequence.getInstance(sequenceBeforeKeyStroke, (KeyStroke)iterator.next());
            if (this.isPartialMatch(sequenceAfterKeyStroke)) {
                this.incrementState(sequenceAfterKeyStroke);
                return true;
            }
            if (this.isPerfectMatch(sequenceAfterKeyStroke)) {
                String commandId = this.getPerfectMatch(sequenceAfterKeyStroke);
                return this.executeCommand(commandId, event) || sequenceBeforeKeyStroke.isEmpty();
            }
            if (this.multiKeyAssistShell == null || event.keyCode != 0x1000002 && event.keyCode != 0x1000001 && event.keyCode != 0x1000003 && event.keyCode != 0x1000004 && event.keyCode != 13) continue;
            return false;
        }
        this.resetState();
        return false;
    }

    void processKeyEvent(List keyStrokes, Event event, boolean dialogOnly) {
        if (!keyStrokes.isEmpty() && this.press(keyStrokes, event, dialogOnly)) {
            switch (event.type) {
                case 1: {
                    event.doit = false;
                    break;
                }
                case 31: {
                    event.detail = 0;
                    event.doit = true;
                }
            }
            event.type = 0;
        }
    }

    public void register(Shell shell, boolean dialogOnly) {
        this.managedShells.put(shell, dialogOnly ? Boolean.TRUE : Boolean.FALSE);
    }

    private void resetState() {
        this.startTime = Long.MAX_VALUE;
        this.state.reset();
        this.closeMultiKeyAssistShell();
    }
}

