/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.util.Comparator;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.ui.internal.keys.AbstractKeyFormatter;
import org.eclipse.ui.internal.keys.NativeModifierKeyComparator;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.IKeyFormatter;
import org.eclipse.ui.keys.Key;

public class NativeKeyFormatter
extends AbstractKeyFormatter {
    private static final String CARBON_KEY_DELIMITER_KEY = "CARBON_KEY_DELIMITER";
    private static final HashMap CARBON_KEY_LOOK_UP = new HashMap();
    private static final Comparator MODIFIER_KEY_COMPARATOR = new NativeModifierKeyComparator();
    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final String WIN32_KEY_STROKE_DELIMITER_KEY = "WIN32_KEY_STROKE_DELIMITER";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.keys.NativeKeyFormatter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RESOURCE_BUNDLE = ResourceBundle.getBundle(clazz.getName());
        CARBON_KEY_LOOK_UP.put("BS", Character.toString('\u232b'));
        CARBON_KEY_LOOK_UP.put("CR", Character.toString('\u21a9'));
        CARBON_KEY_LOOK_UP.put("DEL", Character.toString('\u2326'));
        CARBON_KEY_LOOK_UP.put("SPACE", Character.toString('\u2423'));
        CARBON_KEY_LOOK_UP.put("ALT", Character.toString('\u2325'));
        CARBON_KEY_LOOK_UP.put("COMMAND", Character.toString('\u2318'));
        CARBON_KEY_LOOK_UP.put("CTRL", Character.toString('\u2303'));
        CARBON_KEY_LOOK_UP.put("SHIFT", Character.toString('\u21e7'));
        CARBON_KEY_LOOK_UP.put("ARROW_DOWN", Character.toString('\u2193'));
        CARBON_KEY_LOOK_UP.put("ARROW_LEFT", Character.toString('\u2190'));
        CARBON_KEY_LOOK_UP.put("ARROW_RIGHT", Character.toString('\u2192'));
        CARBON_KEY_LOOK_UP.put("ARROW_UP", Character.toString('\u2191'));
        CARBON_KEY_LOOK_UP.put("END", Character.toString('\u2198'));
        CARBON_KEY_LOOK_UP.put("NUMPAD_ENTER", Character.toString('\u2324'));
        CARBON_KEY_LOOK_UP.put("HOME", Character.toString('\u2196'));
        CARBON_KEY_LOOK_UP.put("PAGE_DOWN", Character.toString('\u21df'));
        CARBON_KEY_LOOK_UP.put("PAGE_UP", Character.toString('\u21de'));
    }

    public String format(Key key) {
        String formattedName;
        String name = key.toString();
        if ("carbon".equals(SWT.getPlatform()) && (formattedName = (String)CARBON_KEY_LOOK_UP.get(name)) != null) {
            return formattedName;
        }
        return super.format(key);
    }

    protected String getKeyDelimiter() {
        if ("carbon".equals(SWT.getPlatform())) {
            return Util.translateString(RESOURCE_BUNDLE, CARBON_KEY_DELIMITER_KEY, "", false, false);
        }
        return Util.translateString(RESOURCE_BUNDLE, "KEY_DELIMITER", IKeyFormatter.KEY_DELIMITER, false, false);
    }

    protected String getKeyStrokeDelimiter() {
        if ("win32".equals(SWT.getPlatform())) {
            return Util.translateString(RESOURCE_BUNDLE, WIN32_KEY_STROKE_DELIMITER_KEY, IKeyFormatter.KEY_STROKE_DELIMITER, false, false);
        }
        return Util.translateString(RESOURCE_BUNDLE, "KEY_STROKE_DELIMITER", IKeyFormatter.KEY_STROKE_DELIMITER, false, false);
    }

    protected Comparator getModifierKeyComparator() {
        return MODIFIER_KEY_COMPARATOR;
    }
}

