/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.util.Comparator;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.eclipse.ui.internal.keys.AbstractKeyFormatter;
import org.eclipse.ui.internal.keys.AbstractModifierKeyComparator;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.IKeyFormatter;
import org.eclipse.ui.keys.Key;
import org.eclipse.ui.keys.ModifierKey;

public final class MacKeyFormatter
extends AbstractKeyFormatter {
    private static final HashMap KEY_LOOKUP = new HashMap();
    private static final Comparator MODIFIER_KEY_COMPARATOR = new MacModifierKeyComparator();
    private static final ResourceBundle RESOURCE_BUNDLE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.keys.MacKeyFormatter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RESOURCE_BUNDLE = ResourceBundle.getBundle(clazz.getName());
        KEY_LOOKUP.put("BS", Character.toString('\u232b'));
        KEY_LOOKUP.put("CR", Character.toString('\u21a9'));
        KEY_LOOKUP.put("DEL", Character.toString('\u2326'));
        KEY_LOOKUP.put("SPACE", Character.toString('\u2423'));
        KEY_LOOKUP.put("ALT", Character.toString('\u2325'));
        KEY_LOOKUP.put("COMMAND", Character.toString('\u2318'));
        KEY_LOOKUP.put("CTRL", Character.toString('\u2303'));
        KEY_LOOKUP.put("SHIFT", Character.toString('\u21e7'));
        KEY_LOOKUP.put("ARROW_DOWN", Character.toString('\u2193'));
        KEY_LOOKUP.put("ARROW_LEFT", Character.toString('\u2190'));
        KEY_LOOKUP.put("ARROW_RIGHT", Character.toString('\u2192'));
        KEY_LOOKUP.put("ARROW_UP", Character.toString('\u2191'));
        KEY_LOOKUP.put("END", Character.toString('\u2198'));
        KEY_LOOKUP.put("NUMPAD_ENTER", Character.toString('\u2324'));
        KEY_LOOKUP.put("HOME", Character.toString('\u2196'));
        KEY_LOOKUP.put("PAGE_DOWN", Character.toString('\u21df'));
        KEY_LOOKUP.put("PAGE_UP", Character.toString('\u21de'));
    }

    public String format(Key key) {
        String string = (String)KEY_LOOKUP.get(key.toString());
        return string != null ? string : super.format(key);
    }

    protected String getKeyDelimiter() {
        return Util.translateString(RESOURCE_BUNDLE, "KEY_DELIMITER", "", false, false);
    }

    protected String getKeyStrokeDelimiter() {
        return Util.translateString(RESOURCE_BUNDLE, "KEY_STROKE_DELIMITER", IKeyFormatter.KEY_STROKE_DELIMITER, false, false);
    }

    protected Comparator getModifierKeyComparator() {
        return MODIFIER_KEY_COMPARATOR;
    }

    private static final class MacModifierKeyComparator
    extends AbstractModifierKeyComparator {
        MacModifierKeyComparator() {
        }

        protected int rank(ModifierKey modifierKey) {
            if (ModifierKey.SHIFT.equals(modifierKey)) {
                return 0;
            }
            if (ModifierKey.CTRL.equals(modifierKey)) {
                return 1;
            }
            if (ModifierKey.ALT.equals(modifierKey)) {
                return 2;
            }
            if (ModifierKey.COMMAND.equals(modifierKey)) {
                return 3;
            }
            return Integer.MAX_VALUE;
        }
    }
}

